//! # DBus interface proxies for: `org.gnome.OnlineAccounts.Account`, `org.gnome.OnlineAccounts.OAuth2Based`, `org.gnome.OnlineAccounts.OAuthBased`, `org.gnome.OnlineAccounts.PasswordBased`, `org.gnome.OnlineAccounts.Manager`, `org.gnome.OnlineAccounts.Mail`, `org.gnome.OnlineAccounts.Calendar`, `org.gnome.OnlineAccounts.Contacts`, `org.gnome.OnlineAccounts.Chat`, `org.gnome.OnlineAccounts.Documents`, `org.gnome.OnlineAccounts.Maps`, `org.gnome.OnlineAccounts.Music`, `org.gnome.OnlineAccounts.Photos`, `org.gnome.OnlineAccounts.Files`, `org.gnome.OnlineAccounts.Exchange`, `org.gnome.OnlineAccounts.MediaServer`, `org.gnome.OnlineAccounts.Ticketing`, `org.gnome.OnlineAccounts.Todo`, `org.gnome.OnlineAccounts.ReadLater`, `org.gnome.OnlineAccounts.Printers`
//!
//! This code was generated by `zbus-xmlgen` `2.0.0-beta.6` from DBus introspection data.
//! Source: `dbus-interfaces.xml`.
//!
//! You may prefer to adapt it, instead of using it verbatim.
//!
//! More information can be found in the
//! [Writing a client proxy](https://dbus.pages.freedesktop.org/zbus/client.html)
//! section of the zbus documentation.
//!

use zbus::dbus_proxy;

#[dbus_proxy(interface = "org.gnome.OnlineAccounts.Account")]
trait Account {
    /// EnsureCredentials method
    fn ensure_credentials(&self) -> zbus::Result<i32>;

    /// Remove method
    fn remove(&self) -> zbus::Result<()>;

    /// AttentionNeeded property
    #[dbus_proxy(property)]
    fn attention_needed(&self) -> zbus::Result<bool>;

    /// CalendarDisabled property
    #[dbus_proxy(property)]
    fn calendar_disabled(&self) -> zbus::Result<bool>;
    #[dbus_proxy(property)]
    fn set_calendar_disabled(&self, value: bool) -> zbus::Result<()>;

    /// ChatDisabled property
    #[dbus_proxy(property)]
    fn chat_disabled(&self) -> zbus::Result<bool>;
    #[dbus_proxy(property)]
    fn set_chat_disabled(&self, value: bool) -> zbus::Result<()>;

    /// ContactsDisabled property
    #[dbus_proxy(property)]
    fn contacts_disabled(&self) -> zbus::Result<bool>;
    #[dbus_proxy(property)]
    fn set_contacts_disabled(&self, value: bool) -> zbus::Result<()>;

    /// DocumentsDisabled property
    #[dbus_proxy(property)]
    fn documents_disabled(&self) -> zbus::Result<bool>;
    #[dbus_proxy(property)]
    fn set_documents_disabled(&self, value: bool) -> zbus::Result<()>;

    /// FilesDisabled property
    #[dbus_proxy(property)]
    fn files_disabled(&self) -> zbus::Result<bool>;
    #[dbus_proxy(property)]
    fn set_files_disabled(&self, value: bool) -> zbus::Result<()>;

    /// Id property
    #[dbus_proxy(property)]
    fn id(&self) -> zbus::Result<String>;

    /// Identity property
    #[dbus_proxy(property)]
    fn identity(&self) -> zbus::Result<String>;

    /// IsLocked property
    #[dbus_proxy(property)]
    fn is_locked(&self) -> zbus::Result<bool>;

    /// IsTemporary property
    #[dbus_proxy(property)]
    fn is_temporary(&self) -> zbus::Result<bool>;
    #[dbus_proxy(property)]
    fn set_is_temporary(&self, value: bool) -> zbus::Result<()>;

    /// MailDisabled property
    #[dbus_proxy(property)]
    fn mail_disabled(&self) -> zbus::Result<bool>;
    #[dbus_proxy(property)]
    fn set_mail_disabled(&self, value: bool) -> zbus::Result<()>;

    /// MapsDisabled property
    #[dbus_proxy(property)]
    fn maps_disabled(&self) -> zbus::Result<bool>;
    #[dbus_proxy(property)]
    fn set_maps_disabled(&self, value: bool) -> zbus::Result<()>;

    /// MusicDisabled property
    #[dbus_proxy(property)]
    fn music_disabled(&self) -> zbus::Result<bool>;
    #[dbus_proxy(property)]
    fn set_music_disabled(&self, value: bool) -> zbus::Result<()>;

    /// PhotosDisabled property
    #[dbus_proxy(property)]
    fn photos_disabled(&self) -> zbus::Result<bool>;
    #[dbus_proxy(property)]
    fn set_photos_disabled(&self, value: bool) -> zbus::Result<()>;

    /// PresentationIdentity property
    #[dbus_proxy(property)]
    fn presentation_identity(&self) -> zbus::Result<String>;

    /// PrintersDisabled property
    #[dbus_proxy(property)]
    fn printers_disabled(&self) -> zbus::Result<bool>;
    #[dbus_proxy(property)]
    fn set_printers_disabled(&self, value: bool) -> zbus::Result<()>;

    /// ProviderIcon property
    #[dbus_proxy(property)]
    fn provider_icon(&self) -> zbus::Result<String>;

    /// ProviderName property
    #[dbus_proxy(property)]
    fn provider_name(&self) -> zbus::Result<String>;

    /// ProviderType property
    #[dbus_proxy(property)]
    fn provider_type(&self) -> zbus::Result<String>;

    /// ReadLaterDisabled property
    #[dbus_proxy(property)]
    fn read_later_disabled(&self) -> zbus::Result<bool>;
    #[dbus_proxy(property)]
    fn set_read_later_disabled(&self, value: bool) -> zbus::Result<()>;

    /// TicketingDisabled property
    #[dbus_proxy(property)]
    fn ticketing_disabled(&self) -> zbus::Result<bool>;
    #[dbus_proxy(property)]
    fn set_ticketing_disabled(&self, value: bool) -> zbus::Result<()>;

    /// TodoDisabled property
    #[dbus_proxy(property)]
    fn todo_disabled(&self) -> zbus::Result<bool>;
    #[dbus_proxy(property)]
    fn set_todo_disabled(&self, value: bool) -> zbus::Result<()>;
}

#[dbus_proxy(interface = "org.gnome.OnlineAccounts.OAuth2Based")]
trait OAuth2Based {
    /// GetAccessToken method
    fn get_access_token(&self) -> zbus::Result<(String, i32)>;

    /// ClientId property
    #[dbus_proxy(property)]
    fn client_id(&self) -> zbus::Result<String>;

    /// ClientSecret property
    #[dbus_proxy(property)]
    fn client_secret(&self) -> zbus::Result<String>;
}

#[dbus_proxy(interface = "org.gnome.OnlineAccounts.OAuthBased")]
trait OAuthBased {
    /// GetAccessToken method
    fn get_access_token(&self) -> zbus::Result<(String, String, i32)>;

    /// ConsumerKey property
    #[dbus_proxy(property)]
    fn consumer_key(&self) -> zbus::Result<String>;

    /// ConsumerSecret property
    #[dbus_proxy(property)]
    fn consumer_secret(&self) -> zbus::Result<String>;
}

#[dbus_proxy(interface = "org.gnome.OnlineAccounts.PasswordBased")]
trait PasswordBased {
    /// GetPassword method
    fn get_password(&self, id: &str) -> zbus::Result<String>;
}

#[dbus_proxy(interface = "org.gnome.OnlineAccounts.Manager")]
trait Manager {
    /// AddAccount method
    fn add_account(
        &self,
        provider: &str,
        identity: &str,
        presentation_identity: &str,
        credentials: std::collections::HashMap<&str, zbus::export::zvariant::Value<'_>>,
        details: std::collections::HashMap<&str, &str>,
    ) -> zbus::Result<zbus::export::zvariant::OwnedObjectPath>;

    /// IsSupportedProvider method
    fn is_supported_provider(&self, provider_type: &str) -> zbus::Result<bool>;
}

#[dbus_proxy(interface = "org.gnome.OnlineAccounts.Mail")]
trait Mail {
    /// EmailAddress property
    #[dbus_proxy(property)]
    fn email_address(&self) -> zbus::Result<String>;

    /// ImapAcceptSslErrors property
    #[dbus_proxy(property)]
    fn imap_accept_ssl_errors(&self) -> zbus::Result<bool>;

    /// ImapHost property
    #[dbus_proxy(property)]
    fn imap_host(&self) -> zbus::Result<String>;

    /// ImapSupported property
    #[dbus_proxy(property)]
    fn imap_supported(&self) -> zbus::Result<bool>;

    /// ImapUseSsl property
    #[dbus_proxy(property)]
    fn imap_use_ssl(&self) -> zbus::Result<bool>;

    /// ImapUseTls property
    #[dbus_proxy(property)]
    fn imap_use_tls(&self) -> zbus::Result<bool>;

    /// ImapUserName property
    #[dbus_proxy(property)]
    fn imap_user_name(&self) -> zbus::Result<String>;

    /// Name property
    #[dbus_proxy(property)]
    fn name(&self) -> zbus::Result<String>;

    /// SmtpAcceptSslErrors property
    #[dbus_proxy(property)]
    fn smtp_accept_ssl_errors(&self) -> zbus::Result<bool>;

    /// SmtpAuthLogin property
    #[dbus_proxy(property)]
    fn smtp_auth_login(&self) -> zbus::Result<bool>;

    /// SmtpAuthPlain property
    #[dbus_proxy(property)]
    fn smtp_auth_plain(&self) -> zbus::Result<bool>;

    /// SmtpAuthXoauth2 property
    #[dbus_proxy(property)]
    fn smtp_auth_xoauth2(&self) -> zbus::Result<bool>;

    /// SmtpHost property
    #[dbus_proxy(property)]
    fn smtp_host(&self) -> zbus::Result<String>;

    /// SmtpSupported property
    #[dbus_proxy(property)]
    fn smtp_supported(&self) -> zbus::Result<bool>;

    /// SmtpUseAuth property
    #[dbus_proxy(property)]
    fn smtp_use_auth(&self) -> zbus::Result<bool>;

    /// SmtpUseSsl property
    #[dbus_proxy(property)]
    fn smtp_use_ssl(&self) -> zbus::Result<bool>;

    /// SmtpUseTls property
    #[dbus_proxy(property)]
    fn smtp_use_tls(&self) -> zbus::Result<bool>;

    /// SmtpUserName property
    #[dbus_proxy(property)]
    fn smtp_user_name(&self) -> zbus::Result<String>;
}

#[dbus_proxy(interface = "org.gnome.OnlineAccounts.Calendar")]
trait Calendar {
    /// AcceptSslErrors property
    #[dbus_proxy(property)]
    fn accept_ssl_errors(&self) -> zbus::Result<bool>;

    /// Uri property
    #[dbus_proxy(property)]
    fn uri(&self) -> zbus::Result<String>;
}

#[dbus_proxy(interface = "org.gnome.OnlineAccounts.Contacts")]
trait Contacts {
    /// AcceptSslErrors property
    #[dbus_proxy(property)]
    fn accept_ssl_errors(&self) -> zbus::Result<bool>;

    /// Uri property
    #[dbus_proxy(property)]
    fn uri(&self) -> zbus::Result<String>;
}

#[dbus_proxy(interface = "org.gnome.OnlineAccounts.Chat")]
trait Chat {}

#[dbus_proxy(interface = "org.gnome.OnlineAccounts.Documents")]
trait Documents {}

#[dbus_proxy(interface = "org.gnome.OnlineAccounts.Maps")]
trait Maps {}

#[dbus_proxy(interface = "org.gnome.OnlineAccounts.Music")]
trait Music {}

#[dbus_proxy(interface = "org.gnome.OnlineAccounts.Photos")]
trait Photos {}

#[dbus_proxy(interface = "org.gnome.OnlineAccounts.Files")]
trait Files {
    /// AcceptSslErrors property
    #[dbus_proxy(property)]
    fn accept_ssl_errors(&self) -> zbus::Result<bool>;

    /// Uri property
    #[dbus_proxy(property)]
    fn uri(&self) -> zbus::Result<String>;
}

#[dbus_proxy(interface = "org.gnome.OnlineAccounts.Exchange")]
trait Exchange {
    /// AcceptSslErrors property
    #[dbus_proxy(property)]
    fn accept_ssl_errors(&self) -> zbus::Result<bool>;

    /// Host property
    #[dbus_proxy(property)]
    fn host(&self) -> zbus::Result<String>;
}

#[dbus_proxy(interface = "org.gnome.OnlineAccounts.MediaServer")]
trait MediaServer {
    /// DlnaSupported property
    #[dbus_proxy(property)]
    fn dlna_supported(&self) -> zbus::Result<bool>;

    /// Udn property
    #[dbus_proxy(property)]
    fn udn(&self) -> zbus::Result<String>;
}

#[dbus_proxy(interface = "org.gnome.OnlineAccounts.Ticketing")]
trait Ticketing {
    /// GetTicket method
    fn get_ticket(&self) -> zbus::Result<()>;

    /// Details property
    #[dbus_proxy(property)]
    fn details(&self) -> zbus::Result<std::collections::HashMap<String, String>>;
}

#[dbus_proxy(interface = "org.gnome.OnlineAccounts.Todo")]
trait Todo {}

#[dbus_proxy(interface = "org.gnome.OnlineAccounts.ReadLater")]
trait ReadLater {}

#[dbus_proxy(interface = "org.gnome.OnlineAccounts.Printers")]
trait Printers {}
