// This code was autogenerated with `dbus-codegen-rust -g -m None -d org.gnome.Mutter.DisplayConfig -p /org/gnome/Mutter/DisplayConfig`, see https://github.com/diwic/dbus-rs
use dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

pub trait OrgFreedesktopDBusProperties {
    fn get<R0: for<'b> arg::Get<'b> + 'static>(
        &self,
        interface_name: &str,
        property_name: &str,
    ) -> Result<R0, dbus::Error>;
    fn get_all(&self, interface_name: &str) -> Result<arg::PropMap, dbus::Error>;
    fn set<I2: arg::Arg + arg::Append>(
        &self,
        interface_name: &str,
        property_name: &str,
        value: I2,
    ) -> Result<(), dbus::Error>;
}

#[derive(Debug)]
pub struct OrgFreedesktopDBusPropertiesPropertiesChanged {
    pub interface_name: String,
    pub changed_properties: arg::PropMap,
    pub invalidated_properties: Vec<String>,
}

impl arg::AppendAll for OrgFreedesktopDBusPropertiesPropertiesChanged {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.interface_name, i);
        arg::RefArg::append(&self.changed_properties, i);
        arg::RefArg::append(&self.invalidated_properties, i);
    }
}

impl arg::ReadAll for OrgFreedesktopDBusPropertiesPropertiesChanged {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopDBusPropertiesPropertiesChanged {
            interface_name: i.read()?,
            changed_properties: i.read()?,
            invalidated_properties: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopDBusPropertiesPropertiesChanged {
    const NAME: &'static str = "PropertiesChanged";
    const INTERFACE: &'static str = "org.freedesktop.DBus.Properties";
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target = T>> OrgFreedesktopDBusProperties
    for blocking::Proxy<'a, C>
{
    fn get<R0: for<'b> arg::Get<'b> + 'static>(
        &self,
        interface_name: &str,
        property_name: &str,
    ) -> Result<R0, dbus::Error> {
        self.method_call(
            "org.freedesktop.DBus.Properties",
            "Get",
            (interface_name, property_name),
        ).map(|r: (arg::Variant<R0>,)| (r.0).0)
    }

    fn get_all(&self, interface_name: &str) -> Result<arg::PropMap, dbus::Error> {
        self.method_call(
            "org.freedesktop.DBus.Properties",
            "GetAll",
            (interface_name,),
        ).map(|r: (arg::PropMap,)| r.0)
    }

    fn set<I2: arg::Arg + arg::Append>(
        &self,
        interface_name: &str,
        property_name: &str,
        value: I2,
    ) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.DBus.Properties",
            "Set",
            (interface_name, property_name, arg::Variant(value)),
        )
    }
}

pub trait OrgFreedesktopDBusIntrospectable {
    fn introspect(&self) -> Result<String, dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target = T>>
    OrgFreedesktopDBusIntrospectable for blocking::Proxy<'a, C>
{
    fn introspect(&self) -> Result<String, dbus::Error> {
        self.method_call("org.freedesktop.DBus.Introspectable", "Introspect", ()).map(|r: (String,)| r.0)
    }
}

pub trait OrgFreedesktopDBusPeer {
    fn ping(&self) -> Result<(), dbus::Error>;
    fn get_machine_id(&self) -> Result<String, dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target = T>> OrgFreedesktopDBusPeer
    for blocking::Proxy<'a, C>
{
    fn ping(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.DBus.Peer", "Ping", ())
    }

    fn get_machine_id(&self) -> Result<String, dbus::Error> {
        self.method_call("org.freedesktop.DBus.Peer", "GetMachineId", ()).map(|r: (String,)| r.0)
    }
}

pub trait OrgGnomeMutterDisplayConfig {
    fn get_resources(
        &self,
    ) -> Result<
        (
            u32,
            Vec<(
                u32,
                i64,
                i32,
                i32,
                i32,
                i32,
                i32,
                u32,
                Vec<u32>,
                arg::PropMap,
            )>,
            Vec<(
                u32,
                i64,
                i32,
                Vec<u32>,
                String,
                Vec<u32>,
                Vec<u32>,
                arg::PropMap,
            )>,
            Vec<(u32, i64, u32, u32, f64, u32)>,
            i32,
            i32,
        ),
        dbus::Error,
    >;
    fn apply_configuration(
        &self,
        serial: u32,
        persistent: bool,
        crtcs: Vec<(u32, i32, i32, i32, u32, Vec<u32>, arg::PropMap)>,
        outputs: Vec<(u32, arg::PropMap)>,
    ) -> Result<(), dbus::Error>;
    fn change_backlight(&self, serial: u32, output: u32, value: i32) -> Result<i32, dbus::Error>;
    fn get_crtc_gamma(
        &self,
        serial: u32,
        crtc: u32,
    ) -> Result<(Vec<u16>, Vec<u16>, Vec<u16>), dbus::Error>;
    fn set_crtc_gamma(
        &self,
        serial: u32,
        crtc: u32,
        red: Vec<u16>,
        green: Vec<u16>,
        blue: Vec<u16>,
    ) -> Result<(), dbus::Error>;
    fn get_current_state(
        &self,
    ) -> Result<
        (
            u32,
            Vec<(
                (String, String, String, String),
                Vec<(String, i32, i32, f64, f64, Vec<f64>, arg::PropMap)>,
                arg::PropMap,
            )>,
            Vec<(
                i32,
                i32,
                f64,
                u32,
                bool,
                Vec<(String, String, String, String)>,
                arg::PropMap,
            )>,
            arg::PropMap,
        ),
        dbus::Error,
    >;
    fn apply_monitors_config(
        &self,
        serial: u32,
        method: u32,
        logical_monitors: Vec<(i32, i32, f64, u32, bool, Vec<(&str, &str, arg::PropMap)>)>,
        properties: arg::PropMap,
    ) -> Result<(), dbus::Error>;
    fn set_output_ctm(
        &self,
        serial: u32,
        output: u32,
        ctm: (u64, u64, u64, u64, u64, u64, u64, u64, u64),
    ) -> Result<(), dbus::Error>;
    fn power_save_mode(&self) -> Result<i32, dbus::Error>;
    fn set_power_save_mode(&self, value: i32) -> Result<(), dbus::Error>;
    fn panel_orientation_managed(&self) -> Result<bool, dbus::Error>;
}

#[derive(Debug)]
pub struct OrgGnomeMutterDisplayConfigMonitorsChanged {}

impl arg::AppendAll for OrgGnomeMutterDisplayConfigMonitorsChanged {
    fn append(&self, _: &mut arg::IterAppend) {}
}

impl arg::ReadAll for OrgGnomeMutterDisplayConfigMonitorsChanged {
    fn read(_: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgGnomeMutterDisplayConfigMonitorsChanged {})
    }
}

impl dbus::message::SignalArgs for OrgGnomeMutterDisplayConfigMonitorsChanged {
    const NAME: &'static str = "MonitorsChanged";
    const INTERFACE: &'static str = "org.gnome.Mutter.DisplayConfig";
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target = T>> OrgGnomeMutterDisplayConfig
    for blocking::Proxy<'a, C>
{
    fn get_resources(
        &self,
    ) -> Result<
        (
            u32,
            Vec<(
                u32,
                i64,
                i32,
                i32,
                i32,
                i32,
                i32,
                u32,
                Vec<u32>,
                arg::PropMap,
            )>,
            Vec<(
                u32,
                i64,
                i32,
                Vec<u32>,
                String,
                Vec<u32>,
                Vec<u32>,
                arg::PropMap,
            )>,
            Vec<(u32, i64, u32, u32, f64, u32)>,
            i32,
            i32,
        ),
        dbus::Error,
    > {
        self.method_call("org.gnome.Mutter.DisplayConfig", "GetResources", ())
    }

    fn apply_configuration(
        &self,
        serial: u32,
        persistent: bool,
        crtcs: Vec<(u32, i32, i32, i32, u32, Vec<u32>, arg::PropMap)>,
        outputs: Vec<(u32, arg::PropMap)>,
    ) -> Result<(), dbus::Error> {
        self.method_call(
            "org.gnome.Mutter.DisplayConfig",
            "ApplyConfiguration",
            (serial, persistent, crtcs, outputs),
        )
    }

    fn change_backlight(&self, serial: u32, output: u32, value: i32) -> Result<i32, dbus::Error> {
        self.method_call(
            "org.gnome.Mutter.DisplayConfig",
            "ChangeBacklight",
            (serial, output, value),
        ).map(|r: (i32,)| r.0)
    }

    fn get_crtc_gamma(
        &self,
        serial: u32,
        crtc: u32,
    ) -> Result<(Vec<u16>, Vec<u16>, Vec<u16>), dbus::Error> {
        self.method_call(
            "org.gnome.Mutter.DisplayConfig",
            "GetCrtcGamma",
            (serial, crtc),
        )
    }

    fn set_crtc_gamma(
        &self,
        serial: u32,
        crtc: u32,
        red: Vec<u16>,
        green: Vec<u16>,
        blue: Vec<u16>,
    ) -> Result<(), dbus::Error> {
        self.method_call(
            "org.gnome.Mutter.DisplayConfig",
            "SetCrtcGamma",
            (serial, crtc, red, green, blue),
        )
    }

    fn get_current_state(
        &self,
    ) -> Result<
        (
            u32,
            Vec<(
                (String, String, String, String),
                Vec<(String, i32, i32, f64, f64, Vec<f64>, arg::PropMap)>,
                arg::PropMap,
            )>,
            Vec<(
                i32,
                i32,
                f64,
                u32,
                bool,
                Vec<(String, String, String, String)>,
                arg::PropMap,
            )>,
            arg::PropMap,
        ),
        dbus::Error,
    > {
        self.method_call("org.gnome.Mutter.DisplayConfig", "GetCurrentState", ())
    }

    fn apply_monitors_config(
        &self,
        serial: u32,
        method: u32,
        logical_monitors: Vec<(i32, i32, f64, u32, bool, Vec<(&str, &str, arg::PropMap)>)>,
        properties: arg::PropMap,
    ) -> Result<(), dbus::Error> {
        self.method_call(
            "org.gnome.Mutter.DisplayConfig",
            "ApplyMonitorsConfig",
            (serial, method, logical_monitors, properties),
        )
    }

    fn set_output_ctm(
        &self,
        serial: u32,
        output: u32,
        ctm: (u64, u64, u64, u64, u64, u64, u64, u64, u64),
    ) -> Result<(), dbus::Error> {
        self.method_call(
            "org.gnome.Mutter.DisplayConfig",
            "SetOutputCTM",
            (serial, output, ctm),
        )
    }

    fn power_save_mode(&self) -> Result<i32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            self,
            "org.gnome.Mutter.DisplayConfig",
            "PowerSaveMode",
        )
    }

    fn panel_orientation_managed(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            self,
            "org.gnome.Mutter.DisplayConfig",
            "PanelOrientationManaged",
        )
    }

    fn set_power_save_mode(&self, value: i32) -> Result<(), dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::set(
            self,
            "org.gnome.Mutter.DisplayConfig",
            "PowerSaveMode",
            value,
        )
    }
}
