# gmqtt-client

pure-rust implementation of an mqtt5 client

## Examples

```Bash
# Run example client
cargo run --example client

# Listen to what is being published
mosquitto_sub -t 'client/example/publish' --pretty -F '%J'

# Send a message over to the client
mosquitto_pub -t 'client/example/receive' -m "hello" -q 1 -V 5 -r -D publish message-expiry-interval 5

# Send 1000 messages
for i in {0..1000}; do mosquitto_pub -t 'client/example/receive' -m "$i" -q 1 -V 5 -r -D publish message-expiry-interval 5; echo "sending $i"; done
```
