// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/vhdirk/gir-files.git)
// DO NOT EDIT

use crate::InternetAddress;
use glib::object::Cast;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;

glib::wrapper! {
    #[doc(alias = "GMimeInternetAddressMailbox")]
    pub struct InternetAddressMailbox(Object<ffi::InternetAddressMailbox, ffi::InternetAddressMailboxClass>) @extends InternetAddress;

    match fn {
        type_ => || ffi::internet_address_mailbox_get_type(),
    }
}

impl InternetAddressMailbox {
    #[doc(alias = "internet_address_mailbox_new")]
    pub fn new(name: &str, addr: &str) -> InternetAddressMailbox {
        assert_initialized_main_thread!();
        unsafe {
            InternetAddress::from_glib_full(ffi::internet_address_mailbox_new(
                name.to_glib_none().0,
                addr.to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }
}

pub const NONE_INTERNET_ADDRESS_MAILBOX: Option<&InternetAddressMailbox> = None;

pub trait InternetAddressMailboxExt: 'static {
    #[doc(alias = "internet_address_mailbox_get_addr")]
    #[doc(alias = "get_addr")]
    fn addr(&self) -> Option<glib::GString>;

    #[doc(alias = "internet_address_mailbox_get_idn_addr")]
    #[doc(alias = "get_idn_addr")]
    fn idn_addr(&self) -> Option<glib::GString>;

    #[doc(alias = "internet_address_mailbox_set_addr")]
    fn set_addr(&self, addr: &str);
}

impl<O: IsA<InternetAddressMailbox>> InternetAddressMailboxExt for O {
    fn addr(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::internet_address_mailbox_get_addr(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn idn_addr(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::internet_address_mailbox_get_idn_addr(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_addr(&self, addr: &str) {
        unsafe {
            ffi::internet_address_mailbox_set_addr(
                self.as_ref().to_glib_none().0,
                addr.to_glib_none().0,
            );
        }
    }
}

impl fmt::Display for InternetAddressMailbox {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("InternetAddressMailbox")
    }
}
