// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/vhdirk/gir-files.git)
// DO NOT EDIT

use crate::FormatOptions;
use crate::InternetAddress;
use crate::ParserOptions;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "GMimeInternetAddressList")]
    pub struct InternetAddressList(Object<ffi::InternetAddressList, ffi::InternetAddressListClass>);

    match fn {
        type_ => || ffi::internet_address_list_get_type(),
    }
}

impl InternetAddressList {
    #[doc(alias = "internet_address_list_new")]
    pub fn new() -> InternetAddressList {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::internet_address_list_new()) }
    }

    #[doc(alias = "internet_address_list_parse")]
    pub fn parse(options: Option<&ParserOptions>, str: &str) -> Option<InternetAddressList> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::internet_address_list_parse(
                mut_override(options.to_glib_none().0),
                str.to_glib_none().0,
            ))
        }
    }
}

impl Default for InternetAddressList {
    fn default() -> Self {
        Self::new()
    }
}

pub const NONE_INTERNET_ADDRESS_LIST: Option<&InternetAddressList> = None;

pub trait InternetAddressListExt: 'static {
    #[doc(alias = "internet_address_list_add")]
    fn add(&self, ia: &impl IsA<InternetAddress>) -> i32;

    #[doc(alias = "internet_address_list_append")]
    fn append(&self, append: &impl IsA<InternetAddressList>);

    #[doc(alias = "internet_address_list_clear")]
    fn clear(&self);

    #[doc(alias = "internet_address_list_contains")]
    fn contains(&self, ia: &impl IsA<InternetAddress>) -> bool;

    #[doc(alias = "internet_address_list_encode")]
    fn encode(&self, options: Option<&FormatOptions>) -> String;

    #[doc(alias = "internet_address_list_get_address")]
    #[doc(alias = "get_address")]
    fn address(&self, index: i32) -> Option<InternetAddress>;

    #[doc(alias = "internet_address_list_index_of")]
    fn index_of(&self, ia: &impl IsA<InternetAddress>) -> i32;

    #[doc(alias = "internet_address_list_insert")]
    fn insert(&self, index: i32, ia: &impl IsA<InternetAddress>);

    #[doc(alias = "internet_address_list_length")]
    fn length(&self) -> i32;

    #[doc(alias = "internet_address_list_prepend")]
    fn prepend(&self, prepend: &impl IsA<InternetAddressList>);

    #[doc(alias = "internet_address_list_remove")]
    fn remove(&self, ia: &impl IsA<InternetAddress>) -> bool;

    #[doc(alias = "internet_address_list_remove_at")]
    fn remove_at(&self, index: i32) -> bool;

    #[doc(alias = "internet_address_list_set_address")]
    fn set_address(&self, index: i32, ia: &impl IsA<InternetAddress>);

    #[doc(alias = "internet_address_list_to_string")]
    fn to_string(&self, options: Option<&FormatOptions>, encode: bool) -> Option<glib::GString>;
}

impl<O: IsA<InternetAddressList>> InternetAddressListExt for O {
    fn add(&self, ia: &impl IsA<InternetAddress>) -> i32 {
        unsafe {
            ffi::internet_address_list_add(
                self.as_ref().to_glib_none().0,
                ia.as_ref().to_glib_none().0,
            )
        }
    }

    fn append(&self, append: &impl IsA<InternetAddressList>) {
        unsafe {
            ffi::internet_address_list_append(
                self.as_ref().to_glib_none().0,
                append.as_ref().to_glib_none().0,
            );
        }
    }

    fn clear(&self) {
        unsafe {
            ffi::internet_address_list_clear(self.as_ref().to_glib_none().0);
        }
    }

    fn contains(&self, ia: &impl IsA<InternetAddress>) -> bool {
        unsafe {
            from_glib(ffi::internet_address_list_contains(
                self.as_ref().to_glib_none().0,
                ia.as_ref().to_glib_none().0,
            ))
        }
    }

    fn encode(&self, options: Option<&FormatOptions>) -> String {
        unsafe {
            let s = glib::ffi::g_string_new(ptr::null());
            ffi::internet_address_list_encode(
                self.as_ref().to_glib_none().0,
                options.to_glib_none().0 as *mut _,
                s,
            );
            from_glib_full(glib::ffi::g_string_free(s, glib::ffi::GFALSE))
        }
    }

    fn address(&self, index: i32) -> Option<InternetAddress> {
        unsafe {
            from_glib_none(ffi::internet_address_list_get_address(
                self.as_ref().to_glib_none().0,
                index,
            ))
        }
    }

    fn index_of(&self, ia: &impl IsA<InternetAddress>) -> i32 {
        unsafe {
            ffi::internet_address_list_index_of(
                self.as_ref().to_glib_none().0,
                ia.as_ref().to_glib_none().0,
            )
        }
    }

    fn insert(&self, index: i32, ia: &impl IsA<InternetAddress>) {
        unsafe {
            ffi::internet_address_list_insert(
                self.as_ref().to_glib_none().0,
                index,
                ia.as_ref().to_glib_none().0,
            );
        }
    }

    fn length(&self) -> i32 {
        unsafe { ffi::internet_address_list_length(self.as_ref().to_glib_none().0) }
    }

    fn prepend(&self, prepend: &impl IsA<InternetAddressList>) {
        unsafe {
            ffi::internet_address_list_prepend(
                self.as_ref().to_glib_none().0,
                prepend.as_ref().to_glib_none().0,
            );
        }
    }

    fn remove(&self, ia: &impl IsA<InternetAddress>) -> bool {
        unsafe {
            from_glib(ffi::internet_address_list_remove(
                self.as_ref().to_glib_none().0,
                ia.as_ref().to_glib_none().0,
            ))
        }
    }

    fn remove_at(&self, index: i32) -> bool {
        unsafe {
            from_glib(ffi::internet_address_list_remove_at(
                self.as_ref().to_glib_none().0,
                index,
            ))
        }
    }

    fn set_address(&self, index: i32, ia: &impl IsA<InternetAddress>) {
        unsafe {
            ffi::internet_address_list_set_address(
                self.as_ref().to_glib_none().0,
                index,
                ia.as_ref().to_glib_none().0,
            );
        }
    }

    fn to_string(&self, options: Option<&FormatOptions>, encode: bool) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::internet_address_list_to_string(
                self.as_ref().to_glib_none().0,
                mut_override(options.to_glib_none().0),
                encode.into_glib(),
            ))
        }
    }
}

impl fmt::Display for InternetAddressList {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("InternetAddressList")
    }
}
