// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/vhdirk/gir-files.git)
// DO NOT EDIT

use crate::InternetAddress;
use crate::InternetAddressList;
use glib::object::Cast;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;

glib::wrapper! {
    #[doc(alias = "GMimeInternetAddressGroup")]
    pub struct InternetAddressGroup(Object<ffi::InternetAddressGroup, ffi::InternetAddressGroupClass>) @extends InternetAddress;

    match fn {
        type_ => || ffi::internet_address_group_get_type(),
    }
}

impl InternetAddressGroup {
    #[doc(alias = "internet_address_group_new")]
    pub fn new(name: &str) -> InternetAddressGroup {
        assert_initialized_main_thread!();
        unsafe {
            InternetAddress::from_glib_full(ffi::internet_address_group_new(name.to_glib_none().0))
                .unsafe_cast()
        }
    }
}

pub const NONE_INTERNET_ADDRESS_GROUP: Option<&InternetAddressGroup> = None;

pub trait InternetAddressGroupExt: 'static {
    #[doc(alias = "internet_address_group_add_member")]
    fn add_member(&self, member: &impl IsA<InternetAddress>) -> i32;

    #[doc(alias = "internet_address_group_get_members")]
    #[doc(alias = "get_members")]
    fn members(&self) -> Option<InternetAddressList>;

    #[doc(alias = "internet_address_group_set_members")]
    fn set_members(&self, members: &impl IsA<InternetAddressList>);
}

impl<O: IsA<InternetAddressGroup>> InternetAddressGroupExt for O {
    fn add_member(&self, member: &impl IsA<InternetAddress>) -> i32 {
        unsafe {
            ffi::internet_address_group_add_member(
                self.as_ref().to_glib_none().0,
                member.as_ref().to_glib_none().0,
            )
        }
    }

    fn members(&self) -> Option<InternetAddressList> {
        unsafe {
            from_glib_none(ffi::internet_address_group_get_members(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_members(&self, members: &impl IsA<InternetAddressList>) {
        unsafe {
            ffi::internet_address_group_set_members(
                self.as_ref().to_glib_none().0,
                members.as_ref().to_glib_none().0,
            );
        }
    }
}

impl fmt::Display for InternetAddressGroup {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("InternetAddressGroup")
    }
}
