// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/vhdirk/gir-files.git)
// DO NOT EDIT

use crate::Stream;
use glib::object::Cast;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;

glib::wrapper! {
    #[doc(alias = "GMimeStreamPipe")]
    pub struct StreamPipe(Object<ffi::GMimeStreamPipe, ffi::GMimeStreamPipeClass>) @extends Stream;

    match fn {
        type_ => || ffi::g_mime_stream_pipe_get_type(),
    }
}

impl StreamPipe {
    #[doc(alias = "g_mime_stream_pipe_new")]
    pub fn new(fd: i32) -> StreamPipe {
        assert_initialized_main_thread!();
        unsafe { Stream::from_glib_full(ffi::g_mime_stream_pipe_new(fd)).unsafe_cast() }
    }
}

pub const NONE_STREAM_PIPE: Option<&StreamPipe> = None;

pub trait StreamPipeExt: 'static {
    #[doc(alias = "g_mime_stream_pipe_get_owner")]
    #[doc(alias = "get_owner")]
    fn is_owner(&self) -> bool;

    #[doc(alias = "g_mime_stream_pipe_set_owner")]
    fn set_owner(&self, owner: bool);
}

impl<O: IsA<StreamPipe>> StreamPipeExt for O {
    fn is_owner(&self) -> bool {
        unsafe {
            from_glib(ffi::g_mime_stream_pipe_get_owner(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_owner(&self, owner: bool) {
        unsafe {
            ffi::g_mime_stream_pipe_set_owner(self.as_ref().to_glib_none().0, owner.into_glib());
        }
    }
}

impl fmt::Display for StreamPipe {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("StreamPipe")
    }
}
