// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/vhdirk/gir-files.git)
// DO NOT EDIT

use crate::Stream;
use glib::object::Cast;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;

glib::wrapper! {
    #[doc(alias = "GMimeStreamMem")]
    pub struct StreamMem(Object<ffi::GMimeStreamMem, ffi::GMimeStreamMemClass>) @extends Stream;

    match fn {
        type_ => || ffi::g_mime_stream_mem_get_type(),
    }
}

impl StreamMem {
    #[doc(alias = "g_mime_stream_mem_new")]
    pub fn new() -> StreamMem {
        assert_initialized_main_thread!();
        unsafe { Stream::from_glib_full(ffi::g_mime_stream_mem_new()).unsafe_cast() }
    }

    #[doc(alias = "g_mime_stream_mem_new_with_buffer")]
    #[doc(alias = "new_with_buffer")]
    pub fn with_buffer(buffer: &[u8]) -> StreamMem {
        assert_initialized_main_thread!();
        let len = buffer.len() as usize;
        unsafe {
            Stream::from_glib_full(ffi::g_mime_stream_mem_new_with_buffer(
                buffer.to_glib_none().0,
                len,
            ))
            .unsafe_cast()
        }
    }

    #[doc(alias = "g_mime_stream_mem_new_with_byte_array")]
    #[doc(alias = "new_with_byte_array")]
    pub fn with_byte_array(array: &glib::ByteArray) -> StreamMem {
        assert_initialized_main_thread!();
        unsafe {
            Stream::from_glib_full(ffi::g_mime_stream_mem_new_with_byte_array(
                array.to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }
}

impl Default for StreamMem {
    fn default() -> Self {
        Self::new()
    }
}

pub const NONE_STREAM_MEM: Option<&StreamMem> = None;

pub trait StreamMemExt: 'static {
    #[doc(alias = "g_mime_stream_mem_get_byte_array")]
    #[doc(alias = "get_byte_array")]
    fn byte_array(&self) -> Option<glib::ByteArray>;

    #[doc(alias = "g_mime_stream_mem_get_owner")]
    #[doc(alias = "get_owner")]
    fn is_owner(&self) -> bool;

    #[doc(alias = "g_mime_stream_mem_set_byte_array")]
    fn set_byte_array(&self, array: &glib::ByteArray);

    #[doc(alias = "g_mime_stream_mem_set_owner")]
    fn set_owner(&self, owner: bool);
}

impl<O: IsA<StreamMem>> StreamMemExt for O {
    fn byte_array(&self) -> Option<glib::ByteArray> {
        unsafe {
            from_glib_none(ffi::g_mime_stream_mem_get_byte_array(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_owner(&self) -> bool {
        unsafe {
            from_glib(ffi::g_mime_stream_mem_get_owner(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_byte_array(&self, array: &glib::ByteArray) {
        unsafe {
            ffi::g_mime_stream_mem_set_byte_array(
                self.as_ref().to_glib_none().0,
                array.to_glib_none().0,
            );
        }
    }

    fn set_owner(&self, owner: bool) {
        unsafe {
            ffi::g_mime_stream_mem_set_owner(self.as_ref().to_glib_none().0, owner.into_glib());
        }
    }
}

impl fmt::Display for StreamMem {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("StreamMem")
    }
}
