// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/vhdirk/gir-files.git)
// DO NOT EDIT

use crate::Stream;
use glib::object::Cast;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "GMimeStreamFs")]
    pub struct StreamFs(Object<ffi::GMimeStreamFs, ffi::GMimeStreamFsClass>) @extends Stream;

    match fn {
        type_ => || ffi::g_mime_stream_fs_get_type(),
    }
}

impl StreamFs {
    #[doc(alias = "g_mime_stream_fs_new")]
    pub fn new(fd: i32) -> StreamFs {
        assert_initialized_main_thread!();
        unsafe { Stream::from_glib_full(ffi::g_mime_stream_fs_new(fd)).unsafe_cast() }
    }

    #[doc(alias = "g_mime_stream_fs_new_with_bounds")]
    #[doc(alias = "new_with_bounds")]
    pub fn with_bounds(fd: i32, start: i64, end: i64) -> StreamFs {
        assert_initialized_main_thread!();
        unsafe {
            Stream::from_glib_full(ffi::g_mime_stream_fs_new_with_bounds(fd, start, end))
                .unsafe_cast()
        }
    }

    #[doc(alias = "g_mime_stream_fs_open")]
    pub fn open(path: &str, flags: i32, mode: i32) -> Result<Stream, glib::Error> {
        assert_initialized_main_thread!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_mime_stream_fs_open(path.to_glib_none().0, flags, mode, &mut error);
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }
}

pub const NONE_STREAM_FS: Option<&StreamFs> = None;

pub trait StreamFsExt: 'static {
    #[doc(alias = "g_mime_stream_fs_get_owner")]
    #[doc(alias = "get_owner")]
    fn is_owner(&self) -> bool;

    #[doc(alias = "g_mime_stream_fs_set_owner")]
    fn set_owner(&self, owner: bool);
}

impl<O: IsA<StreamFs>> StreamFsExt for O {
    fn is_owner(&self) -> bool {
        unsafe {
            from_glib(ffi::g_mime_stream_fs_get_owner(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_owner(&self, owner: bool) {
        unsafe {
            ffi::g_mime_stream_fs_set_owner(self.as_ref().to_glib_none().0, owner.into_glib());
        }
    }
}

impl fmt::Display for StreamFs {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("StreamFs")
    }
}
