// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/vhdirk/gir-files.git)
// DO NOT EDIT

use crate::ContentEncoding;
use crate::DataWrapper;
use crate::DecryptFlags;
use crate::DecryptResult;
use crate::EncodingConstraint;
use crate::EncryptFlags;
use crate::Object;
use crate::OpenPGPData;
use crate::SignatureList;
use crate::VerifyFlags;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "GMimePart")]
    pub struct Part(Object<ffi::GMimePart, ffi::GMimePartClass>) @extends Object;

    match fn {
        type_ => || ffi::g_mime_part_get_type(),
    }
}

impl Part {
    #[doc(alias = "g_mime_part_new")]
    pub fn new() -> Part {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::g_mime_part_new()) }
    }

    #[doc(alias = "g_mime_part_new_with_type")]
    #[doc(alias = "new_with_type")]
    pub fn with_type(type_: &str, subtype: &str) -> Part {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::g_mime_part_new_with_type(
                type_.to_glib_none().0,
                subtype.to_glib_none().0,
            ))
        }
    }
}

impl Default for Part {
    fn default() -> Self {
        Self::new()
    }
}

pub const NONE_PART: Option<&Part> = None;

pub trait PartExt: 'static {
    #[doc(alias = "g_mime_part_get_best_content_encoding")]
    #[doc(alias = "get_best_content_encoding")]
    fn best_content_encoding(&self, constraint: EncodingConstraint) -> ContentEncoding;

    #[doc(alias = "g_mime_part_get_content")]
    #[doc(alias = "get_content")]
    fn content(&self) -> Option<DataWrapper>;

    #[doc(alias = "g_mime_part_get_content_description")]
    #[doc(alias = "get_content_description")]
    fn content_description(&self) -> Option<glib::GString>;

    #[doc(alias = "g_mime_part_get_content_encoding")]
    #[doc(alias = "get_content_encoding")]
    fn content_encoding(&self) -> ContentEncoding;

    #[doc(alias = "g_mime_part_get_content_location")]
    #[doc(alias = "get_content_location")]
    fn content_location(&self) -> Option<glib::GString>;

    #[doc(alias = "g_mime_part_get_content_md5")]
    #[doc(alias = "get_content_md5")]
    fn content_md5(&self) -> Option<glib::GString>;

    #[doc(alias = "g_mime_part_get_filename")]
    #[doc(alias = "get_filename")]
    fn filename(&self) -> Option<glib::GString>;

    #[doc(alias = "g_mime_part_get_openpgp_data")]
    #[doc(alias = "get_openpgp_data")]
    fn openpgp_data(&self) -> OpenPGPData;

    #[doc(alias = "g_mime_part_is_attachment")]
    fn is_attachment(&self) -> bool;

    #[doc(alias = "g_mime_part_openpgp_decrypt")]
    fn openpgp_decrypt(
        &self,
        flags: DecryptFlags,
        session_key: Option<&str>,
    ) -> Result<Option<DecryptResult>, glib::Error>;

    #[doc(alias = "g_mime_part_openpgp_encrypt")]
    fn openpgp_encrypt(
        &self,
        sign: bool,
        userid: Option<&str>,
        flags: EncryptFlags,
        recipients: &[&str],
    ) -> Result<(), glib::Error>;

    #[doc(alias = "g_mime_part_openpgp_sign")]
    fn openpgp_sign(&self, userid: &str) -> Result<(), glib::Error>;

    #[doc(alias = "g_mime_part_openpgp_verify")]
    fn openpgp_verify(&self, flags: VerifyFlags) -> Result<Option<SignatureList>, glib::Error>;

    #[doc(alias = "g_mime_part_set_content")]
    fn set_content(&self, content: &impl IsA<DataWrapper>);

    #[doc(alias = "g_mime_part_set_content_description")]
    fn set_content_description(&self, description: &str);

    #[doc(alias = "g_mime_part_set_content_encoding")]
    fn set_content_encoding(&self, encoding: ContentEncoding);

    #[doc(alias = "g_mime_part_set_content_location")]
    fn set_content_location(&self, content_location: &str);

    #[doc(alias = "g_mime_part_set_content_md5")]
    fn set_content_md5(&self, content_md5: &str);

    #[doc(alias = "g_mime_part_set_filename")]
    fn set_filename(&self, filename: &str);

    #[doc(alias = "g_mime_part_set_openpgp_data")]
    fn set_openpgp_data(&self, data: OpenPGPData);

    #[doc(alias = "g_mime_part_verify_content_md5")]
    fn verify_content_md5(&self) -> bool;
}

impl<O: IsA<Part>> PartExt for O {
    fn best_content_encoding(&self, constraint: EncodingConstraint) -> ContentEncoding {
        unsafe {
            from_glib(ffi::g_mime_part_get_best_content_encoding(
                self.as_ref().to_glib_none().0,
                constraint.into_glib(),
            ))
        }
    }

    fn content(&self) -> Option<DataWrapper> {
        unsafe { from_glib_none(ffi::g_mime_part_get_content(self.as_ref().to_glib_none().0)) }
    }

    fn content_description(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_mime_part_get_content_description(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn content_encoding(&self) -> ContentEncoding {
        unsafe {
            from_glib(ffi::g_mime_part_get_content_encoding(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn content_location(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_mime_part_get_content_location(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn content_md5(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_mime_part_get_content_md5(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn filename(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_mime_part_get_filename(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn openpgp_data(&self) -> OpenPGPData {
        unsafe {
            from_glib(ffi::g_mime_part_get_openpgp_data(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_attachment(&self) -> bool {
        unsafe {
            from_glib(ffi::g_mime_part_is_attachment(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn openpgp_decrypt(
        &self,
        flags: DecryptFlags,
        session_key: Option<&str>,
    ) -> Result<Option<DecryptResult>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_mime_part_openpgp_decrypt(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                session_key.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn openpgp_encrypt(
        &self,
        sign: bool,
        userid: Option<&str>,
        flags: EncryptFlags,
        recipients: &[&str],
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_mime_part_openpgp_encrypt(
                self.as_ref().to_glib_none().0,
                sign.into_glib(),
                userid.to_glib_none().0,
                flags.into_glib(),
                recipients.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn openpgp_sign(&self, userid: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_mime_part_openpgp_sign(
                self.as_ref().to_glib_none().0,
                userid.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn openpgp_verify(&self, flags: VerifyFlags) -> Result<Option<SignatureList>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_mime_part_openpgp_verify(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn set_content(&self, content: &impl IsA<DataWrapper>) {
        unsafe {
            ffi::g_mime_part_set_content(
                self.as_ref().to_glib_none().0,
                content.as_ref().to_glib_none().0,
            );
        }
    }

    fn set_content_description(&self, description: &str) {
        unsafe {
            ffi::g_mime_part_set_content_description(
                self.as_ref().to_glib_none().0,
                description.to_glib_none().0,
            );
        }
    }

    fn set_content_encoding(&self, encoding: ContentEncoding) {
        unsafe {
            ffi::g_mime_part_set_content_encoding(
                self.as_ref().to_glib_none().0,
                encoding.into_glib(),
            );
        }
    }

    fn set_content_location(&self, content_location: &str) {
        unsafe {
            ffi::g_mime_part_set_content_location(
                self.as_ref().to_glib_none().0,
                content_location.to_glib_none().0,
            );
        }
    }

    fn set_content_md5(&self, content_md5: &str) {
        unsafe {
            ffi::g_mime_part_set_content_md5(
                self.as_ref().to_glib_none().0,
                content_md5.to_glib_none().0,
            );
        }
    }

    fn set_filename(&self, filename: &str) {
        unsafe {
            ffi::g_mime_part_set_filename(
                self.as_ref().to_glib_none().0,
                filename.to_glib_none().0,
            );
        }
    }

    fn set_openpgp_data(&self, data: OpenPGPData) {
        unsafe {
            ffi::g_mime_part_set_openpgp_data(self.as_ref().to_glib_none().0, data.into_glib());
        }
    }

    fn verify_content_md5(&self) -> bool {
        unsafe {
            from_glib(ffi::g_mime_part_verify_content_md5(
                self.as_ref().to_glib_none().0,
            ))
        }
    }
}

impl fmt::Display for Part {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Part")
    }
}
