// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/vhdirk/gir-files.git)
// DO NOT EDIT

use crate::CryptoContext;
use crate::DecryptFlags;
use crate::DecryptResult;
use crate::EncryptFlags;
use crate::Multipart;
use crate::Object;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "GMimeMultipartEncrypted")]
    pub struct MultipartEncrypted(Object<ffi::GMimeMultipartEncrypted, ffi::GMimeMultipartEncryptedClass>) @extends Multipart, Object;

    match fn {
        type_ => || ffi::g_mime_multipart_encrypted_get_type(),
    }
}

impl MultipartEncrypted {
    #[doc(alias = "g_mime_multipart_encrypted_new")]
    pub fn new() -> MultipartEncrypted {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::g_mime_multipart_encrypted_new()) }
    }

    #[doc(alias = "g_mime_multipart_encrypted_encrypt")]
    pub fn encrypt(
        ctx: &impl IsA<CryptoContext>,
        entity: &impl IsA<Object>,
        sign: bool,
        userid: Option<&str>,
        flags: EncryptFlags,
        recipients: &[&str],
    ) -> Result<Option<MultipartEncrypted>, glib::Error> {
        skip_assert_initialized!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_mime_multipart_encrypted_encrypt(
                ctx.as_ref().to_glib_none().0,
                entity.as_ref().to_glib_none().0,
                sign.into_glib(),
                userid.to_glib_none().0,
                flags.into_glib(),
                recipients.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }
}

impl Default for MultipartEncrypted {
    fn default() -> Self {
        Self::new()
    }
}

pub const NONE_MULTIPART_ENCRYPTED: Option<&MultipartEncrypted> = None;

pub trait MultipartEncryptedExt: 'static {
    #[doc(alias = "g_mime_multipart_encrypted_decrypt")]
    fn decrypt(
        &self,
        flags: DecryptFlags,
        session_key: &str,
    ) -> Result<(Option<Object>, DecryptResult), glib::Error>;
}

impl<O: IsA<MultipartEncrypted>> MultipartEncryptedExt for O {
    fn decrypt(
        &self,
        flags: DecryptFlags,
        session_key: &str,
    ) -> Result<(Option<Object>, DecryptResult), glib::Error> {
        unsafe {
            let mut result = ptr::null_mut();
            let mut error = ptr::null_mut();
            let ret = ffi::g_mime_multipart_encrypted_decrypt(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                session_key.to_glib_none().0,
                &mut result,
                &mut error,
            );
            if error.is_null() {
                Ok((from_glib_full(ret), from_glib_full(result)))
            } else {
                Err(from_glib_full(error))
            }
        }
    }
}

impl fmt::Display for MultipartEncrypted {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("MultipartEncrypted")
    }
}
