// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/vhdirk/gir-files.git)
// DO NOT EDIT

use crate::Object;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;

glib::wrapper! {
    #[doc(alias = "GMimeMultipart")]
    pub struct Multipart(Object<ffi::GMimeMultipart, ffi::GMimeMultipartClass>) @extends Object;

    match fn {
        type_ => || ffi::g_mime_multipart_get_type(),
    }
}

impl Multipart {
    #[doc(alias = "g_mime_multipart_new")]
    pub fn new() -> Multipart {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::g_mime_multipart_new()) }
    }

    #[doc(alias = "g_mime_multipart_new_with_subtype")]
    #[doc(alias = "new_with_subtype")]
    pub fn with_subtype(subtype: &str) -> Multipart {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::g_mime_multipart_new_with_subtype(
                subtype.to_glib_none().0,
            ))
        }
    }
}

impl Default for Multipart {
    fn default() -> Self {
        Self::new()
    }
}

pub const NONE_MULTIPART: Option<&Multipart> = None;

pub trait MultipartExt: 'static {
    #[doc(alias = "g_mime_multipart_add")]
    fn add(&self, part: &impl IsA<Object>);

    #[doc(alias = "g_mime_multipart_clear")]
    fn clear(&self);

    #[doc(alias = "g_mime_multipart_contains")]
    fn contains(&self, part: &impl IsA<Object>) -> bool;

    #[doc(alias = "g_mime_multipart_foreach")]
    fn foreach<P: FnMut(&Object, &Object)>(&self, callback: P);

    #[doc(alias = "g_mime_multipart_get_boundary")]
    #[doc(alias = "get_boundary")]
    fn boundary(&self) -> Option<glib::GString>;

    #[doc(alias = "g_mime_multipart_get_count")]
    #[doc(alias = "get_count")]
    fn count(&self) -> i32;

    #[doc(alias = "g_mime_multipart_get_epilogue")]
    #[doc(alias = "get_epilogue")]
    fn epilogue(&self) -> Option<glib::GString>;

    #[doc(alias = "g_mime_multipart_get_part")]
    #[doc(alias = "get_part")]
    fn part(&self, index: i32) -> Option<Object>;

    #[doc(alias = "g_mime_multipart_get_prologue")]
    #[doc(alias = "get_prologue")]
    fn prologue(&self) -> Option<glib::GString>;

    #[doc(alias = "g_mime_multipart_get_subpart_from_content_id")]
    #[doc(alias = "get_subpart_from_content_id")]
    fn subpart_from_content_id(&self, content_id: &str) -> Option<Object>;

    #[doc(alias = "g_mime_multipart_index_of")]
    fn index_of(&self, part: &impl IsA<Object>) -> i32;

    #[doc(alias = "g_mime_multipart_insert")]
    fn insert(&self, index: i32, part: &impl IsA<Object>);

    #[doc(alias = "g_mime_multipart_remove")]
    fn remove(&self, part: &impl IsA<Object>) -> bool;

    #[doc(alias = "g_mime_multipart_remove_at")]
    fn remove_at(&self, index: i32) -> Option<Object>;

    #[doc(alias = "g_mime_multipart_replace")]
    fn replace(&self, index: i32, replacement: &impl IsA<Object>) -> Option<Object>;

    #[doc(alias = "g_mime_multipart_set_boundary")]
    fn set_boundary(&self, boundary: &str);

    #[doc(alias = "g_mime_multipart_set_epilogue")]
    fn set_epilogue(&self, epilogue: &str);

    #[doc(alias = "g_mime_multipart_set_prologue")]
    fn set_prologue(&self, prologue: &str);
}

impl<O: IsA<Multipart>> MultipartExt for O {
    fn add(&self, part: &impl IsA<Object>) {
        unsafe {
            ffi::g_mime_multipart_add(
                self.as_ref().to_glib_none().0,
                part.as_ref().to_glib_none().0,
            );
        }
    }

    fn clear(&self) {
        unsafe {
            ffi::g_mime_multipart_clear(self.as_ref().to_glib_none().0);
        }
    }

    fn contains(&self, part: &impl IsA<Object>) -> bool {
        unsafe {
            from_glib(ffi::g_mime_multipart_contains(
                self.as_ref().to_glib_none().0,
                part.as_ref().to_glib_none().0,
            ))
        }
    }

    fn foreach<P: FnMut(&Object, &Object)>(&self, callback: P) {
        let callback_data: P = callback;
        unsafe extern "C" fn callback_func<P: FnMut(&Object, &Object)>(
            parent: *mut ffi::GMimeObject,
            part: *mut ffi::GMimeObject,
            user_data: glib::ffi::gpointer,
        ) {
            let parent = from_glib_borrow(parent);
            let part = from_glib_borrow(part);
            let callback: *mut P = user_data as *const _ as usize as *mut P;
            (*callback)(&parent, &part);
        }
        let callback = Some(callback_func::<P> as _);
        let super_callback0: &P = &callback_data;
        unsafe {
            ffi::g_mime_multipart_foreach(
                self.as_ref().to_glib_none().0,
                callback,
                super_callback0 as *const _ as usize as *mut _,
            );
        }
    }

    fn boundary(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_mime_multipart_get_boundary(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn count(&self) -> i32 {
        unsafe { ffi::g_mime_multipart_get_count(self.as_ref().to_glib_none().0) }
    }

    fn epilogue(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_mime_multipart_get_epilogue(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn part(&self, index: i32) -> Option<Object> {
        unsafe {
            from_glib_none(ffi::g_mime_multipart_get_part(
                self.as_ref().to_glib_none().0,
                index,
            ))
        }
    }

    fn prologue(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_mime_multipart_get_prologue(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn subpart_from_content_id(&self, content_id: &str) -> Option<Object> {
        unsafe {
            from_glib_none(ffi::g_mime_multipart_get_subpart_from_content_id(
                self.as_ref().to_glib_none().0,
                content_id.to_glib_none().0,
            ))
        }
    }

    fn index_of(&self, part: &impl IsA<Object>) -> i32 {
        unsafe {
            ffi::g_mime_multipart_index_of(
                self.as_ref().to_glib_none().0,
                part.as_ref().to_glib_none().0,
            )
        }
    }

    fn insert(&self, index: i32, part: &impl IsA<Object>) {
        unsafe {
            ffi::g_mime_multipart_insert(
                self.as_ref().to_glib_none().0,
                index,
                part.as_ref().to_glib_none().0,
            );
        }
    }

    fn remove(&self, part: &impl IsA<Object>) -> bool {
        unsafe {
            from_glib(ffi::g_mime_multipart_remove(
                self.as_ref().to_glib_none().0,
                part.as_ref().to_glib_none().0,
            ))
        }
    }

    fn remove_at(&self, index: i32) -> Option<Object> {
        unsafe {
            from_glib_full(ffi::g_mime_multipart_remove_at(
                self.as_ref().to_glib_none().0,
                index,
            ))
        }
    }

    fn replace(&self, index: i32, replacement: &impl IsA<Object>) -> Option<Object> {
        unsafe {
            from_glib_full(ffi::g_mime_multipart_replace(
                self.as_ref().to_glib_none().0,
                index,
                replacement.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_boundary(&self, boundary: &str) {
        unsafe {
            ffi::g_mime_multipart_set_boundary(
                self.as_ref().to_glib_none().0,
                boundary.to_glib_none().0,
            );
        }
    }

    fn set_epilogue(&self, epilogue: &str) {
        unsafe {
            ffi::g_mime_multipart_set_epilogue(
                self.as_ref().to_glib_none().0,
                epilogue.to_glib_none().0,
            );
        }
    }

    fn set_prologue(&self, prologue: &str) {
        unsafe {
            ffi::g_mime_multipart_set_prologue(
                self.as_ref().to_glib_none().0,
                prologue.to_glib_none().0,
            );
        }
    }
}

impl fmt::Display for Multipart {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Multipart")
    }
}
