// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/vhdirk/gir-files.git)
// DO NOT EDIT

use crate::AddressType;
use crate::AutocryptHeader;
use crate::AutocryptHeaderList;
use crate::DecryptFlags;
use crate::InternetAddressList;
use crate::Object;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "GMimeMessage")]
    pub struct Message(Object<ffi::GMimeMessage, ffi::GMimeMessageClass>) @extends Object;

    match fn {
        type_ => || ffi::g_mime_message_get_type(),
    }
}

impl Message {
    #[doc(alias = "g_mime_message_new")]
    pub fn new(pretty_headers: bool) -> Message {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::g_mime_message_new(pretty_headers.into_glib())) }
    }
}

pub const NONE_MESSAGE: Option<&Message> = None;

pub trait MessageExt: 'static {
    #[doc(alias = "g_mime_message_add_mailbox")]
    fn add_mailbox(&self, type_: AddressType, name: &str, addr: &str);

    #[doc(alias = "g_mime_message_foreach")]
    fn foreach<P: FnMut(&Object, &Object)>(&self, callback: P);

    #[doc(alias = "g_mime_message_get_addresses")]
    #[doc(alias = "get_addresses")]
    fn addresses(&self, type_: AddressType) -> Option<InternetAddressList>;

    #[doc(alias = "g_mime_message_get_all_recipients")]
    #[doc(alias = "get_all_recipients")]
    fn all_recipients(&self) -> Option<InternetAddressList>;

    #[doc(alias = "g_mime_message_get_autocrypt_gossip_headers")]
    #[doc(alias = "get_autocrypt_gossip_headers")]
    fn autocrypt_gossip_headers(
        &self,
        now: &glib::DateTime,
        flags: DecryptFlags,
        session_key: &str,
    ) -> Result<AutocryptHeaderList, glib::Error>;

    #[doc(alias = "g_mime_message_get_autocrypt_gossip_headers_from_inner_part")]
    #[doc(alias = "get_autocrypt_gossip_headers_from_inner_part")]
    fn autocrypt_gossip_headers_from_inner_part(
        &self,
        now: &glib::DateTime,
        inner_part: &impl IsA<Object>,
    ) -> Option<AutocryptHeaderList>;

    #[doc(alias = "g_mime_message_get_autocrypt_header")]
    #[doc(alias = "get_autocrypt_header")]
    fn autocrypt_header(&self, now: &glib::DateTime) -> Option<AutocryptHeader>;

    #[doc(alias = "g_mime_message_get_bcc")]
    #[doc(alias = "get_bcc")]
    fn bcc(&self) -> Option<InternetAddressList>;

    #[doc(alias = "g_mime_message_get_body")]
    #[doc(alias = "get_body")]
    fn body(&self) -> Option<Object>;

    #[doc(alias = "g_mime_message_get_cc")]
    #[doc(alias = "get_cc")]
    fn cc(&self) -> Option<InternetAddressList>;

    #[doc(alias = "g_mime_message_get_date")]
    #[doc(alias = "get_date")]
    fn date(&self) -> Option<glib::DateTime>;

    #[doc(alias = "g_mime_message_get_from")]
    #[doc(alias = "get_from")]
    fn from(&self) -> Option<InternetAddressList>;

    #[doc(alias = "g_mime_message_get_message_id")]
    #[doc(alias = "get_message_id")]
    fn message_id(&self) -> Option<glib::GString>;

    #[doc(alias = "g_mime_message_get_mime_part")]
    #[doc(alias = "get_mime_part")]
    fn mime_part(&self) -> Option<Object>;

    #[doc(alias = "g_mime_message_get_reply_to")]
    #[doc(alias = "get_reply_to")]
    fn reply_to(&self) -> Option<InternetAddressList>;

    #[doc(alias = "g_mime_message_get_sender")]
    #[doc(alias = "get_sender")]
    fn sender(&self) -> Option<InternetAddressList>;

    #[doc(alias = "g_mime_message_get_subject")]
    #[doc(alias = "get_subject")]
    fn subject(&self) -> Option<glib::GString>;

    #[doc(alias = "g_mime_message_get_to")]
    #[doc(alias = "get_to")]
    fn to(&self) -> Option<InternetAddressList>;

    #[doc(alias = "g_mime_message_set_date")]
    fn set_date(&self, date: &glib::DateTime);

    #[doc(alias = "g_mime_message_set_message_id")]
    fn set_message_id(&self, message_id: &str);

    #[doc(alias = "g_mime_message_set_mime_part")]
    fn set_mime_part(&self, mime_part: &impl IsA<Object>);

    #[doc(alias = "g_mime_message_set_subject")]
    fn set_subject(&self, subject: &str, charset: &str);
}

impl<O: IsA<Message>> MessageExt for O {
    fn add_mailbox(&self, type_: AddressType, name: &str, addr: &str) {
        unsafe {
            ffi::g_mime_message_add_mailbox(
                self.as_ref().to_glib_none().0,
                type_.into_glib(),
                name.to_glib_none().0,
                addr.to_glib_none().0,
            );
        }
    }

    fn foreach<P: FnMut(&Object, &Object)>(&self, callback: P) {
        let callback_data: P = callback;
        unsafe extern "C" fn callback_func<P: FnMut(&Object, &Object)>(
            parent: *mut ffi::GMimeObject,
            part: *mut ffi::GMimeObject,
            user_data: glib::ffi::gpointer,
        ) {
            let parent = from_glib_borrow(parent);
            let part = from_glib_borrow(part);
            let callback: *mut P = user_data as *const _ as usize as *mut P;
            (*callback)(&parent, &part);
        }
        let callback = Some(callback_func::<P> as _);
        let super_callback0: &P = &callback_data;
        unsafe {
            ffi::g_mime_message_foreach(
                self.as_ref().to_glib_none().0,
                callback,
                super_callback0 as *const _ as usize as *mut _,
            );
        }
    }

    fn addresses(&self, type_: AddressType) -> Option<InternetAddressList> {
        unsafe {
            from_glib_none(ffi::g_mime_message_get_addresses(
                self.as_ref().to_glib_none().0,
                type_.into_glib(),
            ))
        }
    }

    fn all_recipients(&self) -> Option<InternetAddressList> {
        unsafe {
            from_glib_full(ffi::g_mime_message_get_all_recipients(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn autocrypt_gossip_headers(
        &self,
        now: &glib::DateTime,
        flags: DecryptFlags,
        session_key: &str,
    ) -> Result<AutocryptHeaderList, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_mime_message_get_autocrypt_gossip_headers(
                self.as_ref().to_glib_none().0,
                now.to_glib_none().0,
                flags.into_glib(),
                session_key.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn autocrypt_gossip_headers_from_inner_part(
        &self,
        now: &glib::DateTime,
        inner_part: &impl IsA<Object>,
    ) -> Option<AutocryptHeaderList> {
        unsafe {
            from_glib_full(
                ffi::g_mime_message_get_autocrypt_gossip_headers_from_inner_part(
                    self.as_ref().to_glib_none().0,
                    now.to_glib_none().0,
                    inner_part.as_ref().to_glib_none().0,
                ),
            )
        }
    }

    fn autocrypt_header(&self, now: &glib::DateTime) -> Option<AutocryptHeader> {
        unsafe {
            from_glib_full(ffi::g_mime_message_get_autocrypt_header(
                self.as_ref().to_glib_none().0,
                now.to_glib_none().0,
            ))
        }
    }

    fn bcc(&self) -> Option<InternetAddressList> {
        unsafe { from_glib_none(ffi::g_mime_message_get_bcc(self.as_ref().to_glib_none().0)) }
    }

    fn body(&self) -> Option<Object> {
        unsafe { from_glib_none(ffi::g_mime_message_get_body(self.as_ref().to_glib_none().0)) }
    }

    fn cc(&self) -> Option<InternetAddressList> {
        unsafe { from_glib_none(ffi::g_mime_message_get_cc(self.as_ref().to_glib_none().0)) }
    }

    fn date(&self) -> Option<glib::DateTime> {
        unsafe { from_glib_full(ffi::g_mime_message_get_date(self.as_ref().to_glib_none().0)) }
    }

    fn from(&self) -> Option<InternetAddressList> {
        unsafe { from_glib_none(ffi::g_mime_message_get_from(self.as_ref().to_glib_none().0)) }
    }

    fn message_id(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_mime_message_get_message_id(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn mime_part(&self) -> Option<Object> {
        unsafe {
            from_glib_none(ffi::g_mime_message_get_mime_part(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn reply_to(&self) -> Option<InternetAddressList> {
        unsafe {
            from_glib_none(ffi::g_mime_message_get_reply_to(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn sender(&self) -> Option<InternetAddressList> {
        unsafe {
            from_glib_none(ffi::g_mime_message_get_sender(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn subject(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_mime_message_get_subject(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn to(&self) -> Option<InternetAddressList> {
        unsafe { from_glib_none(ffi::g_mime_message_get_to(self.as_ref().to_glib_none().0)) }
    }

    fn set_date(&self, date: &glib::DateTime) {
        unsafe {
            ffi::g_mime_message_set_date(self.as_ref().to_glib_none().0, date.to_glib_none().0);
        }
    }

    fn set_message_id(&self, message_id: &str) {
        unsafe {
            ffi::g_mime_message_set_message_id(
                self.as_ref().to_glib_none().0,
                message_id.to_glib_none().0,
            );
        }
    }

    fn set_mime_part(&self, mime_part: &impl IsA<Object>) {
        unsafe {
            ffi::g_mime_message_set_mime_part(
                self.as_ref().to_glib_none().0,
                mime_part.as_ref().to_glib_none().0,
            );
        }
    }

    fn set_subject(&self, subject: &str, charset: &str) {
        unsafe {
            ffi::g_mime_message_set_subject(
                self.as_ref().to_glib_none().0,
                subject.to_glib_none().0,
                charset.to_glib_none().0,
            );
        }
    }
}

impl fmt::Display for Message {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Message")
    }
}
