// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/vhdirk/gir-files.git)
// DO NOT EDIT

use crate::ContentEncoding;
use crate::FormatOptions;
use crate::ParserOptions;
use glib::translate::*;

#[doc(alias = "g_mime_check_version")]
pub fn check_version(major: u32, minor: u32, micro: u32) -> bool {
    assert_initialized_main_thread!();
    unsafe { from_glib(ffi::g_mime_check_version(major, minor, micro)) }
}

#[doc(alias = "g_mime_content_encoding_from_string")]
pub fn content_encoding_from_string(str: &str) -> ContentEncoding {
    assert_initialized_main_thread!();
    unsafe {
        from_glib(ffi::g_mime_content_encoding_from_string(
            str.to_glib_none().0,
        ))
    }
}

#[doc(alias = "g_mime_content_encoding_to_string")]
pub fn content_encoding_to_string(encoding: ContentEncoding) -> Option<glib::GString> {
    assert_initialized_main_thread!();
    unsafe { from_glib_none(ffi::g_mime_content_encoding_to_string(encoding.into_glib())) }
}

//#[doc(alias = "g_mime_iconv_close")]
//pub fn iconv_close(cd: /*Unimplemented*/Fundamental: Pointer) -> i32 {
//    unsafe { TODO: call ffi:g_mime_iconv_close() }
//}

#[doc(alias = "g_mime_iconv_locale_to_utf8")]
pub fn iconv_locale_to_utf8(str: &str) -> Option<glib::GString> {
    assert_initialized_main_thread!();
    unsafe { from_glib_full(ffi::g_mime_iconv_locale_to_utf8(str.to_glib_none().0)) }
}

#[doc(alias = "g_mime_iconv_locale_to_utf8_length")]
pub fn iconv_locale_to_utf8_length(str: &str, n: usize) -> Option<glib::GString> {
    assert_initialized_main_thread!();
    unsafe {
        from_glib_full(ffi::g_mime_iconv_locale_to_utf8_length(
            str.to_glib_none().0,
            n,
        ))
    }
}

//#[doc(alias = "g_mime_iconv_open")]
//pub fn iconv_open(to: &str, from: &str) -> /*Unimplemented*/Option<Fundamental: Pointer> {
//    unsafe { TODO: call ffi:g_mime_iconv_open() }
//}

//#[doc(alias = "g_mime_iconv_strdup")]
//pub fn iconv_strdup(cd: /*Unimplemented*/Fundamental: Pointer, str: &str) -> Option<glib::GString> {
//    unsafe { TODO: call ffi:g_mime_iconv_strdup() }
//}

//#[doc(alias = "g_mime_iconv_strndup")]
//pub fn iconv_strndup(cd: /*Unimplemented*/Fundamental: Pointer, str: &str, n: usize) -> Option<glib::GString> {
//    unsafe { TODO: call ffi:g_mime_iconv_strndup() }
//}

#[doc(alias = "g_mime_iconv_utf8_to_locale")]
pub fn iconv_utf8_to_locale(str: &str) -> Option<glib::GString> {
    assert_initialized_main_thread!();
    unsafe { from_glib_full(ffi::g_mime_iconv_utf8_to_locale(str.to_glib_none().0)) }
}

#[doc(alias = "g_mime_iconv_utf8_to_locale_length")]
pub fn iconv_utf8_to_locale_length(str: &str, n: usize) -> Option<glib::GString> {
    assert_initialized_main_thread!();
    unsafe {
        from_glib_full(ffi::g_mime_iconv_utf8_to_locale_length(
            str.to_glib_none().0,
            n,
        ))
    }
}

#[doc(alias = "g_mime_init")]
pub fn init() {
    assert_initialized_main_thread!();
    unsafe {
        ffi::g_mime_init();
    }
}

#[doc(alias = "g_mime_locale_charset")]
pub fn locale_charset() -> Option<glib::GString> {
    assert_initialized_main_thread!();
    unsafe { from_glib_none(ffi::g_mime_locale_charset()) }
}

#[doc(alias = "g_mime_locale_language")]
pub fn locale_language() -> Option<glib::GString> {
    assert_initialized_main_thread!();
    unsafe { from_glib_none(ffi::g_mime_locale_language()) }
}

#[doc(alias = "g_mime_shutdown")]
pub fn shutdown() {
    assert_initialized_main_thread!();
    unsafe {
        ffi::g_mime_shutdown();
    }
}

#[doc(alias = "g_mime_utils_best_encoding")]
pub fn utils_best_encoding(text: &[u8]) -> ContentEncoding {
    assert_initialized_main_thread!();
    let len = text.len() as usize;
    unsafe { from_glib(ffi::g_mime_utils_best_encoding(text.to_glib_none().0, len)) }
}

#[doc(alias = "g_mime_utils_decode_8bit")]
pub fn utils_decode_8bit(options: Option<&ParserOptions>, text: &[u8]) -> Option<glib::GString> {
    assert_initialized_main_thread!();
    let len = text.len() as usize;
    unsafe {
        from_glib_full(ffi::g_mime_utils_decode_8bit(
            mut_override(options.to_glib_none().0),
            text.to_glib_none().0,
            len,
        ))
    }
}

#[doc(alias = "g_mime_utils_decode_message_id")]
pub fn utils_decode_message_id(message_id: &str) -> Option<glib::GString> {
    assert_initialized_main_thread!();
    unsafe {
        from_glib_full(ffi::g_mime_utils_decode_message_id(
            message_id.to_glib_none().0,
        ))
    }
}

#[doc(alias = "g_mime_utils_generate_message_id")]
pub fn utils_generate_message_id(fqdn: &str) -> Option<glib::GString> {
    assert_initialized_main_thread!();
    unsafe { from_glib_full(ffi::g_mime_utils_generate_message_id(fqdn.to_glib_none().0)) }
}

#[doc(alias = "g_mime_utils_header_decode_date")]
pub fn utils_header_decode_date(str: &str) -> Option<glib::DateTime> {
    assert_initialized_main_thread!();
    unsafe { from_glib_full(ffi::g_mime_utils_header_decode_date(str.to_glib_none().0)) }
}

#[doc(alias = "g_mime_utils_header_decode_phrase")]
pub fn utils_header_decode_phrase(
    options: Option<&ParserOptions>,
    phrase: &str,
) -> Option<glib::GString> {
    assert_initialized_main_thread!();
    unsafe {
        from_glib_full(ffi::g_mime_utils_header_decode_phrase(
            mut_override(options.to_glib_none().0),
            phrase.to_glib_none().0,
        ))
    }
}

#[doc(alias = "g_mime_utils_header_decode_text")]
pub fn utils_header_decode_text(
    options: Option<&ParserOptions>,
    text: &str,
) -> Option<glib::GString> {
    assert_initialized_main_thread!();
    unsafe {
        from_glib_full(ffi::g_mime_utils_header_decode_text(
            mut_override(options.to_glib_none().0),
            text.to_glib_none().0,
        ))
    }
}

#[doc(alias = "g_mime_utils_header_encode_phrase")]
pub fn utils_header_encode_phrase(
    options: Option<&FormatOptions>,
    phrase: &str,
    charset: Option<&str>,
) -> Option<glib::GString> {
    assert_initialized_main_thread!();
    unsafe {
        from_glib_full(ffi::g_mime_utils_header_encode_phrase(
            mut_override(options.to_glib_none().0),
            phrase.to_glib_none().0,
            charset.to_glib_none().0,
        ))
    }
}

#[doc(alias = "g_mime_utils_header_encode_text")]
pub fn utils_header_encode_text(
    options: Option<&FormatOptions>,
    text: &str,
    charset: Option<&str>,
) -> Option<glib::GString> {
    assert_initialized_main_thread!();
    unsafe {
        from_glib_full(ffi::g_mime_utils_header_encode_text(
            mut_override(options.to_glib_none().0),
            text.to_glib_none().0,
            charset.to_glib_none().0,
        ))
    }
}

#[doc(alias = "g_mime_utils_header_format_date")]
pub fn utils_header_format_date(date: &glib::DateTime) -> Option<glib::GString> {
    assert_initialized_main_thread!();
    unsafe { from_glib_full(ffi::g_mime_utils_header_format_date(date.to_glib_none().0)) }
}

//#[doc(alias = "g_mime_utils_header_printf")]
//pub fn utils_header_printf(options: Option<&mut ParserOptions>, format: Option<&mut FormatOptions>, text: &str, : /*Unknown conversion*//*Unimplemented*/Fundamental: VarArgs) -> Option<glib::GString> {
//    unsafe { TODO: call ffi:g_mime_utils_header_printf() }
//}

#[doc(alias = "g_mime_utils_header_unfold")]
pub fn utils_header_unfold(value: &str) -> Option<glib::GString> {
    assert_initialized_main_thread!();
    unsafe { from_glib_full(ffi::g_mime_utils_header_unfold(value.to_glib_none().0)) }
}

#[doc(alias = "g_mime_utils_quote_string")]
pub fn utils_quote_string(str: &str) -> Option<glib::GString> {
    assert_initialized_main_thread!();
    unsafe { from_glib_full(ffi::g_mime_utils_quote_string(str.to_glib_none().0)) }
}

#[doc(alias = "g_mime_utils_structured_header_fold")]
pub fn utils_structured_header_fold(
    options: Option<&ParserOptions>,
    format: Option<&FormatOptions>,
    header: &str,
) -> Option<glib::GString> {
    assert_initialized_main_thread!();
    unsafe {
        from_glib_full(ffi::g_mime_utils_structured_header_fold(
            mut_override(options.to_glib_none().0),
            mut_override(format.to_glib_none().0),
            header.to_glib_none().0,
        ))
    }
}

#[doc(alias = "g_mime_utils_text_is_8bit")]
pub fn utils_text_is_8bit(text: &[u8]) -> bool {
    assert_initialized_main_thread!();
    let len = text.len() as usize;
    unsafe { from_glib(ffi::g_mime_utils_text_is_8bit(text.to_glib_none().0, len)) }
}

#[doc(alias = "g_mime_utils_unquote_string")]
pub fn utils_unquote_string(str: &str) {
    assert_initialized_main_thread!();
    unsafe {
        ffi::g_mime_utils_unquote_string(str.to_glib_none().0);
    }
}

#[doc(alias = "g_mime_utils_unstructured_header_fold")]
pub fn utils_unstructured_header_fold(
    options: Option<&ParserOptions>,
    format: Option<&FormatOptions>,
    header: &str,
) -> Option<glib::GString> {
    assert_initialized_main_thread!();
    unsafe {
        from_glib_full(ffi::g_mime_utils_unstructured_header_fold(
            mut_override(options.to_glib_none().0),
            mut_override(format.to_glib_none().0),
            header.to_glib_none().0,
        ))
    }
}
