// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/vhdirk/gir-files.git)
// DO NOT EDIT

use glib::object::IsA;
use glib::translate::*;
use std::fmt;
use std::mem;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "GMimeFilter")]
    pub struct Filter(Object<ffi::GMimeFilter, ffi::GMimeFilterClass>);

    match fn {
        type_ => || ffi::g_mime_filter_get_type(),
    }
}

pub const NONE_FILTER: Option<&Filter> = None;

pub trait FilterExt: 'static {
    #[doc(alias = "g_mime_filter_backup")]
    fn backup(&self, data: &[u8]);

    #[doc(alias = "g_mime_filter_complete")]
    fn complete(&self, inbuf: &[u8], prespace: usize) -> (Vec<u8>, usize);

    #[doc(alias = "g_mime_filter_copy")]
    fn copy(&self) -> Option<Filter>;

    #[doc(alias = "g_mime_filter_filter")]
    fn filter(&self, inbuf: &[u8], prespace: usize) -> (Vec<u8>, usize);

    #[doc(alias = "g_mime_filter_reset")]
    fn reset(&self);

    #[doc(alias = "g_mime_filter_set_size")]
    fn set_size(&self, size: usize, keep: bool);
}

impl<O: IsA<Filter>> FilterExt for O {
    fn backup(&self, data: &[u8]) {
        let length = data.len() as usize;
        unsafe {
            ffi::g_mime_filter_backup(
                self.as_ref().to_glib_none().0,
                data.to_glib_none().0,
                length,
            );
        }
    }

    fn complete(&self, inbuf: &[u8], prespace: usize) -> (Vec<u8>, usize) {
        let inlen = inbuf.len() as usize;
        unsafe {
            let mut outbuf = ptr::null_mut();
            let mut outlen = mem::MaybeUninit::uninit();
            let mut outprespace = mem::MaybeUninit::uninit();
            ffi::g_mime_filter_complete(
                self.as_ref().to_glib_none().0,
                inbuf.to_glib_none().0,
                inlen,
                prespace,
                &mut outbuf,
                outlen.as_mut_ptr(),
                outprespace.as_mut_ptr(),
            );
            let outprespace = outprespace.assume_init();
            (
                FromGlibContainer::from_glib_none_num(outbuf, outlen.assume_init() as usize),
                outprespace,
            )
        }
    }

    fn copy(&self) -> Option<Filter> {
        unsafe { from_glib_full(ffi::g_mime_filter_copy(self.as_ref().to_glib_none().0)) }
    }

    fn filter(&self, inbuf: &[u8], prespace: usize) -> (Vec<u8>, usize) {
        let inlen = inbuf.len() as usize;
        unsafe {
            let mut outbuf = ptr::null_mut();
            let mut outlen = mem::MaybeUninit::uninit();
            let mut outprespace = mem::MaybeUninit::uninit();
            ffi::g_mime_filter_filter(
                self.as_ref().to_glib_none().0,
                inbuf.to_glib_none().0,
                inlen,
                prespace,
                &mut outbuf,
                outlen.as_mut_ptr(),
                outprespace.as_mut_ptr(),
            );
            let outprespace = outprespace.assume_init();
            (
                FromGlibContainer::from_glib_none_num(outbuf, outlen.assume_init() as usize),
                outprespace,
            )
        }
    }

    fn reset(&self) {
        unsafe {
            ffi::g_mime_filter_reset(self.as_ref().to_glib_none().0);
        }
    }

    fn set_size(&self, size: usize, keep: bool) {
        unsafe {
            ffi::g_mime_filter_set_size(self.as_ref().to_glib_none().0, size, keep.into_glib());
        }
    }
}

impl fmt::Display for Filter {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Filter")
    }
}
