// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/vhdirk/gir-files.git)
// DO NOT EDIT

use glib::translate::*;
use std::fmt;

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimeAddressType")]
pub enum AddressType {
    #[doc(alias = "GMIME_ADDRESS_TYPE_SENDER")]
    Sender,
    #[doc(alias = "GMIME_ADDRESS_TYPE_FROM")]
    From,
    #[doc(alias = "GMIME_ADDRESS_TYPE_REPLY_TO")]
    ReplyTo,
    #[doc(alias = "GMIME_ADDRESS_TYPE_TO")]
    To,
    #[doc(alias = "GMIME_ADDRESS_TYPE_CC")]
    Cc,
    #[doc(alias = "GMIME_ADDRESS_TYPE_BCC")]
    Bcc,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for AddressType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "AddressType::{}",
            match *self {
                Self::Sender => "Sender",
                Self::From => "From",
                Self::ReplyTo => "ReplyTo",
                Self::To => "To",
                Self::Cc => "Cc",
                Self::Bcc => "Bcc",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for AddressType {
    type GlibType = ffi::GMimeAddressType;

    fn into_glib(self) -> ffi::GMimeAddressType {
        match self {
            Self::Sender => ffi::GMIME_ADDRESS_TYPE_SENDER,
            Self::From => ffi::GMIME_ADDRESS_TYPE_FROM,
            Self::ReplyTo => ffi::GMIME_ADDRESS_TYPE_REPLY_TO,
            Self::To => ffi::GMIME_ADDRESS_TYPE_TO,
            Self::Cc => ffi::GMIME_ADDRESS_TYPE_CC,
            Self::Bcc => ffi::GMIME_ADDRESS_TYPE_BCC,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimeAddressType> for AddressType {
    unsafe fn from_glib(value: ffi::GMimeAddressType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_ADDRESS_TYPE_SENDER => Self::Sender,
            ffi::GMIME_ADDRESS_TYPE_FROM => Self::From,
            ffi::GMIME_ADDRESS_TYPE_REPLY_TO => Self::ReplyTo,
            ffi::GMIME_ADDRESS_TYPE_TO => Self::To,
            ffi::GMIME_ADDRESS_TYPE_CC => Self::Cc,
            ffi::GMIME_ADDRESS_TYPE_BCC => Self::Bcc,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimeAutocryptPreferEncrypt")]
pub enum AutocryptPreferEncrypt {
    #[doc(alias = "GMIME_AUTOCRYPT_PREFER_ENCRYPT_NONE")]
    None,
    #[doc(alias = "GMIME_AUTOCRYPT_PREFER_ENCRYPT_MUTUAL")]
    Mutual,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for AutocryptPreferEncrypt {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "AutocryptPreferEncrypt::{}",
            match *self {
                Self::None => "None",
                Self::Mutual => "Mutual",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for AutocryptPreferEncrypt {
    type GlibType = ffi::GMimeAutocryptPreferEncrypt;

    fn into_glib(self) -> ffi::GMimeAutocryptPreferEncrypt {
        match self {
            Self::None => ffi::GMIME_AUTOCRYPT_PREFER_ENCRYPT_NONE,
            Self::Mutual => ffi::GMIME_AUTOCRYPT_PREFER_ENCRYPT_MUTUAL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimeAutocryptPreferEncrypt> for AutocryptPreferEncrypt {
    unsafe fn from_glib(value: ffi::GMimeAutocryptPreferEncrypt) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_AUTOCRYPT_PREFER_ENCRYPT_NONE => Self::None,
            ffi::GMIME_AUTOCRYPT_PREFER_ENCRYPT_MUTUAL => Self::Mutual,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimeCipherAlgo")]
pub enum CipherAlgo {
    #[doc(alias = "GMIME_CIPHER_ALGO_DEFAULT")]
    Default,
    #[doc(alias = "GMIME_CIPHER_ALGO_IDEA")]
    Idea,
    #[doc(alias = "GMIME_CIPHER_ALGO_3DES")]
    _3des,
    #[doc(alias = "GMIME_CIPHER_ALGO_CAST5")]
    Cast5,
    #[doc(alias = "GMIME_CIPHER_ALGO_BLOWFISH")]
    Blowfish,
    #[doc(alias = "GMIME_CIPHER_ALGO_AES")]
    Aes,
    #[doc(alias = "GMIME_CIPHER_ALGO_AES192")]
    Aes192,
    #[doc(alias = "GMIME_CIPHER_ALGO_AES256")]
    Aes256,
    #[doc(alias = "GMIME_CIPHER_ALGO_TWOFISH")]
    Twofish,
    #[doc(alias = "GMIME_CIPHER_ALGO_CAMELLIA128")]
    Camellia128,
    #[doc(alias = "GMIME_CIPHER_ALGO_CAMELLIA192")]
    Camellia192,
    #[doc(alias = "GMIME_CIPHER_ALGO_CAMELLIA256")]
    Camellia256,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for CipherAlgo {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "CipherAlgo::{}",
            match *self {
                Self::Default => "Default",
                Self::Idea => "Idea",
                Self::_3des => "_3des",
                Self::Cast5 => "Cast5",
                Self::Blowfish => "Blowfish",
                Self::Aes => "Aes",
                Self::Aes192 => "Aes192",
                Self::Aes256 => "Aes256",
                Self::Twofish => "Twofish",
                Self::Camellia128 => "Camellia128",
                Self::Camellia192 => "Camellia192",
                Self::Camellia256 => "Camellia256",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for CipherAlgo {
    type GlibType = ffi::GMimeCipherAlgo;

    fn into_glib(self) -> ffi::GMimeCipherAlgo {
        match self {
            Self::Default => ffi::GMIME_CIPHER_ALGO_DEFAULT,
            Self::Idea => ffi::GMIME_CIPHER_ALGO_IDEA,
            Self::_3des => ffi::GMIME_CIPHER_ALGO_3DES,
            Self::Cast5 => ffi::GMIME_CIPHER_ALGO_CAST5,
            Self::Blowfish => ffi::GMIME_CIPHER_ALGO_BLOWFISH,
            Self::Aes => ffi::GMIME_CIPHER_ALGO_AES,
            Self::Aes192 => ffi::GMIME_CIPHER_ALGO_AES192,
            Self::Aes256 => ffi::GMIME_CIPHER_ALGO_AES256,
            Self::Twofish => ffi::GMIME_CIPHER_ALGO_TWOFISH,
            Self::Camellia128 => ffi::GMIME_CIPHER_ALGO_CAMELLIA128,
            Self::Camellia192 => ffi::GMIME_CIPHER_ALGO_CAMELLIA192,
            Self::Camellia256 => ffi::GMIME_CIPHER_ALGO_CAMELLIA256,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimeCipherAlgo> for CipherAlgo {
    unsafe fn from_glib(value: ffi::GMimeCipherAlgo) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_CIPHER_ALGO_DEFAULT => Self::Default,
            ffi::GMIME_CIPHER_ALGO_IDEA => Self::Idea,
            ffi::GMIME_CIPHER_ALGO_3DES => Self::_3des,
            ffi::GMIME_CIPHER_ALGO_CAST5 => Self::Cast5,
            ffi::GMIME_CIPHER_ALGO_BLOWFISH => Self::Blowfish,
            ffi::GMIME_CIPHER_ALGO_AES => Self::Aes,
            ffi::GMIME_CIPHER_ALGO_AES192 => Self::Aes192,
            ffi::GMIME_CIPHER_ALGO_AES256 => Self::Aes256,
            ffi::GMIME_CIPHER_ALGO_TWOFISH => Self::Twofish,
            ffi::GMIME_CIPHER_ALGO_CAMELLIA128 => Self::Camellia128,
            ffi::GMIME_CIPHER_ALGO_CAMELLIA192 => Self::Camellia192,
            ffi::GMIME_CIPHER_ALGO_CAMELLIA256 => Self::Camellia256,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimeContentEncoding")]
pub enum ContentEncoding {
    #[doc(alias = "GMIME_CONTENT_ENCODING_DEFAULT")]
    Default,
    #[doc(alias = "GMIME_CONTENT_ENCODING_7BIT")]
    _7bit,
    #[doc(alias = "GMIME_CONTENT_ENCODING_8BIT")]
    _8bit,
    #[doc(alias = "GMIME_CONTENT_ENCODING_BINARY")]
    Binary,
    #[doc(alias = "GMIME_CONTENT_ENCODING_BASE64")]
    Base64,
    #[doc(alias = "GMIME_CONTENT_ENCODING_QUOTEDPRINTABLE")]
    Quotedprintable,
    #[doc(alias = "GMIME_CONTENT_ENCODING_UUENCODE")]
    Uuencode,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ContentEncoding {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ContentEncoding::{}",
            match *self {
                Self::Default => "Default",
                Self::_7bit => "_7bit",
                Self::_8bit => "_8bit",
                Self::Binary => "Binary",
                Self::Base64 => "Base64",
                Self::Quotedprintable => "Quotedprintable",
                Self::Uuencode => "Uuencode",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ContentEncoding {
    type GlibType = ffi::GMimeContentEncoding;

    fn into_glib(self) -> ffi::GMimeContentEncoding {
        match self {
            Self::Default => ffi::GMIME_CONTENT_ENCODING_DEFAULT,
            Self::_7bit => ffi::GMIME_CONTENT_ENCODING_7BIT,
            Self::_8bit => ffi::GMIME_CONTENT_ENCODING_8BIT,
            Self::Binary => ffi::GMIME_CONTENT_ENCODING_BINARY,
            Self::Base64 => ffi::GMIME_CONTENT_ENCODING_BASE64,
            Self::Quotedprintable => ffi::GMIME_CONTENT_ENCODING_QUOTEDPRINTABLE,
            Self::Uuencode => ffi::GMIME_CONTENT_ENCODING_UUENCODE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimeContentEncoding> for ContentEncoding {
    unsafe fn from_glib(value: ffi::GMimeContentEncoding) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_CONTENT_ENCODING_DEFAULT => Self::Default,
            ffi::GMIME_CONTENT_ENCODING_7BIT => Self::_7bit,
            ffi::GMIME_CONTENT_ENCODING_8BIT => Self::_8bit,
            ffi::GMIME_CONTENT_ENCODING_BINARY => Self::Binary,
            ffi::GMIME_CONTENT_ENCODING_BASE64 => Self::Base64,
            ffi::GMIME_CONTENT_ENCODING_QUOTEDPRINTABLE => Self::Quotedprintable,
            ffi::GMIME_CONTENT_ENCODING_UUENCODE => Self::Uuencode,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimeDigestAlgo")]
pub enum DigestAlgo {
    #[doc(alias = "GMIME_DIGEST_ALGO_DEFAULT")]
    Default,
    #[doc(alias = "GMIME_DIGEST_ALGO_MD5")]
    Md5,
    #[doc(alias = "GMIME_DIGEST_ALGO_SHA1")]
    Sha1,
    #[doc(alias = "GMIME_DIGEST_ALGO_RIPEMD160")]
    Ripemd160,
    #[doc(alias = "GMIME_DIGEST_ALGO_MD2")]
    Md2,
    #[doc(alias = "GMIME_DIGEST_ALGO_TIGER192")]
    Tiger192,
    #[doc(alias = "GMIME_DIGEST_ALGO_HAVAL5160")]
    Haval5160,
    #[doc(alias = "GMIME_DIGEST_ALGO_SHA256")]
    Sha256,
    #[doc(alias = "GMIME_DIGEST_ALGO_SHA384")]
    Sha384,
    #[doc(alias = "GMIME_DIGEST_ALGO_SHA512")]
    Sha512,
    #[doc(alias = "GMIME_DIGEST_ALGO_SHA224")]
    Sha224,
    #[doc(alias = "GMIME_DIGEST_ALGO_MD4")]
    Md4,
    #[doc(alias = "GMIME_DIGEST_ALGO_CRC32")]
    Crc32,
    #[doc(alias = "GMIME_DIGEST_ALGO_CRC32_RFC1510")]
    Crc32Rfc1510,
    #[doc(alias = "GMIME_DIGEST_ALGO_CRC32_RFC2440")]
    Crc32Rfc2440,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for DigestAlgo {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "DigestAlgo::{}",
            match *self {
                Self::Default => "Default",
                Self::Md5 => "Md5",
                Self::Sha1 => "Sha1",
                Self::Ripemd160 => "Ripemd160",
                Self::Md2 => "Md2",
                Self::Tiger192 => "Tiger192",
                Self::Haval5160 => "Haval5160",
                Self::Sha256 => "Sha256",
                Self::Sha384 => "Sha384",
                Self::Sha512 => "Sha512",
                Self::Sha224 => "Sha224",
                Self::Md4 => "Md4",
                Self::Crc32 => "Crc32",
                Self::Crc32Rfc1510 => "Crc32Rfc1510",
                Self::Crc32Rfc2440 => "Crc32Rfc2440",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for DigestAlgo {
    type GlibType = ffi::GMimeDigestAlgo;

    fn into_glib(self) -> ffi::GMimeDigestAlgo {
        match self {
            Self::Default => ffi::GMIME_DIGEST_ALGO_DEFAULT,
            Self::Md5 => ffi::GMIME_DIGEST_ALGO_MD5,
            Self::Sha1 => ffi::GMIME_DIGEST_ALGO_SHA1,
            Self::Ripemd160 => ffi::GMIME_DIGEST_ALGO_RIPEMD160,
            Self::Md2 => ffi::GMIME_DIGEST_ALGO_MD2,
            Self::Tiger192 => ffi::GMIME_DIGEST_ALGO_TIGER192,
            Self::Haval5160 => ffi::GMIME_DIGEST_ALGO_HAVAL5160,
            Self::Sha256 => ffi::GMIME_DIGEST_ALGO_SHA256,
            Self::Sha384 => ffi::GMIME_DIGEST_ALGO_SHA384,
            Self::Sha512 => ffi::GMIME_DIGEST_ALGO_SHA512,
            Self::Sha224 => ffi::GMIME_DIGEST_ALGO_SHA224,
            Self::Md4 => ffi::GMIME_DIGEST_ALGO_MD4,
            Self::Crc32 => ffi::GMIME_DIGEST_ALGO_CRC32,
            Self::Crc32Rfc1510 => ffi::GMIME_DIGEST_ALGO_CRC32_RFC1510,
            Self::Crc32Rfc2440 => ffi::GMIME_DIGEST_ALGO_CRC32_RFC2440,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimeDigestAlgo> for DigestAlgo {
    unsafe fn from_glib(value: ffi::GMimeDigestAlgo) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_DIGEST_ALGO_DEFAULT => Self::Default,
            ffi::GMIME_DIGEST_ALGO_MD5 => Self::Md5,
            ffi::GMIME_DIGEST_ALGO_SHA1 => Self::Sha1,
            ffi::GMIME_DIGEST_ALGO_RIPEMD160 => Self::Ripemd160,
            ffi::GMIME_DIGEST_ALGO_MD2 => Self::Md2,
            ffi::GMIME_DIGEST_ALGO_TIGER192 => Self::Tiger192,
            ffi::GMIME_DIGEST_ALGO_HAVAL5160 => Self::Haval5160,
            ffi::GMIME_DIGEST_ALGO_SHA256 => Self::Sha256,
            ffi::GMIME_DIGEST_ALGO_SHA384 => Self::Sha384,
            ffi::GMIME_DIGEST_ALGO_SHA512 => Self::Sha512,
            ffi::GMIME_DIGEST_ALGO_SHA224 => Self::Sha224,
            ffi::GMIME_DIGEST_ALGO_MD4 => Self::Md4,
            ffi::GMIME_DIGEST_ALGO_CRC32 => Self::Crc32,
            ffi::GMIME_DIGEST_ALGO_CRC32_RFC1510 => Self::Crc32Rfc1510,
            ffi::GMIME_DIGEST_ALGO_CRC32_RFC2440 => Self::Crc32Rfc2440,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimeEncodingConstraint")]
pub enum EncodingConstraint {
    #[doc(alias = "GMIME_ENCODING_CONSTRAINT_7BIT")]
    _7bit,
    #[doc(alias = "GMIME_ENCODING_CONSTRAINT_8BIT")]
    _8bit,
    #[doc(alias = "GMIME_ENCODING_CONSTRAINT_BINARY")]
    Binary,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for EncodingConstraint {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "EncodingConstraint::{}",
            match *self {
                Self::_7bit => "_7bit",
                Self::_8bit => "_8bit",
                Self::Binary => "Binary",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for EncodingConstraint {
    type GlibType = ffi::GMimeEncodingConstraint;

    fn into_glib(self) -> ffi::GMimeEncodingConstraint {
        match self {
            Self::_7bit => ffi::GMIME_ENCODING_CONSTRAINT_7BIT,
            Self::_8bit => ffi::GMIME_ENCODING_CONSTRAINT_8BIT,
            Self::Binary => ffi::GMIME_ENCODING_CONSTRAINT_BINARY,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimeEncodingConstraint> for EncodingConstraint {
    unsafe fn from_glib(value: ffi::GMimeEncodingConstraint) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_ENCODING_CONSTRAINT_7BIT => Self::_7bit,
            ffi::GMIME_ENCODING_CONSTRAINT_8BIT => Self::_8bit,
            ffi::GMIME_ENCODING_CONSTRAINT_BINARY => Self::Binary,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimeEncryptFlags")]
pub enum EncryptFlags {
    #[doc(alias = "GMIME_ENCRYPT_NONE")]
    None,
    #[doc(alias = "GMIME_ENCRYPT_ALWAYS_TRUST")]
    AlwaysTrust,
    #[doc(alias = "GMIME_ENCRYPT_NO_COMPRESS")]
    NoCompress,
    #[doc(alias = "GMIME_ENCRYPT_SYMMETRIC")]
    Symmetric,
    #[doc(alias = "GMIME_ENCRYPT_THROW_KEYIDS")]
    ThrowKeyids,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for EncryptFlags {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "EncryptFlags::{}",
            match *self {
                Self::None => "None",
                Self::AlwaysTrust => "AlwaysTrust",
                Self::NoCompress => "NoCompress",
                Self::Symmetric => "Symmetric",
                Self::ThrowKeyids => "ThrowKeyids",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for EncryptFlags {
    type GlibType = ffi::GMimeEncryptFlags;

    fn into_glib(self) -> ffi::GMimeEncryptFlags {
        match self {
            Self::None => ffi::GMIME_ENCRYPT_NONE,
            Self::AlwaysTrust => ffi::GMIME_ENCRYPT_ALWAYS_TRUST,
            Self::NoCompress => ffi::GMIME_ENCRYPT_NO_COMPRESS,
            Self::Symmetric => ffi::GMIME_ENCRYPT_SYMMETRIC,
            Self::ThrowKeyids => ffi::GMIME_ENCRYPT_THROW_KEYIDS,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimeEncryptFlags> for EncryptFlags {
    unsafe fn from_glib(value: ffi::GMimeEncryptFlags) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_ENCRYPT_NONE => Self::None,
            ffi::GMIME_ENCRYPT_ALWAYS_TRUST => Self::AlwaysTrust,
            ffi::GMIME_ENCRYPT_NO_COMPRESS => Self::NoCompress,
            ffi::GMIME_ENCRYPT_SYMMETRIC => Self::Symmetric,
            ffi::GMIME_ENCRYPT_THROW_KEYIDS => Self::ThrowKeyids,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimeFilterFromMode")]
pub enum FilterFromMode {
    #[doc(alias = "GMIME_FILTER_FROM_MODE_DEFAULT")]
    Default,
    #[doc(alias = "GMIME_FILTER_FROM_MODE_ARMOR")]
    Armor,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for FilterFromMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "FilterFromMode::{}",
            match *self {
                Self::Default => "Default",
                Self::Armor => "Armor",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for FilterFromMode {
    type GlibType = ffi::GMimeFilterFromMode;

    fn into_glib(self) -> ffi::GMimeFilterFromMode {
        match self {
            Self::Default => ffi::GMIME_FILTER_FROM_MODE_DEFAULT,
            Self::Armor => ffi::GMIME_FILTER_FROM_MODE_ARMOR,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimeFilterFromMode> for FilterFromMode {
    unsafe fn from_glib(value: ffi::GMimeFilterFromMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_FILTER_FROM_MODE_DEFAULT => Self::Default,
            ffi::GMIME_FILTER_FROM_MODE_ARMOR => Self::Armor,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimeFilterGZipMode")]
pub enum FilterGZipMode {
    #[doc(alias = "GMIME_FILTER_GZIP_MODE_ZIP")]
    Zip,
    #[doc(alias = "GMIME_FILTER_GZIP_MODE_UNZIP")]
    Unzip,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for FilterGZipMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "FilterGZipMode::{}",
            match *self {
                Self::Zip => "Zip",
                Self::Unzip => "Unzip",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for FilterGZipMode {
    type GlibType = ffi::GMimeFilterGZipMode;

    fn into_glib(self) -> ffi::GMimeFilterGZipMode {
        match self {
            Self::Zip => ffi::GMIME_FILTER_GZIP_MODE_ZIP,
            Self::Unzip => ffi::GMIME_FILTER_GZIP_MODE_UNZIP,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimeFilterGZipMode> for FilterGZipMode {
    unsafe fn from_glib(value: ffi::GMimeFilterGZipMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_FILTER_GZIP_MODE_ZIP => Self::Zip,
            ffi::GMIME_FILTER_GZIP_MODE_UNZIP => Self::Unzip,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimeFormat")]
pub enum Format {
    #[doc(alias = "GMIME_FORMAT_MESSAGE")]
    Message,
    #[doc(alias = "GMIME_FORMAT_MBOX")]
    Mbox,
    #[doc(alias = "GMIME_FORMAT_MMDF")]
    Mmdf,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Format {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Format::{}",
            match *self {
                Self::Message => "Message",
                Self::Mbox => "Mbox",
                Self::Mmdf => "Mmdf",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Format {
    type GlibType = ffi::GMimeFormat;

    fn into_glib(self) -> ffi::GMimeFormat {
        match self {
            Self::Message => ffi::GMIME_FORMAT_MESSAGE,
            Self::Mbox => ffi::GMIME_FORMAT_MBOX,
            Self::Mmdf => ffi::GMIME_FORMAT_MMDF,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimeFormat> for Format {
    unsafe fn from_glib(value: ffi::GMimeFormat) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_FORMAT_MESSAGE => Self::Message,
            ffi::GMIME_FORMAT_MBOX => Self::Mbox,
            ffi::GMIME_FORMAT_MMDF => Self::Mmdf,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimeNewLineFormat")]
pub enum NewLineFormat {
    #[doc(alias = "GMIME_NEWLINE_FORMAT_UNIX")]
    Unix,
    #[doc(alias = "GMIME_NEWLINE_FORMAT_DOS")]
    Dos,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for NewLineFormat {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "NewLineFormat::{}",
            match *self {
                Self::Unix => "Unix",
                Self::Dos => "Dos",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for NewLineFormat {
    type GlibType = ffi::GMimeNewLineFormat;

    fn into_glib(self) -> ffi::GMimeNewLineFormat {
        match self {
            Self::Unix => ffi::GMIME_NEWLINE_FORMAT_UNIX,
            Self::Dos => ffi::GMIME_NEWLINE_FORMAT_DOS,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimeNewLineFormat> for NewLineFormat {
    unsafe fn from_glib(value: ffi::GMimeNewLineFormat) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_NEWLINE_FORMAT_UNIX => Self::Unix,
            ffi::GMIME_NEWLINE_FORMAT_DOS => Self::Dos,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimeOpenPGPData")]
pub enum OpenPGPData {
    #[doc(alias = "GMIME_OPENPGP_DATA_NONE")]
    None,
    #[doc(alias = "GMIME_OPENPGP_DATA_ENCRYPTED")]
    Encrypted,
    #[doc(alias = "GMIME_OPENPGP_DATA_SIGNED")]
    Signed,
    #[doc(alias = "GMIME_OPENPGP_DATA_PUBLIC_KEY")]
    PublicKey,
    #[doc(alias = "GMIME_OPENPGP_DATA_PRIVATE_KEY")]
    PrivateKey,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for OpenPGPData {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "OpenPGPData::{}",
            match *self {
                Self::None => "None",
                Self::Encrypted => "Encrypted",
                Self::Signed => "Signed",
                Self::PublicKey => "PublicKey",
                Self::PrivateKey => "PrivateKey",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for OpenPGPData {
    type GlibType = ffi::GMimeOpenPGPData;

    fn into_glib(self) -> ffi::GMimeOpenPGPData {
        match self {
            Self::None => ffi::GMIME_OPENPGP_DATA_NONE,
            Self::Encrypted => ffi::GMIME_OPENPGP_DATA_ENCRYPTED,
            Self::Signed => ffi::GMIME_OPENPGP_DATA_SIGNED,
            Self::PublicKey => ffi::GMIME_OPENPGP_DATA_PUBLIC_KEY,
            Self::PrivateKey => ffi::GMIME_OPENPGP_DATA_PRIVATE_KEY,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimeOpenPGPData> for OpenPGPData {
    unsafe fn from_glib(value: ffi::GMimeOpenPGPData) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_OPENPGP_DATA_NONE => Self::None,
            ffi::GMIME_OPENPGP_DATA_ENCRYPTED => Self::Encrypted,
            ffi::GMIME_OPENPGP_DATA_SIGNED => Self::Signed,
            ffi::GMIME_OPENPGP_DATA_PUBLIC_KEY => Self::PublicKey,
            ffi::GMIME_OPENPGP_DATA_PRIVATE_KEY => Self::PrivateKey,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimeParamEncodingMethod")]
pub enum ParamEncodingMethod {
    #[doc(alias = "GMIME_PARAM_ENCODING_METHOD_DEFAULT")]
    Default,
    #[doc(alias = "GMIME_PARAM_ENCODING_METHOD_RFC2231")]
    Rfc2231,
    #[doc(alias = "GMIME_PARAM_ENCODING_METHOD_RFC2047")]
    Rfc2047,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ParamEncodingMethod {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ParamEncodingMethod::{}",
            match *self {
                Self::Default => "Default",
                Self::Rfc2231 => "Rfc2231",
                Self::Rfc2047 => "Rfc2047",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ParamEncodingMethod {
    type GlibType = ffi::GMimeParamEncodingMethod;

    fn into_glib(self) -> ffi::GMimeParamEncodingMethod {
        match self {
            Self::Default => ffi::GMIME_PARAM_ENCODING_METHOD_DEFAULT,
            Self::Rfc2231 => ffi::GMIME_PARAM_ENCODING_METHOD_RFC2231,
            Self::Rfc2047 => ffi::GMIME_PARAM_ENCODING_METHOD_RFC2047,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimeParamEncodingMethod> for ParamEncodingMethod {
    unsafe fn from_glib(value: ffi::GMimeParamEncodingMethod) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_PARAM_ENCODING_METHOD_DEFAULT => Self::Default,
            ffi::GMIME_PARAM_ENCODING_METHOD_RFC2231 => Self::Rfc2231,
            ffi::GMIME_PARAM_ENCODING_METHOD_RFC2047 => Self::Rfc2047,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimeParserWarning")]
pub enum ParserWarning {
    #[doc(alias = "GMIME_WARN_DUPLICATED_HEADER")]
    WarnDuplicatedHeader,
    #[doc(alias = "GMIME_WARN_DUPLICATED_PARAMETER")]
    WarnDuplicatedParameter,
    #[doc(alias = "GMIME_WARN_UNENCODED_8BIT_HEADER")]
    WarnUnencoded8bitHeader,
    #[doc(alias = "GMIME_WARN_INVALID_CONTENT_TYPE")]
    WarnInvalidContentType,
    #[doc(alias = "GMIME_WARN_INVALID_RFC2047_HEADER_VALUE")]
    WarnInvalidRfc2047HeaderValue,
    #[doc(alias = "GMIME_WARN_MALFORMED_MULTIPART")]
    WarnMalformedMultipart,
    #[doc(alias = "GMIME_WARN_TRUNCATED_MESSAGE")]
    WarnTruncatedMessage,
    #[doc(alias = "GMIME_WARN_MALFORMED_MESSAGE")]
    WarnMalformedMessage,
    #[doc(alias = "GMIME_CRIT_INVALID_HEADER_NAME")]
    CritInvalidHeaderName,
    #[doc(alias = "GMIME_CRIT_CONFLICTING_HEADER")]
    CritConflictingHeader,
    #[doc(alias = "GMIME_CRIT_CONFLICTING_PARAMETER")]
    CritConflictingParameter,
    #[doc(alias = "GMIME_CRIT_MULTIPART_WITHOUT_BOUNDARY")]
    CritMultipartWithoutBoundary,
    #[doc(alias = "GMIME_WARN_INVALID_PARAMETER")]
    WarnInvalidParameter,
    #[doc(alias = "GMIME_WARN_INVALID_ADDRESS_LIST")]
    WarnInvalidAddressList,
    #[doc(alias = "GMIME_CRIT_NESTING_OVERFLOW")]
    CritNestingOverflow,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ParserWarning {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ParserWarning::{}",
            match *self {
                Self::WarnDuplicatedHeader => "WarnDuplicatedHeader",
                Self::WarnDuplicatedParameter => "WarnDuplicatedParameter",
                Self::WarnUnencoded8bitHeader => "WarnUnencoded8bitHeader",
                Self::WarnInvalidContentType => "WarnInvalidContentType",
                Self::WarnInvalidRfc2047HeaderValue => "WarnInvalidRfc2047HeaderValue",
                Self::WarnMalformedMultipart => "WarnMalformedMultipart",
                Self::WarnTruncatedMessage => "WarnTruncatedMessage",
                Self::WarnMalformedMessage => "WarnMalformedMessage",
                Self::CritInvalidHeaderName => "CritInvalidHeaderName",
                Self::CritConflictingHeader => "CritConflictingHeader",
                Self::CritConflictingParameter => "CritConflictingParameter",
                Self::CritMultipartWithoutBoundary => "CritMultipartWithoutBoundary",
                Self::WarnInvalidParameter => "WarnInvalidParameter",
                Self::WarnInvalidAddressList => "WarnInvalidAddressList",
                Self::CritNestingOverflow => "CritNestingOverflow",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ParserWarning {
    type GlibType = ffi::GMimeParserWarning;

    fn into_glib(self) -> ffi::GMimeParserWarning {
        match self {
            Self::WarnDuplicatedHeader => ffi::GMIME_WARN_DUPLICATED_HEADER,
            Self::WarnDuplicatedParameter => ffi::GMIME_WARN_DUPLICATED_PARAMETER,
            Self::WarnUnencoded8bitHeader => ffi::GMIME_WARN_UNENCODED_8BIT_HEADER,
            Self::WarnInvalidContentType => ffi::GMIME_WARN_INVALID_CONTENT_TYPE,
            Self::WarnInvalidRfc2047HeaderValue => ffi::GMIME_WARN_INVALID_RFC2047_HEADER_VALUE,
            Self::WarnMalformedMultipart => ffi::GMIME_WARN_MALFORMED_MULTIPART,
            Self::WarnTruncatedMessage => ffi::GMIME_WARN_TRUNCATED_MESSAGE,
            Self::WarnMalformedMessage => ffi::GMIME_WARN_MALFORMED_MESSAGE,
            Self::CritInvalidHeaderName => ffi::GMIME_CRIT_INVALID_HEADER_NAME,
            Self::CritConflictingHeader => ffi::GMIME_CRIT_CONFLICTING_HEADER,
            Self::CritConflictingParameter => ffi::GMIME_CRIT_CONFLICTING_PARAMETER,
            Self::CritMultipartWithoutBoundary => ffi::GMIME_CRIT_MULTIPART_WITHOUT_BOUNDARY,
            Self::WarnInvalidParameter => ffi::GMIME_WARN_INVALID_PARAMETER,
            Self::WarnInvalidAddressList => ffi::GMIME_WARN_INVALID_ADDRESS_LIST,
            Self::CritNestingOverflow => ffi::GMIME_CRIT_NESTING_OVERFLOW,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimeParserWarning> for ParserWarning {
    unsafe fn from_glib(value: ffi::GMimeParserWarning) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_WARN_DUPLICATED_HEADER => Self::WarnDuplicatedHeader,
            ffi::GMIME_WARN_DUPLICATED_PARAMETER => Self::WarnDuplicatedParameter,
            ffi::GMIME_WARN_UNENCODED_8BIT_HEADER => Self::WarnUnencoded8bitHeader,
            ffi::GMIME_WARN_INVALID_CONTENT_TYPE => Self::WarnInvalidContentType,
            ffi::GMIME_WARN_INVALID_RFC2047_HEADER_VALUE => Self::WarnInvalidRfc2047HeaderValue,
            ffi::GMIME_WARN_MALFORMED_MULTIPART => Self::WarnMalformedMultipart,
            ffi::GMIME_WARN_TRUNCATED_MESSAGE => Self::WarnTruncatedMessage,
            ffi::GMIME_WARN_MALFORMED_MESSAGE => Self::WarnMalformedMessage,
            ffi::GMIME_CRIT_INVALID_HEADER_NAME => Self::CritInvalidHeaderName,
            ffi::GMIME_CRIT_CONFLICTING_HEADER => Self::CritConflictingHeader,
            ffi::GMIME_CRIT_CONFLICTING_PARAMETER => Self::CritConflictingParameter,
            ffi::GMIME_CRIT_MULTIPART_WITHOUT_BOUNDARY => Self::CritMultipartWithoutBoundary,
            ffi::GMIME_WARN_INVALID_PARAMETER => Self::WarnInvalidParameter,
            ffi::GMIME_WARN_INVALID_ADDRESS_LIST => Self::WarnInvalidAddressList,
            ffi::GMIME_CRIT_NESTING_OVERFLOW => Self::CritNestingOverflow,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimePubKeyAlgo")]
pub enum PubKeyAlgo {
    #[doc(alias = "GMIME_PUBKEY_ALGO_DEFAULT")]
    Default,
    #[doc(alias = "GMIME_PUBKEY_ALGO_RSA")]
    Rsa,
    #[doc(alias = "GMIME_PUBKEY_ALGO_RSA_E")]
    RsaE,
    #[doc(alias = "GMIME_PUBKEY_ALGO_RSA_S")]
    RsaS,
    #[doc(alias = "GMIME_PUBKEY_ALGO_ELG_E")]
    ElgE,
    #[doc(alias = "GMIME_PUBKEY_ALGO_DSA")]
    Dsa,
    #[doc(alias = "GMIME_PUBKEY_ALGO_ECC")]
    Ecc,
    #[doc(alias = "GMIME_PUBKEY_ALGO_ELG")]
    Elg,
    #[doc(alias = "GMIME_PUBKEY_ALGO_ECDSA")]
    Ecdsa,
    #[doc(alias = "GMIME_PUBKEY_ALGO_ECDH")]
    Ecdh,
    #[doc(alias = "GMIME_PUBKEY_ALGO_EDDSA")]
    Eddsa,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PubKeyAlgo {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PubKeyAlgo::{}",
            match *self {
                Self::Default => "Default",
                Self::Rsa => "Rsa",
                Self::RsaE => "RsaE",
                Self::RsaS => "RsaS",
                Self::ElgE => "ElgE",
                Self::Dsa => "Dsa",
                Self::Ecc => "Ecc",
                Self::Elg => "Elg",
                Self::Ecdsa => "Ecdsa",
                Self::Ecdh => "Ecdh",
                Self::Eddsa => "Eddsa",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PubKeyAlgo {
    type GlibType = ffi::GMimePubKeyAlgo;

    fn into_glib(self) -> ffi::GMimePubKeyAlgo {
        match self {
            Self::Default => ffi::GMIME_PUBKEY_ALGO_DEFAULT,
            Self::Rsa => ffi::GMIME_PUBKEY_ALGO_RSA,
            Self::RsaE => ffi::GMIME_PUBKEY_ALGO_RSA_E,
            Self::RsaS => ffi::GMIME_PUBKEY_ALGO_RSA_S,
            Self::ElgE => ffi::GMIME_PUBKEY_ALGO_ELG_E,
            Self::Dsa => ffi::GMIME_PUBKEY_ALGO_DSA,
            Self::Ecc => ffi::GMIME_PUBKEY_ALGO_ECC,
            Self::Elg => ffi::GMIME_PUBKEY_ALGO_ELG,
            Self::Ecdsa => ffi::GMIME_PUBKEY_ALGO_ECDSA,
            Self::Ecdh => ffi::GMIME_PUBKEY_ALGO_ECDH,
            Self::Eddsa => ffi::GMIME_PUBKEY_ALGO_EDDSA,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimePubKeyAlgo> for PubKeyAlgo {
    unsafe fn from_glib(value: ffi::GMimePubKeyAlgo) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_PUBKEY_ALGO_DEFAULT => Self::Default,
            ffi::GMIME_PUBKEY_ALGO_RSA => Self::Rsa,
            ffi::GMIME_PUBKEY_ALGO_RSA_E => Self::RsaE,
            ffi::GMIME_PUBKEY_ALGO_RSA_S => Self::RsaS,
            ffi::GMIME_PUBKEY_ALGO_ELG_E => Self::ElgE,
            ffi::GMIME_PUBKEY_ALGO_DSA => Self::Dsa,
            ffi::GMIME_PUBKEY_ALGO_ECC => Self::Ecc,
            ffi::GMIME_PUBKEY_ALGO_ELG => Self::Elg,
            ffi::GMIME_PUBKEY_ALGO_ECDSA => Self::Ecdsa,
            ffi::GMIME_PUBKEY_ALGO_ECDH => Self::Ecdh,
            ffi::GMIME_PUBKEY_ALGO_EDDSA => Self::Eddsa,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimeRfcComplianceMode")]
pub enum RfcComplianceMode {
    #[doc(alias = "GMIME_RFC_COMPLIANCE_LOOSE")]
    Loose,
    #[doc(alias = "GMIME_RFC_COMPLIANCE_STRICT")]
    Strict,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for RfcComplianceMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "RfcComplianceMode::{}",
            match *self {
                Self::Loose => "Loose",
                Self::Strict => "Strict",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for RfcComplianceMode {
    type GlibType = ffi::GMimeRfcComplianceMode;

    fn into_glib(self) -> ffi::GMimeRfcComplianceMode {
        match self {
            Self::Loose => ffi::GMIME_RFC_COMPLIANCE_LOOSE,
            Self::Strict => ffi::GMIME_RFC_COMPLIANCE_STRICT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimeRfcComplianceMode> for RfcComplianceMode {
    unsafe fn from_glib(value: ffi::GMimeRfcComplianceMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_RFC_COMPLIANCE_LOOSE => Self::Loose,
            ffi::GMIME_RFC_COMPLIANCE_STRICT => Self::Strict,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimeSecureMimeType")]
pub enum SecureMimeType {
    #[doc(alias = "GMIME_SECURE_MIME_TYPE_COMPRESSED_DATA")]
    CompressedData,
    #[doc(alias = "GMIME_SECURE_MIME_TYPE_ENVELOPED_DATA")]
    EnvelopedData,
    #[doc(alias = "GMIME_SECURE_MIME_TYPE_SIGNED_DATA")]
    SignedData,
    #[doc(alias = "GMIME_SECURE_MIME_TYPE_CERTS_ONLY")]
    CertsOnly,
    #[doc(alias = "GMIME_SECURE_MIME_TYPE_UNKNOWN")]
    Unknown,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for SecureMimeType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "SecureMimeType::{}",
            match *self {
                Self::CompressedData => "CompressedData",
                Self::EnvelopedData => "EnvelopedData",
                Self::SignedData => "SignedData",
                Self::CertsOnly => "CertsOnly",
                Self::Unknown => "Unknown",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for SecureMimeType {
    type GlibType = ffi::GMimeSecureMimeType;

    fn into_glib(self) -> ffi::GMimeSecureMimeType {
        match self {
            Self::CompressedData => ffi::GMIME_SECURE_MIME_TYPE_COMPRESSED_DATA,
            Self::EnvelopedData => ffi::GMIME_SECURE_MIME_TYPE_ENVELOPED_DATA,
            Self::SignedData => ffi::GMIME_SECURE_MIME_TYPE_SIGNED_DATA,
            Self::CertsOnly => ffi::GMIME_SECURE_MIME_TYPE_CERTS_ONLY,
            Self::Unknown => ffi::GMIME_SECURE_MIME_TYPE_UNKNOWN,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimeSecureMimeType> for SecureMimeType {
    unsafe fn from_glib(value: ffi::GMimeSecureMimeType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_SECURE_MIME_TYPE_COMPRESSED_DATA => Self::CompressedData,
            ffi::GMIME_SECURE_MIME_TYPE_ENVELOPED_DATA => Self::EnvelopedData,
            ffi::GMIME_SECURE_MIME_TYPE_SIGNED_DATA => Self::SignedData,
            ffi::GMIME_SECURE_MIME_TYPE_CERTS_ONLY => Self::CertsOnly,
            ffi::GMIME_SECURE_MIME_TYPE_UNKNOWN => Self::Unknown,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimeSeekWhence")]
pub enum SeekWhence {
    #[doc(alias = "GMIME_STREAM_SEEK_SET")]
    Set,
    #[doc(alias = "GMIME_STREAM_SEEK_CUR")]
    Cur,
    #[doc(alias = "GMIME_STREAM_SEEK_END")]
    End,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for SeekWhence {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "SeekWhence::{}",
            match *self {
                Self::Set => "Set",
                Self::Cur => "Cur",
                Self::End => "End",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for SeekWhence {
    type GlibType = ffi::GMimeSeekWhence;

    fn into_glib(self) -> ffi::GMimeSeekWhence {
        match self {
            Self::Set => ffi::GMIME_STREAM_SEEK_SET,
            Self::Cur => ffi::GMIME_STREAM_SEEK_CUR,
            Self::End => ffi::GMIME_STREAM_SEEK_END,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimeSeekWhence> for SeekWhence {
    unsafe fn from_glib(value: ffi::GMimeSeekWhence) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_STREAM_SEEK_SET => Self::Set,
            ffi::GMIME_STREAM_SEEK_CUR => Self::Cur,
            ffi::GMIME_STREAM_SEEK_END => Self::End,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimeSignatureStatus")]
pub enum SignatureStatus {
    #[doc(alias = "GMIME_SIGNATURE_STATUS_VALID")]
    Valid,
    #[doc(alias = "GMIME_SIGNATURE_STATUS_GREEN")]
    Green,
    #[doc(alias = "GMIME_SIGNATURE_STATUS_RED")]
    Red,
    #[doc(alias = "GMIME_SIGNATURE_STATUS_KEY_REVOKED")]
    KeyRevoked,
    #[doc(alias = "GMIME_SIGNATURE_STATUS_KEY_EXPIRED")]
    KeyExpired,
    #[doc(alias = "GMIME_SIGNATURE_STATUS_SIG_EXPIRED")]
    SigExpired,
    #[doc(alias = "GMIME_SIGNATURE_STATUS_KEY_MISSING")]
    KeyMissing,
    #[doc(alias = "GMIME_SIGNATURE_STATUS_CRL_MISSING")]
    CrlMissing,
    #[doc(alias = "GMIME_SIGNATURE_STATUS_CRL_TOO_OLD")]
    CrlTooOld,
    #[doc(alias = "GMIME_SIGNATURE_STATUS_BAD_POLICY")]
    BadPolicy,
    #[doc(alias = "GMIME_SIGNATURE_STATUS_SYS_ERROR")]
    SysError,
    #[doc(alias = "GMIME_SIGNATURE_STATUS_TOFU_CONFLICT")]
    TofuConflict,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for SignatureStatus {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "SignatureStatus::{}",
            match *self {
                Self::Valid => "Valid",
                Self::Green => "Green",
                Self::Red => "Red",
                Self::KeyRevoked => "KeyRevoked",
                Self::KeyExpired => "KeyExpired",
                Self::SigExpired => "SigExpired",
                Self::KeyMissing => "KeyMissing",
                Self::CrlMissing => "CrlMissing",
                Self::CrlTooOld => "CrlTooOld",
                Self::BadPolicy => "BadPolicy",
                Self::SysError => "SysError",
                Self::TofuConflict => "TofuConflict",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for SignatureStatus {
    type GlibType = ffi::GMimeSignatureStatus;

    fn into_glib(self) -> ffi::GMimeSignatureStatus {
        match self {
            Self::Valid => ffi::GMIME_SIGNATURE_STATUS_VALID,
            Self::Green => ffi::GMIME_SIGNATURE_STATUS_GREEN,
            Self::Red => ffi::GMIME_SIGNATURE_STATUS_RED,
            Self::KeyRevoked => ffi::GMIME_SIGNATURE_STATUS_KEY_REVOKED,
            Self::KeyExpired => ffi::GMIME_SIGNATURE_STATUS_KEY_EXPIRED,
            Self::SigExpired => ffi::GMIME_SIGNATURE_STATUS_SIG_EXPIRED,
            Self::KeyMissing => ffi::GMIME_SIGNATURE_STATUS_KEY_MISSING,
            Self::CrlMissing => ffi::GMIME_SIGNATURE_STATUS_CRL_MISSING,
            Self::CrlTooOld => ffi::GMIME_SIGNATURE_STATUS_CRL_TOO_OLD,
            Self::BadPolicy => ffi::GMIME_SIGNATURE_STATUS_BAD_POLICY,
            Self::SysError => ffi::GMIME_SIGNATURE_STATUS_SYS_ERROR,
            Self::TofuConflict => ffi::GMIME_SIGNATURE_STATUS_TOFU_CONFLICT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimeSignatureStatus> for SignatureStatus {
    unsafe fn from_glib(value: ffi::GMimeSignatureStatus) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_SIGNATURE_STATUS_VALID => Self::Valid,
            ffi::GMIME_SIGNATURE_STATUS_GREEN => Self::Green,
            ffi::GMIME_SIGNATURE_STATUS_RED => Self::Red,
            ffi::GMIME_SIGNATURE_STATUS_KEY_REVOKED => Self::KeyRevoked,
            ffi::GMIME_SIGNATURE_STATUS_KEY_EXPIRED => Self::KeyExpired,
            ffi::GMIME_SIGNATURE_STATUS_SIG_EXPIRED => Self::SigExpired,
            ffi::GMIME_SIGNATURE_STATUS_KEY_MISSING => Self::KeyMissing,
            ffi::GMIME_SIGNATURE_STATUS_CRL_MISSING => Self::CrlMissing,
            ffi::GMIME_SIGNATURE_STATUS_CRL_TOO_OLD => Self::CrlTooOld,
            ffi::GMIME_SIGNATURE_STATUS_BAD_POLICY => Self::BadPolicy,
            ffi::GMIME_SIGNATURE_STATUS_SYS_ERROR => Self::SysError,
            ffi::GMIME_SIGNATURE_STATUS_TOFU_CONFLICT => Self::TofuConflict,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimeStreamBufferMode")]
pub enum StreamBufferMode {
    #[doc(alias = "GMIME_STREAM_BUFFER_BLOCK_READ")]
    Read,
    #[doc(alias = "GMIME_STREAM_BUFFER_BLOCK_WRITE")]
    Write,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for StreamBufferMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "StreamBufferMode::{}",
            match *self {
                Self::Read => "Read",
                Self::Write => "Write",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for StreamBufferMode {
    type GlibType = ffi::GMimeStreamBufferMode;

    fn into_glib(self) -> ffi::GMimeStreamBufferMode {
        match self {
            Self::Read => ffi::GMIME_STREAM_BUFFER_BLOCK_READ,
            Self::Write => ffi::GMIME_STREAM_BUFFER_BLOCK_WRITE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimeStreamBufferMode> for StreamBufferMode {
    unsafe fn from_glib(value: ffi::GMimeStreamBufferMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_STREAM_BUFFER_BLOCK_READ => Self::Read,
            ffi::GMIME_STREAM_BUFFER_BLOCK_WRITE => Self::Write,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimeTrust")]
pub enum Trust {
    #[doc(alias = "GMIME_TRUST_UNKNOWN")]
    Unknown,
    #[doc(alias = "GMIME_TRUST_UNDEFINED")]
    Undefined,
    #[doc(alias = "GMIME_TRUST_NEVER")]
    Never,
    #[doc(alias = "GMIME_TRUST_MARGINAL")]
    Marginal,
    #[doc(alias = "GMIME_TRUST_FULL")]
    Full,
    #[doc(alias = "GMIME_TRUST_ULTIMATE")]
    Ultimate,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Trust {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Trust::{}",
            match *self {
                Self::Unknown => "Unknown",
                Self::Undefined => "Undefined",
                Self::Never => "Never",
                Self::Marginal => "Marginal",
                Self::Full => "Full",
                Self::Ultimate => "Ultimate",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Trust {
    type GlibType = ffi::GMimeTrust;

    fn into_glib(self) -> ffi::GMimeTrust {
        match self {
            Self::Unknown => ffi::GMIME_TRUST_UNKNOWN,
            Self::Undefined => ffi::GMIME_TRUST_UNDEFINED,
            Self::Never => ffi::GMIME_TRUST_NEVER,
            Self::Marginal => ffi::GMIME_TRUST_MARGINAL,
            Self::Full => ffi::GMIME_TRUST_FULL,
            Self::Ultimate => ffi::GMIME_TRUST_ULTIMATE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimeTrust> for Trust {
    unsafe fn from_glib(value: ffi::GMimeTrust) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_TRUST_UNKNOWN => Self::Unknown,
            ffi::GMIME_TRUST_UNDEFINED => Self::Undefined,
            ffi::GMIME_TRUST_NEVER => Self::Never,
            ffi::GMIME_TRUST_MARGINAL => Self::Marginal,
            ffi::GMIME_TRUST_FULL => Self::Full,
            ffi::GMIME_TRUST_ULTIMATE => Self::Ultimate,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMimeValidity")]
pub enum Validity {
    #[doc(alias = "GMIME_VALIDITY_UNKNOWN")]
    Unknown,
    #[doc(alias = "GMIME_VALIDITY_UNDEFINED")]
    Undefined,
    #[doc(alias = "GMIME_VALIDITY_NEVER")]
    Never,
    #[doc(alias = "GMIME_VALIDITY_MARGINAL")]
    Marginal,
    #[doc(alias = "GMIME_VALIDITY_FULL")]
    Full,
    #[doc(alias = "GMIME_VALIDITY_ULTIMATE")]
    Ultimate,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Validity {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Validity::{}",
            match *self {
                Self::Unknown => "Unknown",
                Self::Undefined => "Undefined",
                Self::Never => "Never",
                Self::Marginal => "Marginal",
                Self::Full => "Full",
                Self::Ultimate => "Ultimate",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Validity {
    type GlibType = ffi::GMimeValidity;

    fn into_glib(self) -> ffi::GMimeValidity {
        match self {
            Self::Unknown => ffi::GMIME_VALIDITY_UNKNOWN,
            Self::Undefined => ffi::GMIME_VALIDITY_UNDEFINED,
            Self::Never => ffi::GMIME_VALIDITY_NEVER,
            Self::Marginal => ffi::GMIME_VALIDITY_MARGINAL,
            Self::Full => ffi::GMIME_VALIDITY_FULL,
            Self::Ultimate => ffi::GMIME_VALIDITY_ULTIMATE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMimeValidity> for Validity {
    unsafe fn from_glib(value: ffi::GMimeValidity) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GMIME_VALIDITY_UNKNOWN => Self::Unknown,
            ffi::GMIME_VALIDITY_UNDEFINED => Self::Undefined,
            ffi::GMIME_VALIDITY_NEVER => Self::Never,
            ffi::GMIME_VALIDITY_MARGINAL => Self::Marginal,
            ffi::GMIME_VALIDITY_FULL => Self::Full,
            ffi::GMIME_VALIDITY_ULTIMATE => Self::Ultimate,
            value => Self::__Unknown(value),
        }
    }
}
