// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/vhdirk/gir-files.git)
// DO NOT EDIT

use crate::ContentEncoding;
use crate::Stream;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;

glib::wrapper! {
    #[doc(alias = "GMimeDataWrapper")]
    pub struct DataWrapper(Object<ffi::GMimeDataWrapper, ffi::GMimeDataWrapperClass>);

    match fn {
        type_ => || ffi::g_mime_data_wrapper_get_type(),
    }
}

impl DataWrapper {
    #[doc(alias = "g_mime_data_wrapper_new")]
    pub fn new() -> DataWrapper {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::g_mime_data_wrapper_new()) }
    }

    #[doc(alias = "g_mime_data_wrapper_new_with_stream")]
    #[doc(alias = "new_with_stream")]
    pub fn with_stream(stream: &impl IsA<Stream>, encoding: ContentEncoding) -> DataWrapper {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::g_mime_data_wrapper_new_with_stream(
                stream.as_ref().to_glib_none().0,
                encoding.into_glib(),
            ))
        }
    }
}

impl Default for DataWrapper {
    fn default() -> Self {
        Self::new()
    }
}

pub const NONE_DATA_WRAPPER: Option<&DataWrapper> = None;

pub trait DataWrapperExt: 'static {
    #[doc(alias = "g_mime_data_wrapper_get_encoding")]
    #[doc(alias = "get_encoding")]
    fn encoding(&self) -> ContentEncoding;

    #[doc(alias = "g_mime_data_wrapper_get_stream")]
    #[doc(alias = "get_stream")]
    fn stream(&self) -> Option<Stream>;

    #[doc(alias = "g_mime_data_wrapper_set_encoding")]
    fn set_encoding(&self, encoding: ContentEncoding);

    #[doc(alias = "g_mime_data_wrapper_set_stream")]
    fn set_stream(&self, stream: &impl IsA<Stream>);

    #[doc(alias = "g_mime_data_wrapper_write_to_stream")]
    fn write_to_stream(&self, stream: &impl IsA<Stream>) -> isize;
}

impl<O: IsA<DataWrapper>> DataWrapperExt for O {
    fn encoding(&self) -> ContentEncoding {
        unsafe {
            from_glib(ffi::g_mime_data_wrapper_get_encoding(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn stream(&self) -> Option<Stream> {
        unsafe {
            from_glib_none(ffi::g_mime_data_wrapper_get_stream(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_encoding(&self, encoding: ContentEncoding) {
        unsafe {
            ffi::g_mime_data_wrapper_set_encoding(
                self.as_ref().to_glib_none().0,
                encoding.into_glib(),
            );
        }
    }

    fn set_stream(&self, stream: &impl IsA<Stream>) {
        unsafe {
            ffi::g_mime_data_wrapper_set_stream(
                self.as_ref().to_glib_none().0,
                stream.as_ref().to_glib_none().0,
            );
        }
    }

    fn write_to_stream(&self, stream: &impl IsA<Stream>) -> isize {
        unsafe {
            ffi::g_mime_data_wrapper_write_to_stream(
                self.as_ref().to_glib_none().0,
                stream.as_ref().to_glib_none().0,
            )
        }
    }
}

impl fmt::Display for DataWrapper {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("DataWrapper")
    }
}
