// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/vhdirk/gir-files.git)
// DO NOT EDIT

use crate::FormatOptions;
use crate::ParamList;
use crate::ParserOptions;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;

glib::wrapper! {
    #[doc(alias = "GMimeContentType")]
    pub struct ContentType(Object<ffi::GMimeContentType, ffi::GMimeContentTypeClass>);

    match fn {
        type_ => || ffi::g_mime_content_type_get_type(),
    }
}

impl ContentType {
    #[doc(alias = "g_mime_content_type_new")]
    pub fn new(type_: &str, subtype: &str) -> ContentType {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::g_mime_content_type_new(
                type_.to_glib_none().0,
                subtype.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_mime_content_type_parse")]
    pub fn parse(options: Option<&ParserOptions>, str: &str) -> Option<ContentType> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::g_mime_content_type_parse(
                mut_override(options.to_glib_none().0),
                str.to_glib_none().0,
            ))
        }
    }
}

pub const NONE_CONTENT_TYPE: Option<&ContentType> = None;

pub trait ContentTypeExt: 'static {
    #[doc(alias = "g_mime_content_type_encode")]
    fn encode(&self, options: Option<&FormatOptions>) -> Option<glib::GString>;

    #[doc(alias = "g_mime_content_type_get_media_subtype")]
    #[doc(alias = "get_media_subtype")]
    fn media_subtype(&self) -> Option<glib::GString>;

    #[doc(alias = "g_mime_content_type_get_media_type")]
    #[doc(alias = "get_media_type")]
    fn media_type(&self) -> Option<glib::GString>;

    #[doc(alias = "g_mime_content_type_get_mime_type")]
    #[doc(alias = "get_mime_type")]
    fn mime_type(&self) -> Option<glib::GString>;

    #[doc(alias = "g_mime_content_type_get_parameter")]
    #[doc(alias = "get_parameter")]
    fn parameter(&self, name: &str) -> Option<glib::GString>;

    #[doc(alias = "g_mime_content_type_get_parameters")]
    #[doc(alias = "get_parameters")]
    fn parameters(&self) -> Option<ParamList>;

    #[doc(alias = "g_mime_content_type_is_type")]
    fn is_type(&self, type_: &str, subtype: &str) -> bool;

    #[doc(alias = "g_mime_content_type_set_media_subtype")]
    fn set_media_subtype(&self, subtype: &str);

    #[doc(alias = "g_mime_content_type_set_media_type")]
    fn set_media_type(&self, type_: &str);

    #[doc(alias = "g_mime_content_type_set_parameter")]
    fn set_parameter(&self, name: &str, value: &str);
}

impl<O: IsA<ContentType>> ContentTypeExt for O {
    fn encode(&self, options: Option<&FormatOptions>) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::g_mime_content_type_encode(
                self.as_ref().to_glib_none().0,
                mut_override(options.to_glib_none().0),
            ))
        }
    }

    fn media_subtype(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_mime_content_type_get_media_subtype(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn media_type(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_mime_content_type_get_media_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn mime_type(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::g_mime_content_type_get_mime_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn parameter(&self, name: &str) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_mime_content_type_get_parameter(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    fn parameters(&self) -> Option<ParamList> {
        unsafe {
            from_glib_none(ffi::g_mime_content_type_get_parameters(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_type(&self, type_: &str, subtype: &str) -> bool {
        unsafe {
            from_glib(ffi::g_mime_content_type_is_type(
                self.as_ref().to_glib_none().0,
                type_.to_glib_none().0,
                subtype.to_glib_none().0,
            ))
        }
    }

    fn set_media_subtype(&self, subtype: &str) {
        unsafe {
            ffi::g_mime_content_type_set_media_subtype(
                self.as_ref().to_glib_none().0,
                subtype.to_glib_none().0,
            );
        }
    }

    fn set_media_type(&self, type_: &str) {
        unsafe {
            ffi::g_mime_content_type_set_media_type(
                self.as_ref().to_glib_none().0,
                type_.to_glib_none().0,
            );
        }
    }

    fn set_parameter(&self, name: &str, value: &str) {
        unsafe {
            ffi::g_mime_content_type_set_parameter(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
                value.to_glib_none().0,
            );
        }
    }
}

impl fmt::Display for ContentType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("ContentType")
    }
}
