// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/vhdirk/gir-files.git)
// DO NOT EDIT

use crate::FormatOptions;
use crate::ParamList;
use crate::ParserOptions;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;

glib::wrapper! {
    #[doc(alias = "GMimeContentDisposition")]
    pub struct ContentDisposition(Object<ffi::GMimeContentDisposition, ffi::GMimeContentDispositionClass>);

    match fn {
        type_ => || ffi::g_mime_content_disposition_get_type(),
    }
}

impl ContentDisposition {
    #[doc(alias = "g_mime_content_disposition_new")]
    pub fn new() -> ContentDisposition {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::g_mime_content_disposition_new()) }
    }

    #[doc(alias = "g_mime_content_disposition_parse")]
    pub fn parse(options: Option<&ParserOptions>, str: &str) -> Option<ContentDisposition> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::g_mime_content_disposition_parse(
                mut_override(options.to_glib_none().0),
                str.to_glib_none().0,
            ))
        }
    }
}

impl Default for ContentDisposition {
    fn default() -> Self {
        Self::new()
    }
}

pub const NONE_CONTENT_DISPOSITION: Option<&ContentDisposition> = None;

pub trait ContentDispositionExt: 'static {
    #[doc(alias = "g_mime_content_disposition_encode")]
    fn encode(&self, options: Option<&FormatOptions>) -> Option<glib::GString>;

    #[doc(alias = "g_mime_content_disposition_get_disposition")]
    #[doc(alias = "get_disposition")]
    fn disposition(&self) -> Option<glib::GString>;

    #[doc(alias = "g_mime_content_disposition_get_parameter")]
    #[doc(alias = "get_parameter")]
    fn parameter(&self, name: &str) -> Option<glib::GString>;

    #[doc(alias = "g_mime_content_disposition_get_parameters")]
    #[doc(alias = "get_parameters")]
    fn parameters(&self) -> Option<ParamList>;

    #[doc(alias = "g_mime_content_disposition_is_attachment")]
    fn is_attachment(&self) -> bool;

    #[doc(alias = "g_mime_content_disposition_set_disposition")]
    fn set_disposition(&self, value: &str);

    #[doc(alias = "g_mime_content_disposition_set_parameter")]
    fn set_parameter(&self, name: &str, value: &str);
}

impl<O: IsA<ContentDisposition>> ContentDispositionExt for O {
    fn encode(&self, options: Option<&FormatOptions>) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::g_mime_content_disposition_encode(
                self.as_ref().to_glib_none().0,
                mut_override(options.to_glib_none().0),
            ))
        }
    }

    fn disposition(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_mime_content_disposition_get_disposition(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn parameter(&self, name: &str) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_mime_content_disposition_get_parameter(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    fn parameters(&self) -> Option<ParamList> {
        unsafe {
            from_glib_none(ffi::g_mime_content_disposition_get_parameters(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_attachment(&self) -> bool {
        unsafe {
            from_glib(ffi::g_mime_content_disposition_is_attachment(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_disposition(&self, value: &str) {
        unsafe {
            ffi::g_mime_content_disposition_set_disposition(
                self.as_ref().to_glib_none().0,
                value.to_glib_none().0,
            );
        }
    }

    fn set_parameter(&self, name: &str, value: &str) {
        unsafe {
            ffi::g_mime_content_disposition_set_parameter(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
                value.to_glib_none().0,
            );
        }
    }
}

impl fmt::Display for ContentDisposition {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("ContentDisposition")
    }
}
