// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/vhdirk/gir-files.git)
// DO NOT EDIT

use crate::DigestAlgo;
use crate::PubKeyAlgo;
use crate::Trust;
use crate::Validity;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;

glib::wrapper! {
    #[doc(alias = "GMimeCertificate")]
    pub struct Certificate(Object<ffi::GMimeCertificate, ffi::GMimeCertificateClass>);

    match fn {
        type_ => || ffi::g_mime_certificate_get_type(),
    }
}

impl Certificate {
    #[doc(alias = "g_mime_certificate_new")]
    pub fn new() -> Certificate {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::g_mime_certificate_new()) }
    }
}

impl Default for Certificate {
    fn default() -> Self {
        Self::new()
    }
}

pub const NONE_CERTIFICATE: Option<&Certificate> = None;

pub trait CertificateExt: 'static {
    #[doc(alias = "g_mime_certificate_get_created")]
    #[doc(alias = "get_created")]
    fn created(&self) -> libc::c_long;

    #[doc(alias = "g_mime_certificate_get_created64")]
    #[doc(alias = "get_created64")]
    fn created64(&self) -> i64;

    #[doc(alias = "g_mime_certificate_get_digest_algo")]
    #[doc(alias = "get_digest_algo")]
    fn digest_algo(&self) -> DigestAlgo;

    #[doc(alias = "g_mime_certificate_get_email")]
    #[doc(alias = "get_email")]
    fn email(&self) -> Option<glib::GString>;

    #[doc(alias = "g_mime_certificate_get_expires")]
    #[doc(alias = "get_expires")]
    fn expires(&self) -> libc::c_long;

    #[doc(alias = "g_mime_certificate_get_expires64")]
    #[doc(alias = "get_expires64")]
    fn expires64(&self) -> i64;

    #[doc(alias = "g_mime_certificate_get_fingerprint")]
    #[doc(alias = "get_fingerprint")]
    fn fingerprint(&self) -> Option<glib::GString>;

    #[doc(alias = "g_mime_certificate_get_id_validity")]
    #[doc(alias = "get_id_validity")]
    fn id_validity(&self) -> Validity;

    #[doc(alias = "g_mime_certificate_get_issuer_name")]
    #[doc(alias = "get_issuer_name")]
    fn issuer_name(&self) -> Option<glib::GString>;

    #[doc(alias = "g_mime_certificate_get_issuer_serial")]
    #[doc(alias = "get_issuer_serial")]
    fn issuer_serial(&self) -> Option<glib::GString>;

    #[doc(alias = "g_mime_certificate_get_key_id")]
    #[doc(alias = "get_key_id")]
    fn key_id(&self) -> Option<glib::GString>;

    #[doc(alias = "g_mime_certificate_get_name")]
    #[doc(alias = "get_name")]
    fn name(&self) -> Option<glib::GString>;

    #[doc(alias = "g_mime_certificate_get_pubkey_algo")]
    #[doc(alias = "get_pubkey_algo")]
    fn pubkey_algo(&self) -> PubKeyAlgo;

    #[doc(alias = "g_mime_certificate_get_trust")]
    #[doc(alias = "get_trust")]
    fn trust(&self) -> Trust;

    #[doc(alias = "g_mime_certificate_get_user_id")]
    #[doc(alias = "get_user_id")]
    fn user_id(&self) -> Option<glib::GString>;

    #[doc(alias = "g_mime_certificate_set_created")]
    fn set_created(&self, created: libc::c_long);

    #[doc(alias = "g_mime_certificate_set_digest_algo")]
    fn set_digest_algo(&self, algo: DigestAlgo);

    #[doc(alias = "g_mime_certificate_set_email")]
    fn set_email(&self, email: &str);

    #[doc(alias = "g_mime_certificate_set_expires")]
    fn set_expires(&self, expires: libc::c_long);

    #[doc(alias = "g_mime_certificate_set_fingerprint")]
    fn set_fingerprint(&self, fingerprint: &str);

    #[doc(alias = "g_mime_certificate_set_id_validity")]
    fn set_id_validity(&self, validity: Validity);

    #[doc(alias = "g_mime_certificate_set_issuer_name")]
    fn set_issuer_name(&self, issuer_name: &str);

    #[doc(alias = "g_mime_certificate_set_issuer_serial")]
    fn set_issuer_serial(&self, issuer_serial: &str);

    #[doc(alias = "g_mime_certificate_set_key_id")]
    fn set_key_id(&self, key_id: &str);

    #[doc(alias = "g_mime_certificate_set_name")]
    fn set_name(&self, name: &str);

    #[doc(alias = "g_mime_certificate_set_pubkey_algo")]
    fn set_pubkey_algo(&self, algo: PubKeyAlgo);

    #[doc(alias = "g_mime_certificate_set_trust")]
    fn set_trust(&self, trust: Trust);

    #[doc(alias = "g_mime_certificate_set_user_id")]
    fn set_user_id(&self, user_id: &str);
}

impl<O: IsA<Certificate>> CertificateExt for O {
    fn created(&self) -> libc::c_long {
        unsafe { ffi::g_mime_certificate_get_created(self.as_ref().to_glib_none().0) }
    }

    fn created64(&self) -> i64 {
        unsafe { ffi::g_mime_certificate_get_created64(self.as_ref().to_glib_none().0) }
    }

    fn digest_algo(&self) -> DigestAlgo {
        unsafe {
            from_glib(ffi::g_mime_certificate_get_digest_algo(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn email(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_mime_certificate_get_email(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn expires(&self) -> libc::c_long {
        unsafe { ffi::g_mime_certificate_get_expires(self.as_ref().to_glib_none().0) }
    }

    fn expires64(&self) -> i64 {
        unsafe { ffi::g_mime_certificate_get_expires64(self.as_ref().to_glib_none().0) }
    }

    fn fingerprint(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_mime_certificate_get_fingerprint(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn id_validity(&self) -> Validity {
        unsafe {
            from_glib(ffi::g_mime_certificate_get_id_validity(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn issuer_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_mime_certificate_get_issuer_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn issuer_serial(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_mime_certificate_get_issuer_serial(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn key_id(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_mime_certificate_get_key_id(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_mime_certificate_get_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn pubkey_algo(&self) -> PubKeyAlgo {
        unsafe {
            from_glib(ffi::g_mime_certificate_get_pubkey_algo(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn trust(&self) -> Trust {
        unsafe {
            from_glib(ffi::g_mime_certificate_get_trust(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn user_id(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_mime_certificate_get_user_id(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_created(&self, created: libc::c_long) {
        unsafe {
            ffi::g_mime_certificate_set_created(self.as_ref().to_glib_none().0, created);
        }
    }

    fn set_digest_algo(&self, algo: DigestAlgo) {
        unsafe {
            ffi::g_mime_certificate_set_digest_algo(
                self.as_ref().to_glib_none().0,
                algo.into_glib(),
            );
        }
    }

    fn set_email(&self, email: &str) {
        unsafe {
            ffi::g_mime_certificate_set_email(
                self.as_ref().to_glib_none().0,
                email.to_glib_none().0,
            );
        }
    }

    fn set_expires(&self, expires: libc::c_long) {
        unsafe {
            ffi::g_mime_certificate_set_expires(self.as_ref().to_glib_none().0, expires);
        }
    }

    fn set_fingerprint(&self, fingerprint: &str) {
        unsafe {
            ffi::g_mime_certificate_set_fingerprint(
                self.as_ref().to_glib_none().0,
                fingerprint.to_glib_none().0,
            );
        }
    }

    fn set_id_validity(&self, validity: Validity) {
        unsafe {
            ffi::g_mime_certificate_set_id_validity(
                self.as_ref().to_glib_none().0,
                validity.into_glib(),
            );
        }
    }

    fn set_issuer_name(&self, issuer_name: &str) {
        unsafe {
            ffi::g_mime_certificate_set_issuer_name(
                self.as_ref().to_glib_none().0,
                issuer_name.to_glib_none().0,
            );
        }
    }

    fn set_issuer_serial(&self, issuer_serial: &str) {
        unsafe {
            ffi::g_mime_certificate_set_issuer_serial(
                self.as_ref().to_glib_none().0,
                issuer_serial.to_glib_none().0,
            );
        }
    }

    fn set_key_id(&self, key_id: &str) {
        unsafe {
            ffi::g_mime_certificate_set_key_id(
                self.as_ref().to_glib_none().0,
                key_id.to_glib_none().0,
            );
        }
    }

    fn set_name(&self, name: &str) {
        unsafe {
            ffi::g_mime_certificate_set_name(self.as_ref().to_glib_none().0, name.to_glib_none().0);
        }
    }

    fn set_pubkey_algo(&self, algo: PubKeyAlgo) {
        unsafe {
            ffi::g_mime_certificate_set_pubkey_algo(
                self.as_ref().to_glib_none().0,
                algo.into_glib(),
            );
        }
    }

    fn set_trust(&self, trust: Trust) {
        unsafe {
            ffi::g_mime_certificate_set_trust(self.as_ref().to_glib_none().0, trust.into_glib());
        }
    }

    fn set_user_id(&self, user_id: &str) {
        unsafe {
            ffi::g_mime_certificate_set_user_id(
                self.as_ref().to_glib_none().0,
                user_id.to_glib_none().0,
            );
        }
    }
}

impl fmt::Display for Certificate {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Certificate")
    }
}
