#![warn(missing_docs)]
#![warn(missing_doc_code_examples)]

//! A crate for dealing with the Gemini (and Mercury) protocol
//!
//! This crate is split into three parts:
//! - [`gemtext`]
//! - [`req_resp`]
//! - [`url`]
//!
//! The [`gemtext`] module is used purely for the parsing of gemtext. The [`req_resp`]
//! module is used for making requests to gemini/mercury servers and parsing them. The
//! url module is used for manipulating URLs and only contains the areas of the URL specification
//! that Gemini requires.
pub mod gemtext;
pub mod req_resp;
pub mod url;

/*
#[cfg(test)]
mod tests {
    #[test]
    fn test() {
        use std::io::prelude::*;
        let mut stream = std::net::TcpStream::connect("oppen.digital:1963").unwrap();
        stream.write(b"mercury://oppen.digital/index.gmi").unwrap();
        let mut stream_data = [0;1024];
        stream.read(&mut stream_data).unwrap();
        let resp = crate::req_resp::Response::parse_string(&stream_data).unwrap();

        panic!("{}", String::from_utf8_lossy(&resp.data).into_owned());
    }
}
*/
