# gmi
`gmi` (pronounced as "Jee Mee" or however you'd like) is a simple to use, lightweight Rust library for interfacing with the [Gemini protocol](https://gemini.circumlunar.space/) as a client. It was created out of frustration with exsisting libraries bringing in multiple other dependencies that I personally saw as unnecessary. It is NOT meant to be used as a library to run as a server.

![GitLab CI Pipeline Status](https://img.shields.io/gitlab/pipeline/NateDogg1232/gmi)
![Crate status](https://img.shields.io/crates/v/gmi.svg)
![Docs Status](https://docs.rs/gmi/badge.svg)
![GPL Licensed](https://shields.io/crates/l/gmi)
![Mastodon Social](https://img.shields.io/mastodon/follow/106768879747013942?domain=https%3A%2F%2Ffosstodon.org)

This library is split into three main parts:
- `gemtext`: A [Gemtext](https://gemini.circumlunar.space/docs/gemtext.gmi) parser
- `req_resp`: A way to actually make the requests and parse the responses given by the Gemini protocol
- `url`: A simple implementation of a subset of the [URL RFC](https://datatracker.ietf.org/doc/html/rfc3986) implementing only what is needed by Gemini.


## Focuses
- Lightweight
- Small external dependencies
- Simple interface

## Features:
- [x] Gemini TLS support
- [x] Gemini Response parsing
- [x] Gemtext parsing
- [ ] Client certificates
- [ ] Trust On First Use (TOFU)
- [x] [Mercury](https://portal.mozz.us/gemini/gemini.circumlunar.space/users/solderpunk/gemlog/the-mercury-protocol.gmi) support

## Simple Example:
```rust
use gmi::url::Url;
use gmi::req_resp;
fn main() {
    let url = Url::from_str("gemini://gemini.circumlunar.space").unwrap();
    let resp = req_resp::make_request(&url, None).unwrap();
    println!("{}", string::from_utf8_lossy(&resp.data));
}
```

## Alternatives
[`gemini`](https://crates.io/crates/gemini/) is a bit of a heavier, but more feature complete library for interfacing with the Gemini protocol. It can be used for both a server and a client, unlike `gmi` which can only be used as a client (for now (; )
