use std::io::prelude::*;
fn main() {
    let mut current_url = gmi::url::Url::from_str("gemini://drewdevault.com/").unwrap();
    loop {
        println!("Current URL: {}", current_url);
        let response = gmi::req_resp::make_request(&current_url, None).unwrap();
        match response.status {
            gmi::req_resp::StatusCode::Success(_) => (),
            _ => panic!("{:?}", response),
        }
        // Get the mimetype of the response
        let mimetype = response.meta;
        println!("MIME type: {}", mimetype);
        if mimetype != "text/gemini" && mimetype != "text/mercury" {
            eprintln!("Invalid MIME type: {}", mimetype);
            break;
        }
        let response_text = String::from_utf8_lossy(&response.data).to_owned();
        let parsed_response_text = gmi::gemtext::parse_gemtext(&response_text.to_owned());
        let mut links = Vec::new();
        for node in parsed_response_text {
            match node {
                gmi::gemtext::GemtextNode::Link(s, d) => {
                    links.push(gmi::gemtext::GemtextNode::Link(s.clone(), d.clone()));
                    println!("[{}] {}", links.len(), d.unwrap_or(s));
                }
                n => println!("{}", n),
            }
        }
        // Get link input number
        let link_no;
        loop {
            print!("Link no: ");
            let _ = std::io::stdout().flush();
            let mut input = String::new();
            std::io::stdin()
                .read_line(&mut input)
                .expect("Error reading line");
            let input = input.trim();
            match input.parse::<usize>() {
                Ok(i) => {
                    link_no = i;
                    break;
                }
                e => println!("Invalid link, {:?}", e),
            }
        }
        // Follow the link
        // Check if the link is an entire full URL
        if let gmi::gemtext::GemtextNode::Link(link, _) = &links[link_no - 1] {
            println!("Following link {}", link);
            // Check if the link is a full URL or just a path.
            // The way we'll do this is not bulletproof but should work:
            // We'll check for a scheme in the URL. If there is no scheme,
            // we'll count it as relative.
            if link.contains("://") {
                // Absolute URL
                current_url = match gmi::url::Url::from_str(link) {
                    Ok(u) => u,
                    Err(e) => {
                        panic!("Error parsing the URL: {:?}", e)
                    }
                };
            } else {
                // Relative URL. Let's see if there is a path
                if current_url.path.is_some() {
                    current_url.path = Some(
                        current_url
                            .path
                            .as_ref()
                            .unwrap()
                            .merge_path(&gmi::url::Path::from(link.as_ref())),
                    );
                    current_url.path.as_mut().unwrap().dedotify();
                } else {
                    current_url.path = Some(gmi::url::Path::from(link.as_ref()));
                }
            }
        }
    }
}
