#![deny(clippy::all, clippy::pedantic, clippy::nursery, clippy::cargo)]
#![allow(clippy::missing_errors_doc, clippy::missing_panics_doc)]
#![allow(clippy::multiple_crate_versions)]

use structopt::StructOpt;

mod logging;
mod metrics;

/// Gloom CLI
#[derive(StructOpt, Debug)]
#[structopt(name = "gloom")]
struct Opt {}

#[tokio::main]
pub async fn main() -> std::io::Result<()> {
    logging::setup();
    metrics::setup();

    Opt::from_args();

    Ok(())
}
