use crate::{gl_fn_types::*, gl_types::*};
use core::ffi::c_void;
use zstring::{zstr, ZStr};

#[allow(non_snake_case)]
pub struct GlFns {
  not_send_sync: core::marker::PhantomData<*const ()>,
  glActiveTexture_p: glActiveTexture_t,
  glAttachShader_p: glAttachShader_t,
  glBindBuffer_p: glBindBuffer_t,
  glBindBufferBase_p: glBindBufferBase_t,
  glBindBufferRange_p: glBindBufferRange_t,
  glBindFramebuffer_p: glBindFramebuffer_t,
  glBindRenderbuffer_p: glBindRenderbuffer_t,
  glBindTexture_p: glBindTexture_t,
  glBindVertexArray_p: glBindVertexArray_t,
  glBlendEquation_p: glBlendEquation_t,
  glBlendFunc_p: glBlendFunc_t,
  glBlendFunci_p: glBlendFunci_t,
  glBlitFramebuffer_p: glBlitFramebuffer_t,
  glBufferData_p: glBufferData_t,
  glBufferSubData_p: glBufferSubData_t,
  glCheckFramebufferStatus_p: glCheckFramebufferStatus_t,
  glClear_p: glClear_t,
  glClearBufferfv_p: glClearBufferfv_t,
  glClearColor_p: glClearColor_t,
  glClearDepth_p: glClearDepth_t,
  glClearStencil_p: glClearStencil_t,
  glCompileShader_p: glCompileShader_t,
  glCreateProgram_p: glCreateProgram_t,
  glCreateShader_p: glCreateShader_t,
  glCullFace_p: glCullFace_t,
  glDebugMessageCallback_p: glDebugMessageCallback_t,
  glDebugMessageControl_p: glDebugMessageControl_t,
  glDebugMessageInsert_p: glDebugMessageInsert_t,
  glDeleteBuffers_p: glDeleteBuffers_t,
  glDeleteFramebuffers_p: glDeleteFramebuffers_t,
  glDeleteProgram_p: glDeleteProgram_t,
  glDeleteShader_p: glDeleteShader_t,
  glDeleteTextures_p: glDeleteTextures_t,
  glDeleteVertexArrays_p: glDeleteVertexArrays_t,
  glDepthFunc_p: glDepthFunc_t,
  glDepthMask_p: glDepthMask_t,
  glDisable_p: glDisable_t,
  glDisableVertexAttribArray_p: glDisableVertexAttribArray_t,
  glDrawArrays_p: glDrawArrays_t,
  glDrawArraysInstanced_p: glDrawArraysInstanced_t,
  glDrawBuffer_p: glDrawBuffer_t,
  glDrawBuffers_p: glDrawBuffers_t,
  glDrawElements_p: glDrawElements_t,
  glDrawElementsInstanced_p: glDrawElementsInstanced_t,
  glEnable_p: glEnable_t,
  glEnableVertexAttribArray_p: glEnableVertexAttribArray_t,
  glFramebufferRenderbuffer_p: glFramebufferRenderbuffer_t,
  glFramebufferTexture_p: glFramebufferTexture_t,
  glFramebufferTexture2D_p: glFramebufferTexture2D_t,
  glFrontFace_p: glFrontFace_t,
  glGenBuffers_p: glGenBuffers_t,
  glGenFramebuffers_p: glGenFramebuffers_t,
  glGenRenderbuffers_p: glGenRenderbuffers_t,
  glGenTextures_p: glGenTextures_t,
  glGenVertexArrays_p: glGenVertexArrays_t,
  glGenerateMipmap_p: glGenerateMipmap_t,
  glGetError_p: glGetError_t,
  glGetFloatv_p: glGetFloatv_t,
  glGetIntegerv_p: glGetIntegerv_t,
  glGetProgramInfoLog_p: glGetProgramInfoLog_t,
  glGetProgramiv_p: glGetProgramiv_t,
  glGetShaderInfoLog_p: glGetShaderInfoLog_t,
  glGetShaderiv_p: glGetShaderiv_t,
  glGetString_p: glGetString_t,
  glGetStringi_p: glGetStringi_t,
  glGetUniformBlockIndex_p: glGetUniformBlockIndex_t,
  glGetUniformLocation_p: glGetUniformLocation_t,
  glLinkProgram_p: glLinkProgram_t,
  glPixelStorei_p: glPixelStorei_t,
  glPolygonMode_p: glPolygonMode_t,
  glReadBuffer_p: glReadBuffer_t,
  glRenderbufferStorage_p: glRenderbufferStorage_t,
  glRenderbufferStorageMultisample_p: glRenderbufferStorageMultisample_t,
  glShaderSource_p: glShaderSource_t,
  glStencilFunc_p: glStencilFunc_t,
  glStencilMask_p: glStencilMask_t,
  glStencilOp_p: glStencilOp_t,
  glTexImage2D_p: glTexImage2D_t,
  glTexImage2DMultisample_p: glTexImage2DMultisample_t,
  glTexImage3D_p: glTexImage3D_t,
  glTexParameterfv_p: glTexParameterfv_t,
  glTexParameteri_p: glTexParameteri_t,
  glUniform1f_p: glUniform1f_t,
  glUniform1fv_p: glUniform1fv_t,
  glUniform1i_p: glUniform1i_t,
  glUniform1iv_p: glUniform1iv_t,
  glUniform2f_p: glUniform2f_t,
  glUniform2fv_p: glUniform2fv_t,
  glUniform3f_p: glUniform3f_t,
  glUniform3fv_p: glUniform3fv_t,
  glUniform4f_p: glUniform4f_t,
  glUniform4fv_p: glUniform4fv_t,
  glUniformBlockBinding_p: glUniformBlockBinding_t,
  glUniformMatrix2fv_p: glUniformMatrix2fv_t,
  glUniformMatrix3fv_p: glUniformMatrix3fv_t,
  glUniformMatrix4fv_p: glUniformMatrix4fv_t,
  glUseProgram_p: glUseProgram_t,
  glVertexAttribDivisor_p: glVertexAttribDivisor_t,
  glVertexAttribIPointer_p: glVertexAttribIPointer_t,
  glVertexAttribPointer_p: glVertexAttribPointer_t,
  glViewport_p: glViewport_t,
}
impl GlFns {
  #[must_use]
  #[inline(never)]
  #[rustfmt::skip]
  pub unsafe fn from_loader(load: &dyn Fn(ZStr<'_>) -> *mut c_void) -> Option<Self> {
    /// filters away known-bad pointer return values while converting to the fn type
    unsafe fn filter<T>(p: *mut c_void) -> Option<T> {
      match p as usize {
        0 | 1 | 2 | 3 | usize::MAX => None,
        _ => Some(core::mem::transmute_copy::<*mut c_void, T>(&p)),
      }
    }
    Some(Self {
      not_send_sync: core::marker::PhantomData,
      glActiveTexture_p: filter( load(zstr!("glActiveTexture")) )?,
      glAttachShader_p: filter( load(zstr!("glAttachShader")) )?,
      glBindBuffer_p: filter( load(zstr!("glBindBuffer")) )?,
      glBindBufferBase_p: filter( load(zstr!("glBindBufferBase")) )?,
      glBindBufferRange_p: filter( load(zstr!("glBindBufferRange")) )?,
      glBindFramebuffer_p: filter( load(zstr!("glBindFramebuffer")) )?,
      glBindRenderbuffer_p: filter( load(zstr!("glBindRenderbuffer")) )?,
      glBindTexture_p: filter( load(zstr!("glBindTexture")) )?,
      glBindVertexArray_p: filter( load(zstr!("glBindVertexArray")) )?,
      glBlendEquation_p: filter( load(zstr!("glBlendEquation")) )?,
      glBlendFunc_p: filter( load(zstr!("glBlendFunc")) )?,
      glBlendFunci_p: filter( load(zstr!("glBlendFunci")) )?,
      glBlitFramebuffer_p: filter( load(zstr!("glBlitFramebuffer")) )?,
      glBufferData_p: filter( load(zstr!("glBufferData")) )?,
      glBufferSubData_p: filter( load(zstr!("glBufferSubData")) )?,
      glCheckFramebufferStatus_p: filter( load(zstr!("glCheckFramebufferStatus")) )?,
      glClear_p: filter( load(zstr!("glClear")) )?,
      glClearBufferfv_p: filter( load(zstr!("glClearBufferfv")) )?,
      glClearColor_p: filter( load(zstr!("glClearColor")) )?,
      glClearDepth_p: filter( load(zstr!("glClearDepth")) )?,
      glClearStencil_p: filter( load(zstr!("glClearStencil")) )?,
      glCompileShader_p: filter( load(zstr!("glCompileShader")) )?,
      glCreateProgram_p: filter( load(zstr!("glCreateProgram")) )?,
      glCreateShader_p: filter( load(zstr!("glCreateShader")) )?,
      glCullFace_p: filter( load(zstr!("glCullFace")) )?,
      glDebugMessageCallback_p: core::mem::transmute(load(zstr!("glDebugMessageCallback"))), // ferris plz
      glDebugMessageControl_p: core::mem::transmute(load(zstr!("glDebugMessageControl"))), // ferris plz
      glDebugMessageInsert_p: core::mem::transmute(load(zstr!("glDebugMessageInsert"))), // ferris plz
      glDeleteBuffers_p: filter( load(zstr!("glDeleteBuffers")) )?,
      glDeleteFramebuffers_p: filter( load(zstr!("glDeleteFramebuffers")) )?,
      glDeleteProgram_p: filter( load(zstr!("glDeleteProgram")) )?,
      glDeleteShader_p: filter( load(zstr!("glDeleteShader")) )?,
      glDeleteTextures_p: filter( load(zstr!("glDeleteTextures")) )?,
      glDeleteVertexArrays_p: filter( load(zstr!("glDeleteVertexArrays")) )?,
      glDepthFunc_p: filter( load(zstr!("glDepthFunc")) )?,
      glDepthMask_p: filter( load(zstr!("glDepthMask")) )?,
      glDisable_p: filter( load(zstr!("glDisable")) )?,
      glDisableVertexAttribArray_p: filter( load(zstr!("glDisableVertexAttribArray")) )?,
      glDrawArrays_p: filter( load(zstr!("glDrawArrays")) )?,
      glDrawArraysInstanced_p: filter( load(zstr!("glDrawArraysInstanced")) )?,
      glDrawBuffer_p: filter( load(zstr!("glDrawBuffer")) )?,
      glDrawBuffers_p: filter( load(zstr!("glDrawBuffers")) )?,
      glDrawElements_p: filter( load(zstr!("glDrawElements")) )?,
      glDrawElementsInstanced_p: filter( load(zstr!("glDrawElementsInstanced")) )?,
      glEnable_p: filter( load(zstr!("glEnable")) )?,
      glEnableVertexAttribArray_p: filter( load(zstr!("glEnableVertexAttribArray")) )?,
      glFramebufferRenderbuffer_p: filter( load(zstr!("glFramebufferRenderbuffer")) )?,
      glFramebufferTexture_p: filter( load(zstr!("glFramebufferTexture")) )?,
      glFramebufferTexture2D_p: filter( load(zstr!("glFramebufferTexture2D")) )?,
      glFrontFace_p: filter( load(zstr!("glFrontFace")) )?,
      glGenBuffers_p: filter( load(zstr!("glGenBuffers")) )?,
      glGenFramebuffers_p: filter( load(zstr!("glGenFramebuffers")) )?,
      glGenRenderbuffers_p: filter( load(zstr!("glGenRenderbuffers")) )?,
      glGenTextures_p: filter( load(zstr!("glGenTextures")) )?,
      glGenVertexArrays_p: filter( load(zstr!("glGenVertexArrays")) )?,
      glGenerateMipmap_p: filter( load(zstr!("glGenerateMipmap")) )?,
      glGetError_p: filter( load(zstr!("glGetError")) )?,
      glGetFloatv_p: filter( load(zstr!("glGetFloatv")) )?,
      glGetIntegerv_p: filter( load(zstr!("glGetIntegerv")) )?,
      glGetProgramInfoLog_p: filter( load(zstr!("glGetProgramInfoLog")) )?,
      glGetProgramiv_p: filter( load(zstr!("glGetProgramiv")) )?,
      glGetShaderInfoLog_p: filter( load(zstr!("glGetShaderInfoLog")) )?,
      glGetShaderiv_p: filter( load(zstr!("glGetShaderiv")) )?,
      glGetString_p: filter( load(zstr!("glGetString")) )?,
      glGetStringi_p: filter( load(zstr!("glGetStringi")) )?,
      glGetUniformBlockIndex_p: filter( load(zstr!("glGetUniformBlockIndex")) )?,
      glGetUniformLocation_p: filter( load(zstr!("glGetUniformLocation")) )?,
      glLinkProgram_p: filter( load(zstr!("glLinkProgram")) )?,
      glPixelStorei_p: filter( load(zstr!("glPixelStorei")) )?,
      glPolygonMode_p: filter( load(zstr!("glPolygonMode")) )?,
      glReadBuffer_p: filter( load(zstr!("glReadBuffer")) )?,
      glRenderbufferStorage_p: filter( load(zstr!("glRenderbufferStorage")) )?,
      glRenderbufferStorageMultisample_p: filter( load(zstr!("glRenderbufferStorageMultisample")) )?,
      glShaderSource_p: filter( load(zstr!("glShaderSource")) )?,
      glStencilFunc_p: filter( load(zstr!("glStencilFunc")) )?,
      glStencilMask_p: filter( load(zstr!("glStencilMask")) )?,
      glStencilOp_p: filter( load(zstr!("glStencilOp")) )?,
      glTexImage2D_p: filter( load(zstr!("glTexImage2D")) )?,
      glTexImage2DMultisample_p: filter( load(zstr!("glTexImage2DMultisample")) )?,
      glTexImage3D_p: filter( load(zstr!("glTexImage3D")) )?,
      glTexParameterfv_p: filter( load(zstr!("glTexParameterfv")) )?,
      glTexParameteri_p: filter( load(zstr!("glTexParameteri")) )?,
      glUniform1f_p: filter( load(zstr!("glUniform1f")) )?,
      glUniform1fv_p: filter( load(zstr!("glUniform1fv")) )?,
      glUniform1i_p: filter( load(zstr!("glUniform1i")) )?,
      glUniform1iv_p: filter( load(zstr!("glUniform1iv")) )?,
      glUniform2f_p: filter( load(zstr!("glUniform2f")) )?,
      glUniform2fv_p: filter( load(zstr!("glUniform2fv")) )?,
      glUniform3f_p: filter( load(zstr!("glUniform3f")) )?,
      glUniform3fv_p: filter( load(zstr!("glUniform3fv")) )?,
      glUniform4f_p: filter( load(zstr!("glUniform4f")) )?,
      glUniform4fv_p: filter( load(zstr!("glUniform4fv")) )?,
      glUniformBlockBinding_p: filter( load(zstr!("glUniformBlockBinding")) )?,
      glUniformMatrix2fv_p: filter( load(zstr!("glUniformMatrix2fv")) )?,
      glUniformMatrix3fv_p: filter( load(zstr!("glUniformMatrix3fv")) )?,
      glUniformMatrix4fv_p: filter( load(zstr!("glUniformMatrix4fv")) )?,
      glUseProgram_p: filter( load(zstr!("glUseProgram")) )?,
      glVertexAttribDivisor_p: filter( load(zstr!("glVertexAttribDivisor")) )?,
      glVertexAttribIPointer_p: filter( load(zstr!("glVertexAttribIPointer")) )?,
      glVertexAttribPointer_p: filter( load(zstr!("glVertexAttribPointer")) )?,
      glViewport_p: filter( load(zstr!("glViewport")) )?,
    })
  }
}
#[allow(non_snake_case)]
impl GlFns {
  /// [glActiveTexture](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glActiveTexture.xhtml)
  #[inline]
  pub fn ActiveTexture(&self, texture: GLenum)  {
    (self.glActiveTexture_p)(texture)
  }
  /// [glAttachShader](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glAttachShader.xhtml)
  #[inline]
  pub fn AttachShader(&self, program: GLuint, shader: GLuint)  {
    (self.glAttachShader_p)(program, shader)
  }
  /// [glBindBuffer](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindBuffer.xhtml)
  #[inline]
  pub fn BindBuffer(&self, target: GLenum, buffer: GLuint)  {
    (self.glBindBuffer_p)(target, buffer)
  }
  /// [glBindBufferBase](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindBufferBase.xhtml)
  #[inline]
  pub unsafe fn BindBufferBase(&self, target: GLenum, index: GLuint, buffer: GLuint)  {
    (self.glBindBufferBase_p)(target, index, buffer)
  }
  /// [glBindBufferRange](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindBufferRange.xhtml)
  #[inline]
  pub unsafe fn BindBufferRange(&self, target: GLenum, index: GLuint, buffer: GLuint, offset: GLintptr, size: GLsizeiptr)  {
    (self.glBindBufferRange_p)(target, index, buffer, offset, size)
  }
  /// [glBindFramebuffer](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindFramebuffer.xhtml)
  #[inline]
  pub unsafe fn BindFramebuffer(&self, target: GLenum, framebuffer: GLuint)  {
    (self.glBindFramebuffer_p)(target, framebuffer)
  }
  /// [glBindRenderbuffer](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindRenderbuffer.xhtml)
  #[inline]
  pub fn BindRenderbuffer(&self, target: GLenum, renderbuffer: GLuint)  {
    (self.glBindRenderbuffer_p)(target, renderbuffer)
  }
  /// [glBindTexture](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindTexture.xhtml)
  #[inline]
  pub fn BindTexture(&self, target: GLenum, texture: GLuint)  {
    (self.glBindTexture_p)(target, texture)
  }
  /// [glBindVertexArray](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindVertexArray.xhtml)
  #[inline]
  pub fn BindVertexArray(&self, array: GLuint)  {
    (self.glBindVertexArray_p)(array)
  }
  /// [glBlendEquation](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBlendEquation.xhtml)
  #[inline]
  pub fn BlendEquation(&self, mode: GLenum)  {
    (self.glBlendEquation_p)(mode)
  }
  /// [glBlendFunc](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBlendFunc.xhtml)
  #[inline]
  pub fn BlendFunc(&self, sfactor: GLenum, dfactor: GLenum)  {
    (self.glBlendFunc_p)(sfactor, dfactor)
  }
  /// [glBlendFunci](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBlendFunc.xhtml)
  #[inline]
  pub fn BlendFunci(&self, buf: GLuint, sfactor: GLenum, dfactor: GLenum)  {
    (self.glBlendFunci_p)(buf, sfactor, dfactor)
  }
  /// [glBlitFramebuffer](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBlitFramebuffer.xhtml)
  #[inline]
  pub unsafe fn BlitFramebuffer(&self, srcX0: GLint, srcY0: GLint, srcX1: GLint, srcY1: GLint, dstX0: GLint, dstY0: GLint, dstX1: GLint, dstY1: GLint, mask: GLbitfield, filter: GLenum)  {
    (self.glBlitFramebuffer_p)(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter)
  }
  /// [glBufferData](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBufferData.xhtml)
  #[inline]
  pub unsafe fn BufferData(&self, target: GLenum, size: GLsizeiptr, data: *const void, usage: GLenum)  {
    (self.glBufferData_p)(target, size, data, usage)
  }
  /// [glBufferSubData](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBufferSubData.xhtml)
  #[inline]
  pub unsafe fn BufferSubData(&self, target: GLenum, offset: GLintptr, size: GLsizeiptr, data: *const void)  {
    (self.glBufferSubData_p)(target, offset, size, data)
  }
  /// [glCheckFramebufferStatus](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCheckFramebufferStatus.xhtml)
  #[inline]
  pub fn CheckFramebufferStatus(&self, target: GLenum) -> GLenum {
    (self.glCheckFramebufferStatus_p)(target)
  }
  /// [glClear](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClear.xhtml) (GL 1.0, GLES 2.0)
  ///
  /// This sets the bitplane area of the window to values previously selected by
  /// [ClearColor](Self::ClearColor), [ClearDepth](Self::ClearDepth), and
  /// [ClearStencil](Self::ClearStencil).
  ///
  /// * `mask` can contain any of the following bits:
  ///   * `GL_COLOR_BUFFER_BIT`
  ///   * `GL_DEPTH_BUFFER_BIT`
  ///   * `GL_STENCIL_BUFFER_BIT`
  ///
  /// Multiple color buffers can be cleared simultaneously by selecting more than
  /// one buffer at a time using [DrawBuffer](Self::DrawBuffer).
  ///
  /// The pixel ownership test, the scissor test, dithering, and the buffer
  /// writemasks affect the operation of `Clear`. The scissor box bounds the
  /// cleared region. Alpha function, blend function, logical operation,
  /// stenciling, texture mapping, and depth-buffering are ignored by `Clear`.
  ///
  /// ## Errors
  /// * `GL_INVALID_VALUE` is generated if any bit other than the three defined
  ///   bits is set in `mask`.
  #[inline]
  pub fn Clear(&self, mask: GLbitfield)  {
    (self.glClear_p)(mask)
  }
  /// [glClearBufferfv](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClearBuffer.xhtml)
  #[inline]
  pub unsafe fn ClearBufferfv(&self, buffer: GLenum, drawbuffer: GLint, value: *const GLfloat)  {
    (self.glClearBufferfv_p)(buffer, drawbuffer, value)
  }
  /// [glClearColor](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClearColor.xhtml) (GL 1.0, GLES 2.0)
  ///
  /// Specifies the `red`, `green`, `blue`, and `alpha` values used by
  /// [Clear](Self::Clear) when clearing the color buffers.
  ///
  /// All inputs are silently clamped to `0.0 ..= 1.0`
  ///
  /// ## Associated Gets
  /// * `GL_COLOR_CLEAR_VALUE`
  #[inline]
  pub fn ClearColor(&self, red: GLfloat, green: GLfloat, blue: GLfloat, alpha: GLfloat)  {
    (self.glClearColor_p)(red, green, blue, alpha)
  }
  /// [glClearDepth](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClearDepth.xhtml) (GL 1.0, GLES -)
  ///
  /// Specifies the depth value used when the depth buffer is cleared. The initial
  /// value is 1.0
  ///
  /// ## Associated Gets
  /// * `GL_DEPTH_CLEAR_VALUE`
  #[inline]
  pub fn ClearDepth(&self, depth: GLdouble)  {
    (self.glClearDepth_p)(depth)
  }
  /// [glClearStencil](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClearStencil.xhtml) (GL 1.0, GLES 2.0)
  ///
  /// Specifies the index used when the stencil buffer is cleared. The initial
  /// value is 0.
  ///
  /// The input is masked with `2**m - 1`, where `m` is the number of bits in the
  /// stencil buffer.
  ///
  /// ## Associated Gets
  /// * `GL_STENCIL_CLEAR_VALUE`
  /// * `GL_STENCIL_BITS`
  #[inline]
  pub fn ClearStencil(&self, s: GLint)  {
    (self.glClearStencil_p)(s)
  }
  /// [glCompileShader](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCompileShader.xhtml)
  #[inline]
  pub fn CompileShader(&self, shader: GLuint)  {
    (self.glCompileShader_p)(shader)
  }
  /// [glCreateProgram](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateProgram.xhtml)
  #[inline]
  pub fn CreateProgram(&self, ) -> GLuint {
    (self.glCreateProgram_p)()
  }
  /// [glCreateShader](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateShader.xhtml)
  #[inline]
  pub fn CreateShader(&self, shaderType: GLenum) -> GLuint {
    (self.glCreateShader_p)(shaderType)
  }
  /// [glCullFace](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCullFace.xhtml)
  #[inline]
  pub fn CullFace(&self, mode: GLenum)  {
    (self.glCullFace_p)(mode)
  }
  /// [glDebugMessageCallback](https://www.khronos.org/registry/OpenGL/extensions/KHR/KHR_debug.txt) (GL_KHR_debug, GL 4.3, GLES 3.2)
  ///
  /// Called by the GL driver to notify the program of various events.
  #[inline]
  pub unsafe fn DebugMessageCallback(&self, callback: Option<GLDEBUGPROC>, userParam: *const void)  {
    if let Some(f) = self.glDebugMessageCallback_p { f(callback, userParam) }
  }
  /// [glDebugMessageControl](https://www.khronos.org/registry/OpenGL/extensions/KHR/KHR_debug.txt) (GL_KHR_debug, GL 4.3, GLES 3.2)
  ///
  /// Allows the program to set filters on what events will trigger the debug
  /// callback.
  #[inline]
  pub unsafe fn DebugMessageControl(&self, source: GLenum, type_: GLenum, severity: GLenum, count: GLsizei, ids: *const GLuint, enabled: GLboolean)  {
    if let Some(f) = self.glDebugMessageControl_p { f(source, type_, severity, count, ids, enabled) }
  }
  /// [glDebugMessageInsert](https://www.khronos.org/registry/OpenGL/extensions/KHR/KHR_debug.txt) (GL_KHR_debug, GL 4.3, GLES 3.2)
  ///
  /// Allows the program to send a debug event to the driver, which will then call
  /// the callback (if the event isn't filtered).
  #[inline]
  pub unsafe fn DebugMessageInsert(&self, source: GLenum, type_: GLenum, id: GLuint, severity: GLenum, length: GLint, buf: *const u8)  {
    if let Some(f) = self.glDebugMessageInsert_p { f(source, type_, id, severity, length, buf) }
  }
  /// [glDeleteBuffers](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteBuffers.xhtml)
  #[inline]
  pub unsafe fn DeleteBuffers(&self, n: GLsizei, buffers: *const GLuint)  {
    (self.glDeleteBuffers_p)(n, buffers)
  }
  /// [glDeleteFramebuffers](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteFramebuffers.xhtml)
  #[inline]
  pub unsafe fn DeleteFramebuffers(&self, n: GLsizei, framebuffers: *mut GLuint)  {
    (self.glDeleteFramebuffers_p)(n, framebuffers)
  }
  /// [glDeleteProgram](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteProgram.xhtml)
  #[inline]
  pub fn DeleteProgram(&self, program: GLuint)  {
    (self.glDeleteProgram_p)(program)
  }
  /// [glDeleteShader](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteShader.xhtml)
  #[inline]
  pub fn DeleteShader(&self, shader: GLuint)  {
    (self.glDeleteShader_p)(shader)
  }
  /// [glDeleteTextures](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteTextures.xhtml)
  #[inline]
  pub unsafe fn DeleteTextures(&self, n: GLsizei, textures: *const GLuint)  {
    (self.glDeleteTextures_p)(n, textures)
  }
  /// [glDeleteVertexArrays](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteVertexArrays.xhtml)
  #[inline]
  pub unsafe fn DeleteVertexArrays(&self, n: GLsizei, arrays: *const GLuint)  {
    (self.glDeleteVertexArrays_p)(n, arrays)
  }
  /// [glDepthFunc](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDepthFunc.xhtml)
  #[inline]
  pub fn DepthFunc(&self, func: GLenum)  {
    (self.glDepthFunc_p)(func)
  }
  /// [glDepthMask](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDepthMask.xhtml)
  #[inline]
  pub fn DepthMask(&self, flag: GLboolean)  {
    (self.glDepthMask_p)(flag)
  }
  /// [glDisable](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDisable.xhtml)
  #[inline]
  pub fn Disable(&self, cap: GLenum)  {
    (self.glDisable_p)(cap)
  }
  /// [glDisableVertexAttribArray](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glEnableVertexAttribArray.xhtml)
  #[inline]
  pub fn DisableVertexAttribArray(&self, index: GLuint)  {
    (self.glDisableVertexAttribArray_p)(index)
  }
  /// [glDrawArrays](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawArrays.xhtml)
  #[inline]
  pub unsafe fn DrawArrays(&self, mode: GLenum, first: GLint, count: GLsizei)  {
    (self.glDrawArrays_p)(mode, first, count)
  }
  /// [glDrawArraysInstanced](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawArraysInstanced.xhtml)
  #[inline]
  pub unsafe fn DrawArraysInstanced(&self, mode: GLenum, first: GLint, count: GLsizei, instancecount: GLsizei)  {
    (self.glDrawArraysInstanced_p)(mode, first, count, instancecount)
  }
  /// [glDrawBuffer](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawBuffer.xhtml)
  #[inline]
  pub fn DrawBuffer(&self, buf: GLenum)  {
    (self.glDrawBuffer_p)(buf)
  }
  /// [glDrawBuffers](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawBuffers.xhtml)
  #[inline]
  pub unsafe fn DrawBuffers(&self, n: GLsizei, bufs: *const GLenum)  {
    (self.glDrawBuffers_p)(n, bufs)
  }
  /// [glDrawElements](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawElements.xhtml)
  #[inline]
  pub unsafe fn DrawElements(&self, mode: GLenum, count: GLsizei, type_: GLenum, indices: *const void)  {
    (self.glDrawElements_p)(mode, count, type_, indices)
  }
  /// [glDrawElementsInstanced](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawElementsInstanced.xhtml)
  #[inline]
  pub unsafe fn DrawElementsInstanced(&self, mode: GLenum, count: GLsizei, type_: GLenum, indices: *const void, instancecount: GLsizei)  {
    (self.glDrawElementsInstanced_p)(mode, count, type_, indices, instancecount)
  }
  /// [glEnable](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glEnable.xhtml)
  #[inline]
  pub fn Enable(&self, cap: GLenum)  {
    (self.glEnable_p)(cap)
  }
  /// [glEnableVertexAttribArray](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glEnableVertexAttribArray.xhtml)
  #[inline]
  pub fn EnableVertexAttribArray(&self, index: GLuint)  {
    (self.glEnableVertexAttribArray_p)(index)
  }
  /// [glFramebufferRenderbuffer](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glFramebufferRenderbuffer.xhtml)
  #[inline]
  pub fn FramebufferRenderbuffer(&self, target: GLenum, attachment: GLenum, renderbuffertarget: GLenum, renderbuffer: GLuint)  {
    (self.glFramebufferRenderbuffer_p)(target, attachment, renderbuffertarget, renderbuffer)
  }
  /// [glFramebufferTexture](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glFramebufferTexture.xhtml)
  #[inline]
  pub fn FramebufferTexture(&self, target: GLenum, attachment: GLenum, texture: GLuint, level: GLint)  {
    (self.glFramebufferTexture_p)(target, attachment, texture, level)
  }
  /// [glFramebufferTexture2D](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glFramebufferTexture.xhtml)
  #[inline]
  pub fn FramebufferTexture2D(&self, target: GLenum, attachment: GLenum, textarget: GLenum, texture: GLuint, level: GLint)  {
    (self.glFramebufferTexture2D_p)(target, attachment, textarget, texture, level)
  }
  /// [glFrontFace](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glFrontFace.xhtml)
  #[inline]
  pub fn FrontFace(&self, mode: GLenum)  {
    (self.glFrontFace_p)(mode)
  }
  /// [glGenBuffers](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenBuffers.xhtml)
  #[inline]
  pub unsafe fn GenBuffers(&self, n: GLsizei, buffers: *mut GLuint)  {
    (self.glGenBuffers_p)(n, buffers)
  }
  /// [glGenFramebuffers](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenFramebuffers.xhtml)
  #[inline]
  pub unsafe fn GenFramebuffers(&self, n: GLsizei, ids: *mut GLuint)  {
    (self.glGenFramebuffers_p)(n, ids)
  }
  /// [glGenRenderbuffers](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenRenderbuffers.xhtml)
  #[inline]
  pub unsafe fn GenRenderbuffers(&self, n: GLsizei, renderbuffers: *mut GLuint)  {
    (self.glGenRenderbuffers_p)(n, renderbuffers)
  }
  /// [glGenTextures](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenTextures.xhtml)
  #[inline]
  pub unsafe fn GenTextures(&self, n: GLsizei, textures: *mut GLuint)  {
    (self.glGenTextures_p)(n, textures)
  }
  /// [glGenVertexArrays](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenVertexArrays.xhtml)
  #[inline]
  pub unsafe fn GenVertexArrays(&self, n: GLsizei, arrays: *mut GLuint)  {
    (self.glGenVertexArrays_p)(n, arrays)
  }
  /// [glGenerateMipmap](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenerateMipmap.xhtml)
  #[inline]
  pub fn GenerateMipmap(&self, target: GLenum)  {
    (self.glGenerateMipmap_p)(target)
  }
  /// [glGetError](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetError.xhtml)
  #[inline]
  pub fn GetError(&self, ) -> GLenum {
    (self.glGetError_p)()
  }
  /// [glGetFloatv](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGet.xhtml)
  #[inline]
  pub unsafe fn GetFloatv(&self, pname: GLenum, data: *mut GLfloat)  {
    (self.glGetFloatv_p)(pname, data)
  }
  /// [glGetIntegerv](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGet.xhtml)
  #[inline]
  pub unsafe fn GetIntegerv(&self, pname: GLenum, data: *mut GLint)  {
    (self.glGetIntegerv_p)(pname, data)
  }
  /// [glGetProgramInfoLog](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgramInfoLog.xhtml)
  #[inline]
  pub unsafe fn GetProgramInfoLog(&self, program: GLuint, maxLength: GLsizei, length: *mut GLsizei, infoLog: *mut GLchar)  {
    (self.glGetProgramInfoLog_p)(program, maxLength, length, infoLog)
  }
  /// [glGetProgramiv](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgram.xhtml)
  #[inline]
  pub unsafe fn GetProgramiv(&self, program: GLuint, pname: GLenum, params: *mut GLint)  {
    (self.glGetProgramiv_p)(program, pname, params)
  }
  /// [glGetShaderInfoLog](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetShaderInfoLog.xhtml)
  #[inline]
  pub unsafe fn GetShaderInfoLog(&self, shader: GLuint, maxLength: GLsizei, length: *mut GLsizei, infoLog: *mut GLchar)  {
    (self.glGetShaderInfoLog_p)(shader, maxLength, length, infoLog)
  }
  /// [glGetShaderiv](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetShader.xhtml)
  #[inline]
  pub unsafe fn GetShaderiv(&self, shader: GLuint, pname: GLenum, params: *mut GLint)  {
    (self.glGetShaderiv_p)(shader, pname, params)
  }
  /// [glGetString](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetString.xhtml)
  #[inline]
  pub fn GetString(&self, name: GLenum) -> *const GLubyte {
    (self.glGetString_p)(name)
  }
  /// [glGetStringi](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetString.xhtml)
  #[inline]
  pub fn GetStringi(&self, name: GLenum, index: GLuint) -> *const GLubyte {
    (self.glGetStringi_p)(name, index)
  }
  /// [glGetUniformBlockIndex](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetUniformBlockIndex.xhtml)
  #[inline]
  pub unsafe fn GetUniformBlockIndex(&self, program: GLuint, uniformBlockName: *const GLchar) -> GLuint {
    (self.glGetUniformBlockIndex_p)(program, uniformBlockName)
  }
  /// [glGetUniformLocation](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetUniformLocation.xhtml)
  #[inline]
  pub unsafe fn GetUniformLocation(&self, program: GLuint, name: *const GLchar) -> GLint {
    (self.glGetUniformLocation_p)(program, name)
  }
  /// [glLinkProgram](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glLinkProgram.xhtml)
  #[inline]
  pub fn LinkProgram(&self, program: GLuint)  {
    (self.glLinkProgram_p)(program)
  }
  /// [glPixelStorei](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glPixelStore.xhtml)
  #[inline]
  pub fn PixelStorei(&self, pname: GLenum, param: GLint)  {
    (self.glPixelStorei_p)(pname, param)
  }
  /// [glPolygonMode](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glPolygonMode.xhtml)
  #[inline]
  pub fn PolygonMode(&self, face: GLenum, mode: GLenum)  {
    (self.glPolygonMode_p)(face, mode)
  }
  /// [glReadBuffer](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glReadBuffer.xhtml)
  #[inline]
  pub fn ReadBuffer(&self, mode: GLenum)  {
    (self.glReadBuffer_p)(mode)
  }
  /// [glRenderbufferStorage](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glRenderbufferStorage.xhtml)
  #[inline]
  pub fn RenderbufferStorage(&self, target: GLenum, internalformat: GLenum, width: GLsizei, height: GLsizei)  {
    (self.glRenderbufferStorage_p)(target, internalformat, width, height)
  }
  /// [glRenderbufferStorageMultisample](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glRenderbufferStorageMultisample.xhtml)
  #[inline]
  pub fn RenderbufferStorageMultisample(&self, target: GLenum, samples: GLsizei, internalformat: GLenum, width: GLsizei, height: GLsizei)  {
    (self.glRenderbufferStorageMultisample_p)(target, samples, internalformat, width, height)
  }
  /// [glShaderSource](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glShaderSource.xhtml)
  #[inline]
  pub unsafe fn ShaderSource(&self, shader: GLuint, count: GLsizei, string: *const *mut GLchar, length: *const GLint)  {
    (self.glShaderSource_p)(shader, count, string, length)
  }
  /// [glStencilFunc](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glStencilFunc.xhtml)
  #[inline]
  pub fn StencilFunc(&self, func: GLenum, ref_: GLint, mask: GLuint)  {
    (self.glStencilFunc_p)(func, ref_, mask)
  }
  /// [glStencilMask](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glStencilMask.xhtml)
  #[inline]
  pub fn StencilMask(&self, mask: GLuint)  {
    (self.glStencilMask_p)(mask)
  }
  /// [glStencilOp](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glStencilOp.xhtml)
  #[inline]
  pub fn StencilOp(&self, sfail: GLenum, dpfail: GLenum, dppass: GLenum)  {
    (self.glStencilOp_p)(sfail, dpfail, dppass)
  }
  /// [glTexImage2D](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexImage2D.xhtml)
  #[inline]
  pub unsafe fn TexImage2D(&self, target: GLenum, level: GLint, internalformat: GLint, width: GLsizei, height: GLsizei, border: GLint, format: GLenum, type_: GLenum, data: *const void)  {
    (self.glTexImage2D_p)(target, level, internalformat, width, height, border, format, type_, data)
  }
  /// [glTexImage2DMultisample](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexImage2DMultisample.xhtml)
  #[inline]
  pub fn TexImage2DMultisample(&self, target: GLenum, samples: GLsizei, internalformat: GLenum, width: GLsizei, height: GLsizei, fixedsamplelocations: GLboolean)  {
    (self.glTexImage2DMultisample_p)(target, samples, internalformat, width, height, fixedsamplelocations)
  }
  /// [glTexImage3D](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexImage3D.xhtml)
  #[inline]
  pub unsafe fn TexImage3D(&self, target: GLenum, level: GLint, internalformat: GLint, width: GLsizei, height: GLsizei, depth: GLsizei, border: GLint, format: GLenum, type_: GLenum, data: *const void)  {
    (self.glTexImage3D_p)(target, level, internalformat, width, height, depth, border, format, type_, data)
  }
  /// [glTexParameterfv](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexParameter.xhtml)
  #[inline]
  pub unsafe fn TexParameterfv(&self, target: GLenum, pname: GLenum, params: *const GLfloat)  {
    (self.glTexParameterfv_p)(target, pname, params)
  }
  /// [glTexParameteri](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexParameter.xhtml)
  #[inline]
  pub fn TexParameteri(&self, target: GLenum, pname: GLenum, param: GLint)  {
    (self.glTexParameteri_p)(target, pname, param)
  }
  /// [glUniform1f](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUniform.xhtml)
  #[inline]
  pub fn Uniform1f(&self, location: GLint, v0: GLfloat)  {
    (self.glUniform1f_p)(location, v0)
  }
  /// [glUniform1fv](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUniform.xhtml)
  #[inline]
  pub unsafe fn Uniform1fv(&self, location: GLint, count: GLsizei, value: *const [GLfloat; 1])  {
    (self.glUniform1fv_p)(location, count, value)
  }
  /// [glUniform1i](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUniform.xhtml)
  #[inline]
  pub fn Uniform1i(&self, location: GLint, v0: GLint)  {
    (self.glUniform1i_p)(location, v0)
  }
  /// [glUniform1iv](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUniform.xhtml)
  #[inline]
  pub unsafe fn Uniform1iv(&self, location: GLint, count: GLsizei, value: *const GLint)  {
    (self.glUniform1iv_p)(location, count, value)
  }
  /// [glUniform2f](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUniform.xhtml)
  #[inline]
  pub fn Uniform2f(&self, location: GLint, v0: GLfloat, v1: GLfloat)  {
    (self.glUniform2f_p)(location, v0, v1)
  }
  /// [glUniform2fv](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUniform.xhtml)
  #[inline]
  pub unsafe fn Uniform2fv(&self, location: GLint, count: GLsizei, value: *const [GLfloat; 2])  {
    (self.glUniform2fv_p)(location, count, value)
  }
  /// [glUniform3f](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUniform.xhtml)
  #[inline]
  pub fn Uniform3f(&self, location: GLint, v0: GLfloat, v1: GLfloat, v2: GLfloat)  {
    (self.glUniform3f_p)(location, v0, v1, v2)
  }
  /// [glUniform3fv](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUniform.xhtml)
  #[inline]
  pub unsafe fn Uniform3fv(&self, location: GLint, count: GLsizei, value: *const [GLfloat; 3])  {
    (self.glUniform3fv_p)(location, count, value)
  }
  /// [glUniform4f](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUniform.xhtml)
  #[inline]
  pub fn Uniform4f(&self, location: GLint, v0: GLfloat, v1: GLfloat, v2: GLfloat, v3: GLfloat)  {
    (self.glUniform4f_p)(location, v0, v1, v2, v3)
  }
  /// [glUniform4fv](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUniform.xhtml)
  #[inline]
  pub unsafe fn Uniform4fv(&self, location: GLint, count: GLsizei, value: *const [GLfloat; 4])  {
    (self.glUniform4fv_p)(location, count, value)
  }
  /// [glUniformBlockBinding](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUniformBlockBinding.xhtml)
  #[inline]
  pub unsafe fn UniformBlockBinding(&self, program: GLuint, uniformBlockIndex: GLuint, uniformBlockBinding: GLuint)  {
    (self.glUniformBlockBinding_p)(program, uniformBlockIndex, uniformBlockBinding)
  }
  /// [glUniformMatrix2fv](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUniform.xhtml)
  #[inline]
  pub unsafe fn UniformMatrix2fv(&self, location: GLint, count: GLsizei, transpose: GLboolean, value: *const [GLfloat; 4])  {
    (self.glUniformMatrix2fv_p)(location, count, transpose, value)
  }
  /// [glUniformMatrix3fv](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUniform.xhtml)
  #[inline]
  pub unsafe fn UniformMatrix3fv(&self, location: GLint, count: GLsizei, transpose: GLboolean, value: *const [GLfloat; 9])  {
    (self.glUniformMatrix3fv_p)(location, count, transpose, value)
  }
  /// [glUniformMatrix4fv](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUniform.xhtml)
  #[inline]
  pub unsafe fn UniformMatrix4fv(&self, location: GLint, count: GLsizei, transpose: GLboolean, value: *const [GLfloat; 16])  {
    (self.glUniformMatrix4fv_p)(location, count, transpose, value)
  }
  /// [glUseProgram](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUseProgram.xhtml)
  #[inline]
  pub fn UseProgram(&self, program: GLuint)  {
    (self.glUseProgram_p)(program)
  }
  /// [glVertexAttribDivisor](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glVertexAttribDivisor.xhtml) (GL 3.3)
  #[inline]
  pub fn VertexAttribDivisor(&self, index: GLuint, divisor: GLuint)  {
    (self.glVertexAttribDivisor_p)(index, divisor)
  }
  /// [glVertexAttribIPointer](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glVertexAttribPointer.xhtml)
  #[inline]
  pub unsafe fn VertexAttribIPointer(&self, index: GLuint, size: GLint, type_: GLenum, stride: GLsizei, pointer: *const void)  {
    (self.glVertexAttribIPointer_p)(index, size, type_, stride, pointer)
  }
  /// [glVertexAttribPointer](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glVertexAttribPointer.xhtml)
  #[inline]
  pub unsafe fn VertexAttribPointer(&self, index: GLuint, size: GLint, type_: GLenum, normalized: GLboolean, stride: GLsizei, pointer: *const void)  {
    (self.glVertexAttribPointer_p)(index, size, type_, normalized, stride, pointer)
  }
  /// [glViewport](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glViewport.xhtml) (GL 1.0, GLES 2.0)
  ///
  /// Specifies the affine transformation of `x` and `y` from normalized device
  /// coordinates to window coordinates. The window coordinates are computed as
  /// follows:
  ///
  /// ```txt
  /// x_win = (x_ndc + 1)*(width  / 2) + x
  /// y_win = (y_ndc + 1)*(height / 2) + y
  /// ```
  ///
  /// * `x` and `y` specify the lower left corner of the viewport rectangle, in
  ///   pixels. The initial value is (0,0).
  /// * `width` and `height` specify the width and height of the viewport. When a
  ///   GL context is first attached to a window, width and height are set to the
  ///   dimensions of that window.
  ///
  /// ## Errors
  /// * `GL_INVALID_VALUE` is generated if either `width` or `height` are
  ///   negative.
  ///
  /// ## Associated Gets
  /// * `GL_VIEWPORT`
  /// * `GL_MAX_VIEWPORT_DIMS`
  #[inline]
  pub fn Viewport(&self, x: GLint, y: GLint, width: GLsizei, height: GLsizei)  {
    (self.glViewport_p)(x, y, width, height)
  }
}
