# GitPad

A lightweight git web interface with:

* **editing support** (create, edit, move and remove files)
* **Markdown rendering** (for files named `*.md`)
* a **multi-user mode** with file sharing & collaborative editing

You can install GitPad with:

```
$ cargo install gitpad
```

GitPad needs to be started from inside of a bare Git repository.
For example:

```
$ git init --bare example.git
$ cd example.git/
$ gitpad
Listening on http://127.0.0.1:8000
```

Files are served under `/~{branch}/{path}`, so for example `/~hello/world.md`
refers to the `world.md` file in the `hello` branch.  By default GitPad is in
single-user mode, letting the user view and edit all branches (as well as create
new branches).

## Multi-user mode

Multi-user mode requires you to set up a reverse-proxy that authenticates users
and sets the `Username` header. The simplest authentication mechanism is HTTP
Basic Auth.  With NGINX a reverse-proxy could be configured as follows:

```
server {
    listen 80;
    listen [::]:80;

    server_name notes.localhost;
    client_max_body_size 5M;

    location / {
        auth_basic 'Restricted';
        auth_basic_user_file /etc/nginx/gitpad_passwd;
        proxy_set_header Username $remote_user;

        proxy_pass http://localhost:8000;

        # Or if you start GitPad with --socket /srv/sockets/gitpad.sock
        # proxy_pass http://unix:/srv/sockets/gitpad.sock:/;
    }
}
```

For instructions on how to create the `auth_basic_user_file`,
refer to the [NGINX documentation](https://docs.nginx.com/nginx/admin-guide/security-controls/configuring-http-basic-authentication/).

Once you have set this up start GitPad in multi-user mode by running it with the
`-m` flag.

In multi-user mode every user has their own Git branch, named exactly like their
username. Your own branch is private by default, other users cannot access your
files.  Users can however share files/directories with other users by creating a
`.shares.txt` file.

## Configuring committer identities

In single-user mode GitPad just uses the
committer identity from your git config.

In multi-user mode GitPad defaults to `{username} <{username}@localhost.invalid>`.
Committer identities can be configured by creating a `users.toml` file in the
`gitpad` branch, with sections like the following:

```
[johndoe]
name = "John Doe"
email = "john@example.com"
```

## Contributing

Feedback, bug reports and suggestions are welcome!
