use crate::job::MockJobVariable;

pub fn default_job_variables(job_id: u64) -> Vec<MockJobVariable> {
    vec![
        MockJobVariable {
            key: "CI_PIPELINE_ID".to_owned(),
            value: "120".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_PIPELINE_URL".to_owned(),
            value: "https://gitlab.example.com/test/gitlab-test/-/pipelines/120".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_JOB_ID".to_owned(),
            value: job_id.to_string(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_JOB_URL".to_owned(),
            value: "https://gitlab.example.com/test/gitlab-test/-/jobs/265".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_JOB_TOKEN".to_owned(),
            value: "tokn".to_owned(),
            public: false,
            masked: true,
        },
        MockJobVariable {
            key: "CI_JOB_STARTED_AT".to_owned(),
            value: "2021-05-05T17:16:32Z".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_BUILD_ID".to_owned(),
            value: "265".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_BUILD_TOKEN".to_owned(),
            value: "tokn".to_owned(),
            public: false,
            masked: true,
        },
        MockJobVariable {
            key: "CI_REGISTRY_USER".to_owned(),
            value: "gitlab-ci-token".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_REGISTRY_PASSWORD".to_owned(),
            value: "token".to_owned(),
            public: false,
            masked: true,
        },
        MockJobVariable {
            key: "CI_REPOSITORY_URL".to_owned(),
            value: "https://gitlab-ci-token:token@gitlab.example.com/test/gitlab-test.git"
                .to_owned(),
            public: false,
            masked: false,
        },
        MockJobVariable {
            key: "CI_DEPENDENCY_PROXY_USER".to_owned(),
            value: "gitlab-ci-token".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_DEPENDENCY_PROXY_PASSWORD".to_owned(),
            value: "token".to_owned(),
            public: false,
            masked: true,
        },
        MockJobVariable {
            key: "CI_JOB_NAME".to_owned(),
            value: "custom".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_JOB_STAGE".to_owned(),
            value: "build".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_NODE_TOTAL".to_owned(),
            value: "1".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_BUILD_NAME".to_owned(),
            value: "custom".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_BUILD_STAGE".to_owned(),
            value: "build".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "GITLAB_CI".to_owned(),
            value: "true".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_SERVER_URL".to_owned(),
            value: "https://gitlab.example.com".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_SERVER_HOST".to_owned(),
            value: "gitlab.example.com".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_SERVER_PORT".to_owned(),
            value: "443".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_SERVER_PROTOCOL".to_owned(),
            value: "https".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_SERVER_NAME".to_owned(),
            value: "GitLab".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_SERVER_VERSION".to_owned(),
            value: "13.11.3".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_SERVER_VERSION_MAJOR".to_owned(),
            value: "13".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_SERVER_VERSION_MINOR".to_owned(),
            value: "11".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_SERVER_VERSION_PATCH".to_owned(),
            value: "3".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_SERVER_REVISION".to_owned(),
            value: "b321336e443".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "GITLAB_FEATURES".to_owned(),
            value: "".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_PROJECT_ID".to_owned(),
            value: "4".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_PROJECT_NAME".to_owned(),
            value: "gitlab-test".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_PROJECT_TITLE".to_owned(),
            value: "gitlab-test".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_PROJECT_PATH".to_owned(),
            value: "test/gitlab-test".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_PROJECT_PATH_SLUG".to_owned(),
            value: "test-gitlab-test".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_PROJECT_NAMESPACE".to_owned(),
            value: "test".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_PROJECT_ROOT_NAMESPACE".to_owned(),
            value: "test".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_PROJECT_URL".to_owned(),
            value: "https://gitlab.example.com/test/gitlab-test".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_PROJECT_VISIBILITY".to_owned(),
            value: "private".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_PROJECT_REPOSITORY_LANGUAGES".to_owned(),
            value: "dockerfile,ocaml".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_DEFAULT_BRANCH".to_owned(),
            value: "master".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_PROJECT_CONFIG_PATH".to_owned(),
            value: ".gitlab-ci.yml".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_CONFIG_PATH".to_owned(),
            value: ".gitlab-ci.yml".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_PAGES_DOMAIN".to_owned(),
            value: "example.com".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_PAGES_URL".to_owned(),
            value: "http://test.example.com/gitlab-test".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_REGISTRY".to_owned(),
            value: "registry.example.com".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_REGISTRY_IMAGE".to_owned(),
            value: "registry.example.com/test/gitlab-test".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_DEPENDENCY_PROXY_SERVER".to_owned(),
            value: "gitlab.example.com:443".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_DEPENDENCY_PROXY_GROUP_IMAGE_PREFIX".to_owned(),
            value: "gitlab.example.com:443/test/dependency_proxy/containers".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_API_V4_URL".to_owned(),
            value: "https://gitlab.example.com/api/v4".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_PIPELINE_IID".to_owned(),
            value: "33".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_PIPELINE_SOURCE".to_owned(),
            value: "push".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_PIPELINE_CREATED_AT".to_owned(),
            value: "2021-05-05T10:20:00Z".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_COMMIT_SHA".to_owned(),
            value: "265c14cf140a66cfc61e40e4ab45c95ba8df5ed1".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_COMMIT_SHORT_SHA".to_owned(),
            value: "265c14cf".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_COMMIT_BEFORE_SHA".to_owned(),
            value: "fc40ad32cdd36b814f07a540605110edc209a38c".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_COMMIT_REF_NAME".to_owned(),
            value: "custom".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_COMMIT_REF_SLUG".to_owned(),
            value: "custom".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_COMMIT_BRANCH".to_owned(),
            value: "custom".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_COMMIT_MESSAGE".to_owned(),
            value: "test rust runner\n".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_COMMIT_TITLE".to_owned(),
            value: "test rust runner".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_COMMIT_DESCRIPTION".to_owned(),
            value: "".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_COMMIT_REF_PROTECTED".to_owned(),
            value: "false".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_COMMIT_TIMESTAMP".to_owned(),
            value: "2021-05-05T12:19:53+02:00".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_COMMIT_AUTHOR".to_owned(),
            value: "Test User <test@example.com>".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_BUILD_REF".to_owned(),
            value: "265c14cf140a66cfc61e40e4ab45c95ba8df5ed1".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_BUILD_BEFORE_SHA".to_owned(),
            value: "fc40ad32cdd36b814f07a540605110edc209a38c".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_BUILD_REF_NAME".to_owned(),
            value: "custom".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_BUILD_REF_SLUG".to_owned(),
            value: "custom".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_RUNNER_ID".to_owned(),
            value: "8".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_RUNNER_DESCRIPTION".to_owned(),
            value: "Rust runner test".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "CI_RUNNER_TAGS".to_owned(),
            value: "rust-runner".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "GITLAB_USER_ID".to_owned(),
            value: "2".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "GITLAB_USER_EMAIL".to_owned(),
            value: "test@example.com".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "GITLAB_USER_LOGIN".to_owned(),
            value: "test".to_owned(),
            public: true,
            masked: false,
        },
        MockJobVariable {
            key: "GITLAB_USER_NAME".to_owned(),
            value: "Test User".to_owned(),
            public: true,
            masked: false,
        },
    ]
}
