/*! `error-chain` boilerplate and custom `Error` types */
// Copyright 2020, Marcel Schneider <marcel@webschneider.org>

// Create the Error, ErrorKind, ResultExt, and Result types
error_chain! {
    foreign_links{
        Io(::std::io::Error) #[doc = "Link to a `std::io::Error` type."];
    }
    errors{
        NoGitRootFound {
            description("no git root found"),
        }
        TemplateNotFound(t: String) {
            description("could not find template"),
            display("could not find a template for {}", t),
        }
        TemplateNoDownloadUrl(name: String) {
            description("template has no download url"),
            display("template {} has no download url", name)
        }
        TemplateNoContent {
            description("template contains no content that could be used or written. try to `load_content` first.")
        }
        NoShellProvided {
            description("no shell provided"),
        }
    }

}
