use chrono::{DateTime, Local};
use getset::{CopyGetters, Getters};
use serde::{Deserialize, Serialize};

use crate::{License, User};

#[derive(Clone, Debug, Serialize, Deserialize, Getters, CopyGetters)]
#[getset(get, get)]
pub struct Repository {
    id: usize,
    node_id: String,
    name: String,
    full_name: String,
    private: bool,
    owner: User,
    html_url: String,
    description: String,
    fork: bool,
    url: Option<String>,
    forks_url: String,
    keys_url: String,
    collaborators_url: String,
    teams_url: String,
    hooks_url: String,
    issue_events_url: String,
    events_url: String,
    assignees_url: String,
    branches_url: String,
    tags_url: String,
    blobs_url: String,
    git_tags_url: String,
    git_refs_url: String,
    trees_url: String,
    statuses_url: String,
    languages_url: String,
    stargazers_url: String,
    contributors_url: String,
    subscribers_url: String,
    subscription_url: String,
    commits_url: String,
    git_commits_url: String,
    comments_url: String,
    issue_comment_url: String,
    contents_url: String,
    compare_url: String,
    merges_url: String,
    archive_url: String,
    downloads_url: String,
    issues_url: String,
    pulls_url: String,
    milestones_url: String,
    notifications_url: String,
    labels_url: String,
    deployments_url: String,
    created_at: DateTime<Local>,
    updated_at: DateTime<Local>,
    pushed_at: DateTime<Local>,
    git_url: String,
    ssh_url: String,
    clone_url: String,
    svn_url: String,
    homepage: String,
    size: usize,
    stargazers_count: usize,
    watchers_count: usize,
    language: Option<String>,
    has_issues: bool,
    has_projects: bool,
    has_downloads: bool,
    has_wiki: bool,
    has_pages: bool,
    forks_count: usize,
    mirror_url: Option<String>,
    archived: bool,
    disabled: bool,
    open_issues_count: usize,
    license: Option<License>,
    allow_forking: bool,
    is_template: bool,
    topics: Vec<String>,
    visibility: String,
    forks: usize,
    open_issues: usize,
    watchers: usize,
    default_branch: String,
    temp_clone_token: Option<String>,
    organization: Option<User>,
    network_count: usize,
    subscribers_count: usize,
}
