use serde::{Deserialize, Serialize};

#[derive(Debug, Serialize, Deserialize)]
pub struct PullRequest {
    pub url:                   String,
    pub id:                    i64,
    pub node_id:               String,
    pub html_url:              String,
    pub diff_url:              String,
    pub patch_url:             String,
    pub issue_url:             String,
    pub number:                i64,
    pub state:                 String,
    pub locked:                bool,
    pub title:                 String,
    pub user:                  Assignee,
    pub body:                  Option<String>,
    pub created_at:            String,
    pub updated_at:            String,
    pub closed_at:             Option<String>,
    pub merged_at:             Option<String>,
    pub merge_commit_sha:      String,
    pub assignee:              Assignee,
    pub assignees:             Vec<Assignee>,
    pub requested_reviewers:   Vec<Option<serde_json::Value>>,
    pub requested_teams:       Vec<Option<serde_json::Value>>,
    pub labels:                Vec<Label>,
    pub milestone:             Option<serde_json::Value>,
    pub draft:                 bool,
    pub commits_url:           String,
    pub review_comments_url:   String,
    pub review_comment_url:    String,
    pub comments_url:          String,
    pub statuses_url:          String,
    pub head:                  Base,
    pub base:                  Base,
    #[serde(rename = "_links")]
    pub links:                 Links,
    pub author_association:    String,
    pub auto_merge:            Option<serde_json::Value>,
    pub active_lock_reason:    Option<serde_json::Value>,
    pub merged:                bool,
    pub mergeable:             Option<serde_json::Value>,
    pub rebaseable:            Option<serde_json::Value>,
    pub mergeable_state:       String,
    pub merged_by:             Option<Assignee>,
    pub comments:              i64,
    pub review_comments:       i64,
    pub maintainer_can_modify: bool,
    pub commits:               i64,
    pub additions:             i64,
    pub deletions:             i64,
    pub changed_files:         i64,
}

#[derive(Debug, Serialize, Deserialize)]
pub struct Assignee {
    pub login:               String,
    pub id:                  i64,
    pub node_id:             String,
    pub avatar_url:          String,
    pub gravatar_id:         String,
    pub url:                 String,
    pub html_url:            String,
    pub followers_url:       String,
    pub following_url:       String,
    pub gists_url:           String,
    pub starred_url:         String,
    pub subscriptions_url:   String,
    pub organizations_url:   String,
    pub repos_url:           String,
    pub events_url:          String,
    pub received_events_url: String,
    #[serde(rename = "type")]
    pub assignee_type:       String,
    pub site_admin:          bool,
}

#[derive(Debug, Serialize, Deserialize)]
pub struct Base {
    pub label:    String,
    #[serde(rename = "ref")]
    pub base_ref: String,
    pub sha:      String,
    pub user:     Assignee,
    pub repo:     Repo,
}

#[derive(Debug, Serialize, Deserialize)]
pub struct Repo {
    pub id:                i64,
    pub node_id:           String,
    pub name:              String,
    pub full_name:         String,
    pub private:           bool,
    pub owner:             Assignee,
    pub html_url:          String,
    pub description:       Option<String>,
    pub fork:              bool,
    pub url:               String,
    pub forks_url:         String,
    pub keys_url:          String,
    pub collaborators_url: String,
    pub teams_url:         String,
    pub hooks_url:         String,
    pub issue_events_url:  String,
    pub events_url:        String,
    pub assignees_url:     String,
    pub branches_url:      String,
    pub tags_url:          String,
    pub blobs_url:         String,
    pub git_tags_url:      String,
    pub git_refs_url:      String,
    pub trees_url:         String,
    pub statuses_url:      String,
    pub languages_url:     String,
    pub stargazers_url:    String,
    pub contributors_url:  String,
    pub subscribers_url:   String,
    pub subscription_url:  String,
    pub commits_url:       String,
    pub git_commits_url:   String,
    pub comments_url:      String,
    pub issue_comment_url: String,
    pub contents_url:      String,
    pub compare_url:       String,
    pub merges_url:        String,
    pub archive_url:       String,
    pub downloads_url:     String,
    pub issues_url:        String,
    pub pulls_url:         String,
    pub milestones_url:    String,
    pub notifications_url: String,
    pub labels_url:        String,
    pub releases_url:      String,
    pub deployments_url:   String,
    pub created_at:        String,
    pub updated_at:        String,
    pub pushed_at:         String,
    pub git_url:           String,
    pub ssh_url:           String,
    pub clone_url:         String,
    pub svn_url:           String,
    pub homepage:          String,
    pub size:              i64,
    pub stargazers_count:  i64,
    pub watchers_count:    i64,
    pub language:          String,
    pub has_issues:        bool,
    pub has_projects:      bool,
    pub has_downloads:     bool,
    pub has_wiki:          bool,
    pub has_pages:         bool,
    pub forks_count:       i64,
    pub mirror_url:        Option<serde_json::Value>,
    pub archived:          bool,
    pub disabled:          bool,
    pub open_issues_count: i64,
    pub license:           Option<serde_json::Value>,
    pub forks:             i64,
    pub open_issues:       i64,
    pub watchers:          i64,
    pub default_branch:    String,
}

#[derive(Debug, Serialize, Deserialize)]
pub struct Label {
    pub id:            i64,
    pub node_id:       String,
    pub url:           String,
    pub name:          String,
    pub color:         String,
    #[serde(rename = "default")]
    pub label_default: bool,
    pub description:   Option<serde_json::Value>,
}

#[derive(Debug, Serialize, Deserialize)]
pub struct Links {
    #[serde(rename = "self")]
    pub links_self:      Comments,
    pub html:            Comments,
    pub issue:           Comments,
    pub comments:        Comments,
    pub review_comments: Comments,
    pub review_comment:  Comments,
    pub commits:         Comments,
    pub statuses:        Comments,
}

#[derive(Debug, Serialize, Deserialize)]
pub struct Comments {
    pub href: String,
}
