use std::process::Command;

#[derive(Debug, PartialEq)]
pub enum RepositoryCommandChoice {
	ShouldCommit,
	ShouldRevert,
}

pub fn tcr(command: Vec<String>) -> RepositoryCommandChoice {
	let status = Command::new(&command[0])
		.args(&command[1..])
		.status()
		.expect("failed to run tests");
	if status.success() {
		RepositoryCommandChoice::ShouldCommit
	} else {
		RepositoryCommandChoice::ShouldRevert
	}
}

pub fn trc(command: Vec<String>) -> RepositoryCommandChoice {
	let status = Command::new(&command[0])
		.args(&command[1..])
		.status()
		.expect("failed to run tests");
	if status.success() {
		RepositoryCommandChoice::ShouldRevert
	} else {
		RepositoryCommandChoice::ShouldCommit
	}
}

#[cfg(test)]
extern crate speculate;

#[cfg(test)]
use speculate::speculate;

#[cfg(test)]
speculate! {
	describe "tcr" {
		it "should commit when command exited with a zero code" {
			assert_eq!(tcr(vec!(String::from("true"))), RepositoryCommandChoice::ShouldCommit)
		}

		it "should revert when command exited with a non zero code" {
			assert_eq!(tcr(vec!(String::from("false"))), RepositoryCommandChoice::ShouldRevert)
		}
	}

	describe "trc" {
		it "should revert when command exited with a zero code" {
			assert_eq!(trc(vec!(String::from("true"))), RepositoryCommandChoice::ShouldRevert)
		}

		it "should commit when command exited with a non zero code" {
			assert_eq!(trc(vec!(String::from("false"))), RepositoryCommandChoice::ShouldCommit)
		}
	}
}
