use log::info;
use std::env;
use std::fs;
use std::io;
use std::str::FromStr;
use structopt::clap::Shell;
use structopt::StructOpt;

mod app;
use app::App;

fn main() -> io::Result<()> {
	pretty_env_logger::init();

	let out_dir = env::var_os("SHELL_COMPLETIONS_DIR")
		.or_else(|| env::var_os("OUT_DIR"))
		.expect(
			"Neither \"SHELL_COMPLETIONS_DIR\" or \"OUT_DIR\" environment variables were provided",
		);
	let out_dir = out_dir.to_str().unwrap();

	info!("generate shell completions in {}", &out_dir);
	fs::create_dir_all(out_dir)?;

	for shell in Shell::variants().iter() {
		generate_completion_for(shell, out_dir);
	}

	Ok(())
}

fn generate_completion_for(shell_name: &str, out_dir: &str) {
	let package_name = env!("CARGO_PKG_NAME");

	match Shell::from_str(shell_name) {
		Ok(shell) => App::clap().gen_completions(package_name, shell, out_dir),
		Err(error) => eprintln!("{:#?}", error),
	};
}
