use std::path::PathBuf;
use structopt::clap::{AppSettings, ArgGroup, Shell};
use structopt::StructOpt;

#[derive(StructOpt, Debug)]
#[structopt(setting(AppSettings::ColoredHelp))]
pub struct GenerateShellCompletions {
	#[structopt(possible_values = &Shell::variants(), long_help = "Put generated file here :\n* Fish https://fishshell.com/docs/current/completions.html#where-to-put-completions\n* Others shells ; Don't know, MR are welcome\n")]
	pub shell: String,
}

#[derive(StructOpt, Debug)]
#[structopt(setting(AppSettings::ColoredHelp))]
pub enum OptionalSubcommands {
	GenerateShellCompletions(GenerateShellCompletions),
}

#[derive(StructOpt, Debug)]
#[structopt(
	setting(AppSettings::ColoredHelp),
	setting(AppSettings::SubcommandsNegateReqs),
	group = ArgGroup::with_name("gambling").required(true),
	about = "Blend TCR (`test && commit || revert`) + TDD (Test Driven Development) to make sure to develop\nthe right thing, babystep by babystep",
	after_help = "Any contributions (feedback, bug report, merge request ...) are welcome\nhttps://gitlab.com/pinage404/git-gamble",
)]
pub struct App {
	// subcommands
	#[structopt(subcommand)]
	pub optional_subcommands: Option<OptionalSubcommands>,

	// flags
	/// Gamble that tests should pass
	#[structopt(
		short = "g",
		long,
		group = "gambling",
		visible_aliases = &["green", "refactor"],
		display_order = 1,
	)]
	pub pass: bool,
	/// Gamble that tests should fail
	#[structopt(
		short = "r",
		long,
		group = "gambling",
		visible_alias = "red",
		display_order = 1
	)]
	pub fail: bool,
	/// Do not make any changes
	#[structopt(short = "n", long)]
	pub dry_run: bool,
	/// Do not run git hooks
	#[structopt(long)]
	pub no_verify: bool,

	// options
	/// Repository path
	// reflect `git -C <repository-path>`
	#[structopt(short = "C", long, default_value = ".")]
	pub repository_path: PathBuf,

	/// Commit's message
	#[structopt(short = "m", long, default_value = "")]
	pub message: String,

	// rest arguments
	/// The command to execute to know the result
	#[structopt(
		env = "GAMBLE_TEST_COMMAND",
		multiple = true,
		last = true,
		required = true
	)]
	pub test_command: Vec<String>,
}
