use crate::app::App;
use crate::app::GenerateShellCompletions;
use std::io;
use std::process::exit;
use std::str::FromStr;
use structopt::clap::Shell;
use structopt::StructOpt;

pub fn generate_shell_completions(opt: &GenerateShellCompletions) {
	let package_name = env!("CARGO_PKG_NAME");
	let shell = Shell::from_str(&opt.shell).unwrap();
	App::clap().gen_completions_to(package_name, shell, &mut io::stdout());

	exit(0);
}
