use std::path::PathBuf;
use structopt::clap::ArgGroup;
use structopt::StructOpt;

#[derive(StructOpt, Debug)]
#[structopt(group = ArgGroup::with_name("gambling").required(true))]
pub struct App {
	// flags
	/// Gamble that tests should pass
	#[structopt(short = "g", long, group = "gambling", visible_aliases = &["green", "refactor"])]
	pub pass: bool,
	/// Gamble that tests should fail
	#[structopt(short = "r", long, group = "gambling", visible_alias = "red")]
	pub fail: bool,
	/// Do not make any changes
	#[structopt(short = "n", long)]
	pub dry_run: bool,
	/// Do not run git hooks
	#[structopt(long)]
	pub no_verify: bool,

	// options
	/// Repository path
	// reflect `git -C <repository-path>`
	#[structopt(short = "C", long, default_value = ".")]
	pub repository_path: PathBuf,

	/// Commit's message
	#[structopt(short = "m", long, default_value = "")]
	pub message: String,

	// rest arguments
	/// The command to execute to know the result
	#[structopt(
		env = "GAMBLE_TEST_COMMAND",
		multiple = true,
		last = true,
		required = true
	)]
	pub test_command: Vec<String>,
}
