<img src="https://gitlab.com/pinage404/git-gamble/-/raw/main/assets/logo/git-gamble.svg" width="100" title="git-gamble's logo" alt="git-gamble's logo" />

# Git-Gamble

[![Crate available on Crates.io](https://img.shields.io/crates/v/git-gamble.svg?logo=rust) ![](https://img.shields.io/crates/d/git-gamble.svg?logo=rust)](https://crates.io/crates/git-gamble)
[![AppImage available on GitLab](https://img.shields.io/badge/dynamic/json?url=https%3A%2F%2Fcrates.io%2Fapi%2Fv1%2Fcrates%2Fgit-gamble%2Fversions&query=versions.0.num&label=AppImage&prefix=v&logo=linux)](https://gitlab.com/pinage404/git-gamble/-/packages)
[![Debian available on GitLab](https://img.shields.io/badge/dynamic/json?url=https%3A%2F%2Fcrates.io%2Fapi%2Fv1%2Fcrates%2Fgit-gamble%2Fversions&query=versions.0.num&label=Debian&prefix=v&logo=debian)](https://gitlab.com/pinage404/git-gamble/-/packages)
[![pipeline status](https://img.shields.io/gitlab/pipeline/pinage404/git-gamble?label=pipeline&logo=gitlab)](https://gitlab.com/pinage404/git-gamble/commits/main)
[![AppVeyor for Homebrew status](https://ci.appveyor.com/api/projects/status/qrd9p11ec2kbt1xs?svg=true)](https://ci.appveyor.com/project/pinage404/git-gamble)
[![License ISC](https://img.shields.io/crates/l/git-gamble.svg)](https://gitlab.com/pinage404/git-gamble/blob/main/LICENSE)
[![Contributor Covenant](https://img.shields.io/badge/Contributor%20Covenant-v2.0%20adopted-ff69b4.svg)](code_of_conduct.md)

Blend [TCR (`test && commit || revert`)](https://rachelcarmena.github.io/2018/11/13/test-driven-programming-workflows.html) + [TDD (Test Driven Development)](https://www.wikiwand.com/en/Test-driven_development) to make sure to **develop** the **right** thing, **babystep by babystep**

[Original idea](https://github.com/FaustXVI/tcrdd) by Xavier Detant

[[_TOC_]]

## Theory

### TCR

_[**TCR** (`test && commit || revert`)](https://rachelcarmena.github.io/2018/11/13/test-driven-programming-workflows.html) is cool!_ It **encourages** doing **baby steps**, reducing the waste when we are wrong

But it **doesn't** allow us to **see** the **tests failing**

So:

- Maybe we test nothing (assert forgotten)

  ```python
  def test_should_be_Buzz_given_5():
      input = 5
      actual = fizz_buzz(input)
      # Oops! Assert has been forgotten
  ```

- Maybe we are testing something that is not the thing we should be testing

  ```typescript
  it("should be Fizz given 3", () => {
    const input = 3;
    const actual = fizzBuzz(input);
    expect(input).toBe("Fizz");
    // Oops! Asserts on the input value instead of the actual value
  });
  ```

### TDD

_[**TDD** (Test Driven Development)](https://www.wikiwand.com/en/Test-driven_development) is cool!_ It makes sure we **develop** the **right** thing, step by step

### TCRDD

**T**_CRDD_ = **T**_CR_ + **T**_DD_

TCRDD **blends** the constraints of the two **methods** to **benefit** from their **advantages**

Therefore, TCRDD makes sure we **develop** the **right** thing, step by step, and we are **encouraged** to do so by **baby steps**, reducing the waste when we are wrong

```plantuml
@startuml
skinparam ArrowColor black

start
repeat
	partition "red" #Coral {
		repeat
			:Write a test]
			:Gamble that the tests fail/
			if (Actually run tests) then (Fail)
				-[#Red]->
				:Commit;
				break
			else (Pass)
				-[#Green]->
				:Revert;
			endif
		repeat while (Write another test)
	}
	partition "green" #Lime {
		repeat
			:Write the minimum code]
			:Gamble that the tests pass/
			if (Actually run tests) then (Pass)
				-[#Green]->
				:Commit;
				break
			else (Fail)
				-[#Red]->
				:Revert;
			endif
		repeat while (Try something else)
	}
	partition "refactor" #668cff {
		repeat
			repeat
				:Write code
				without changing the behavior]
				:Gamble that the tests pass/
				if (Actually run tests) then (Pass)
					-[#Green]->
					:Commit;
					break
				else (Fail)
					-[#Tomato]->
					:Revert;
				endif
			repeat while (Change something else)
		repeat while (Another things to refactor ?)
	}
repeat while (Another feature to add ?)
stop
@enduml
```

`git-gamble` is a tool that helps to use the TCRDD method

## How to install

### Requirements

`git-gamble` doesn't repackage `git`, it use the one installed on your system

For (the others packaging include `git` as a dependency):

- AppImage
- Debian
- Cargo

[Install `git`](https://git-scm.com/book/en/v2/Getting-Started-Installing-Git)

Be sure to make it available in your `$PATH`, you can check with this command

```shell
git --help
```

### AppImage

1. Download the [latest version](https://gitlab.com/api/v4/projects/pinage404%2Fgit-gamble/packages/generic/git-gamble-AppImage/2.0.0/git-gamble-v2.0.0-x86_64.AppImage)

	```shell
	curl --location "https://gitlab.com/api/v4/projects/pinage404%2Fgit-gamble/packages/generic/git-gamble-AppImage/2.0.0/git-gamble-v2.0.0-x86_64.AppImage" --output git-gamble-v2.0.0-x86_64.AppImage
	```

1. Make it executable

	```shell
	chmod +x git-gamble-v2.0.0-x86_64.AppImage
	```

1. Put it your `$PATH`

	```shell
	# for example
	mkdir -p ~/.local/bin
	ln git-gamble-v2.0.0-x86_64.AppImage ~/.local/bin/git-gamble
	export PATH+=":~/.local/bin"
	```

### Debian

1. Go to [the package registry page](https://gitlab.com/pinage404/git-gamble/-/packages)
1. Go to the latest version of `git-gamble-debian`
1. Download the latest version `git-gamble_2.0.0_amd64.deb`
1. Install package

	As **root**

	```shell
	dpkg --install git-gamble*.deb
	```

This is not really convenient but a better way will come when [GitLab Debian Package Manager MVC](https://gitlab.com/gitlab-org/gitlab/-/issues/5835) will be available

### Mac OS X / Homebrew

[Install Homebrew](https://brew.sh/)

```shell
brew tap pinage404/git-gamble https://gitlab.com/pinage404/git-gamble.git
brew install --HEAD git-gamble
```

### Windows / Chocolatey

[Install Chocolatey](https://chocolatey.org/)

1. Go to [the package registry page](https://gitlab.com/pinage404/git-gamble/-/packages)
1. Go to the latest version of `git-gamble.portable`
1. Download the latest version `git-gamble.portable.2.0.0.nupkg`
1. Install package

	Follow [GitLab's documentation](https://docs.gitlab.com/ee/user/packages/nuget_repository/index.html) and [Chocolatey's documentation](https://docs.chocolatey.org/en-us/choco/commands/install)

	```shell
	choco install ./git-gamble.portable.2.0.0.nupkg
	```

This is not really convenient, [contributions are welcome](README.md#contributing)

### Nix / NixOS

Installation can be done at different levels, see below

You will have to run command several times to change the `sha256` and `cargoSha256` by the given one by Nix

#### Project level

In `default.nix`

```nix
{ pkgs ? import <nixpkgs> {} }:

let
  git-gamble-derivation = pkgs.fetchurl {
    url = "https://gitlab.com/pinage404/git-gamble/-/raw/main/packaging/nix/git-gamble/default.nix?";
    sha256 = "0000000000000000000000000000000000000000000000000000";
  };
  git-gamble = pkgs.callPackage git-gamble-derivation {
    version = "2.0.0";
    sha256 = "1111111111111111111111111111111111111111111111111111";
    cargoSha256 = "0000000000000000000000000000000000000000000000000000";
  };
in
pkgs.mkShell {
  buildInputs = [
    git-gamble

    # others dependencies here
    pkgs.nodejs
  ];
}
```

Then run this command

```shell
nix-shell
```

##### DirEnv

To automate the setup of the environment it's recommanded to install [DirEnv](https://direnv.net/)

Add in `.envrc`

```direnv
use nix
```

Then run this command

```shell
direnv allow
```

#### Home-Manager / user level

Install [Home Manager](https://nix-community.github.io/home-manager/)

In `~/.config/nixpkgs/home.nix`

```nix
{ pkgs, ... }:

let
  git-gamble-derivation = pkgs.fetchurl {
    url = "https://gitlab.com/pinage404/git-gamble/-/raw/main/packaging/nix/git-gamble/default.nix?";
    sha256 = "0000000000000000000000000000000000000000000000000000";
  };
  git-gamble = pkgs.callPackage git-gamble-derivation {
    version = "2.0.0";
    sha256 = "1111111111111111111111111111111111111111111111111111";
    cargoSha256 = "0000000000000000000000000000000000000000000000000000";
  };
in
{
  home.packages = [
    git-gamble

    # others dependencies here
    pkgs.gitAndTools.git-absorb
  ];
}
```

Then run this command

```shell
home-manager switch
```

#### NixOS / system level

In `/etc/nixos/configuration.nix`

```nix
{ pkgs, ... }:

let
  git-gamble-derivation = pkgs.fetchurl {
    url = "https://gitlab.com/pinage404/git-gamble/-/raw/main/packaging/nix/git-gamble/default.nix?";
    sha256 = "0000000000000000000000000000000000000000000000000000";
  };
  git-gamble = pkgs.callPackage git-gamble-derivation {
    version = "2.0.0";
    sha256 = "1111111111111111111111111111111111111111111111111111";
    cargoSha256 = "0000000000000000000000000000000000000000000000000000";
  };
in
{
  environment.systemPackages = [
    git-gamble

    # others dependencies here
    pkgs.bat
  ];

  # This value determines the NixOS release with which your system is to be compatible, in order to avoid breaking some software such as database servers
  # You should change this only after NixOS release notes say you should
  system.stateVersion = "20.09";
}
```

Then run this command

```shell
nixos-rebuild switch
```

### Cargo

[Install Cargo](https://doc.rust-lang.org/cargo/getting-started/installation.html)

```shell
cargo install git-gamble
```

Add `~/.cargo/bin` to your `$PATH`

Fish:

```fish
set --export --append PATH ~/.cargo/bin
```

Bash / ZSH:

```bash
export PATH=$PATH:~/.cargo/bin
```

### Check the installation

Check if all have been well settled

```shell
git gamble
```

If it has been **well settled**, it should output this :

    error: The following required arguments were not provided:
        <test-command>...
        <--pass|--fail>

    USAGE:
        git-gamble --repository-path <repository-path> <--pass|--fail>

    For more information try --help

If it has been **badly settled**, it should output this :

    git : 'gamble' is not a git command. See 'git --help'.

## How to use

To see all available flags and options

```shell
git-gamble --help # dash is only needed for --help
```

1. Write a failing test in your codebase, then :

   ```shell
   git gamble --fail -- $YOUR_TEST_COMMAND
   ```

1. Write the minimum code to make tests pass, then :

   ```shell
   git gamble --pass -- $YOUR_TEST_COMMAND
   ```

1. Refactor your code, then :

   ```shell
   git gamble --pass -- $YOUR_TEST_COMMAND
   ```

It's a bit tedious to always repeat the test command

So you can set an environment variable with the test command to avoid repeating it all the time

```shell
export GAMBLE_TEST_COMMAND="sh -c 'cargo fix --allow-dirty ; cargo clippy --all-targets ; cargo check --all-targets ; cargo fmt ; cargo test'"
git gamble --pass
```

Test command must exit with a 0 status when there are 0 failing tests, anything else is considered as a failure

## Backlog

```plantuml
@startmindmap "backlog"
* Backlog
left side
	* Done
		* MVP
			* base
				* run tests
				* `git commit`
				* `git revert`
				* test it
			* TCR
				* option --pass
			* TRC
				* option --fail
		* give path in option
		* improve test command
			* test command with arguments
			* script
		* dry run flag
		* help option
			* -h
			* --help
		* exclusive flag
		* required flag
		* option colors
			* -g
			* --green
			* -r
			* --red
		* merge commits
			* `git update-ref`
			* `git commit --amend`
		* should fail without test command
		* test command from environement variable
		* display when committed or reverted
		* how to use
		* test in isolated and reproductible environement
			* container
			* CI
			* [[https://doc.rust-lang.org/cargo/guide/continuous-integration.html Cargo's Documentation about CI]]
		* complete metadata
		* rename project?
			* simpler to say and understand and remember when not familiar with `TCR` or `TDD`
			* from `git-tcrdd` to `git-...`?
				* [[https://www.wordreference.com/fren/jouer jouer?]]
				* [[https://www.wordreference.com/fren/parier parier?]]
				* [[https://www.wordreference.com/enfr/bet bet?]]
				* [[https://www.wordreference.com/enfr/expect expect?]]
				* [[https://www.wordreference.com/enfr/gamble gamble?]]
				* [[https://www.wordreference.com/enfr/should should?]]
				* Quick save development (qsd)
		* TDD's option `--refactor` == `--pass`
		* message option
			* -m
			* --message
			* amend should keep message
				* `"--reuse-message=@",`
		* shell completion
			* shells
				* [x] Fish
				* [x] Bash
				* [x] Zsh
			* package
				* [x] Debian
				* [x] Homebrew
	* WIP
right side
	* TODO
		* `--edit` OR `--edit-message` option to open `$EDITOR` on commit like `git commit --edit`
			* how to test it ?
		* when revert `git clean`
		* `git workspace` support
			* `git update-ref` should contain an unique identifier to the workspace
				* branche name ?
				* folder path ?
		* gamble hooks
			* branch based developement
				* `git commit --fixup`
				* `git rebase --autosquash`
			* trunk based developement
				* `git pull`
				* `git push`
		* like git, flags & options & arguments should be retrieved from CLI or environment variable or config's file
			* re-use `git config` to store in file ?
			* repository level config using direnv and environment variable ?
		* [[https://rachelcarmena.github.io/2018/11/13/test-driven-programming-workflows.html#my-proposal-of-tcr-variant stash instead of revert ?]]
		* `--help` should link to the repository
		* shell completion
			* in the package ?
				* [ ] Cargo
				* [ ] AppImage
				* [ ] Chocolatey
			* in sub command ?
			* for `git gamble` not only `git-gamble`
@endmindmap
```

### Distribution / publishing backlog

- OS distribution
  - Linux
    - Move packages distribution from BinTray to elsewhere (GitLab ?)
      1. [x] AppImage
          - [x] upload package elsewhere
          - [x] update installation instructions
          - [x] remove BinTray links
      1. [x] Chocolatey
          - [x] upload package elsewhere
          - [x] update installation instructions
      1. [x] Debian
          - [x] upload package elsewhere
          - [x] update installation instructions
          - [x] remove BinTray links
      1. [x] changelog BinTray breaking change
      1. 2.0.0
          - [x] remove BinTray badges
          - [x] remove BinTray job
          - [x] remove BinTray CI variables
    - Nix
      - [`crate2nix`](https://crates.io/crates/crate2nix)
      - [`cargo2nix`](https://github.com/tenx-tech/cargo2nix)
      - [NixOS documentation](https://github.com/NixOS/nixpkgs/blob/master/doc/languages-frameworks/rust.section.md)
    - RPM
      - [`cargo-rpm`](https://crates.io/crates/cargo-rpm)
    - make AppImage updatable
      - bintray-zsync|pinage404|git-gamble-AppImages|git-gamble|git-gamble-\_latestVersion-x86_64.AppImage.zsync
    - SnapCraft ?
      - [snapcraft's docs about rust](https://snapcraft.io/docs/rust-applications)
    - FlatPak ?
    - [`fpm` : tool that help to generate to several packages](https://github.com/jordansissel/fpm)
    - document AppImage with firejail ?
    - document AppImage with bubblewrap ?
    - [Open Build Service](https://build.opensuse.org/) seems to be a service that build for every Linux targets
      - it can be [use](https://en.opensuse.org/openSUSE:Build_Service_Clients)
        - thougth REST
          - badly documented
        - with `ocs` a CLI who seems to be a VCS like SVN (commit = commit + push)
          - who use the REST API under the hood
  - Container Image (Docker) ?
  - [Awesome Rust Deployment](https://github.com/rust-unofficial/awesome-rust#deployment)
  - [Awesome Rust Platform Specific](https://github.com/rust-unofficial/awesome-rust#platform-specific)
- URL to download latest version
  - symlinks to URL containing the version name ?
  - using GitLab Pages ?
- versioned Homebrew Formula
  - Use [Cargo-Release](https://github.com/sunng87/cargo-release/blob/master/docs/faq.md#how-do-i-update-my-readme-or-other-files) to bump version
  - how to update sha256 in the versioned file ?

#### Adding package to the X packages repository

Where the X packages repository is e.g. Nixpgks, Debian, Homebrew, Chocolatey ...

Feel free to do it, we don't plan to do it at the moment, it's too long to learn and understand how each of them works

If you do it, please file an issue or open an MR to update the documentation

#### CheckList

- [ ] package in local
- [ ] package in CI
- [ ] upload
- [ ] make public available
- [ ] complete how to install
- [ ] manual test
- [ ] update backlog

### Technical improvement opportunities

- licence check
  - cargo license
  - cargo deny
- code coverage
  - tarpaulin
  - kcov
- smaller binary
  - cargo bloat
  - cargo deps

## Reinvent the wheel

> Why reinvent the wheel?
>
> This [script](https://github.com/FaustXVI/tcrdd) already works well

Because i would like to learn Rust `¯\_(ツ)_/¯`

## Contributing

[![Contributor Covenant](https://img.shields.io/badge/Contributor%20Covenant-v2.0%20adopted-ff69b4.svg)](code_of_conduct.md)

Any contributions ([feedback, bug report](https://gitlab.com/pinage404/git-gamble/-/issues), [merge request](https://gitlab.com/pinage404/git-gamble/-/merge_requests) ...) are welcome

Respect the [code of conduct](code_of_conduct.md)

Follow [Keep a Changelog](https://keepachangelog.com/en/1.1.0/)

### Development

To contribute with merge request

#### Simple

Install [Direnv](https://direnv.net/)

Install [Nix](https://nixos.org/guides/install-nix.html)

Let `direnv` automagically set up the environment by executing the following command in the project directory

```shell
direnv allow
```

#### Manual

- [Rustup](https://rustup.rs/)
- [clippy](https://crates.io/crates/clippy)
- [rustfmt](https://github.com/rust-lang/rustfmt)
- [rustfix](https://github.com/rust-lang/rustfix)
- [PlantUML](https://plantuml.com/fr/) if you want to see diagrams

### Deployment

- [cargo release](https://crates.io/crates/cargo-release)
