# Changelog

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/)
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html)

<!-- next-version -->
## [Unreleased] - ReleaseDate



[Unreleased]: https://gitlab.com/pinage404/git-gamble/-/compare/version/2.0.0...HEAD

## [2.0.0] - 2021-09-25

### Packages repositories

* **⚠️ BREAKING CHANGE ⚠️** remove BinTray package publishing

### Features

* add [`--no-verify` option](https://git-scm.com/docs/git-commit#Documentation/git-commit.txt---no-verify) to skip [githooks](https://git-scm.com/docs/githooks) that is passed to [`git commit`](https://git-scm.com/docs/git-commit) command ; Contribution by [@korrat (Markus Haug)](https://gitlab.com/korrat) in [MR !2](https://gitlab.com/pinage404/git-gamble/-/merge_requests/2)

### Documentation / Distribution

* improve [Nix / NixOS installation instructions](README.md#nix-nixos)
* add shell completions for [Nix / NixOS](README.md#nix-nixos)
* add man page for [Nix / NixOS](README.md#nix-nixos)
* improve [AppImage installation instructions](README.md#appimage)

### Technical

* smaller container image in CI
* upload only required files to crates.io, thanks to [`cargo-diet`](https://github.com/the-lean-crate/cargo-diet)
* bump Rust from 1.50 to 1.55
* bump some dependencies
* remove some linters warnings
* allow `git-gamble` to run inside `nix-shell`
* explicitly set `cargo` as a dependency

### Others

* rename default branch from `master` to `main`

[2.0.0]: https://gitlab.com/pinage404/git-gamble/-/compare/version/1.3.0...version/2.0.0

## [1.3.0] - 2021-03-12

### Technical

#### Packages repositories

Packages repositories will be [moved on GitLab](https://gitlab.com/pinage404/git-gamble/-/packages) because [JFrog will shutdown BinTray](https://jfrog.com/blog/into-the-sunset-bintray-jcenter-gocenter-and-chartcenter/)

Please **follow [installation instructions](README.md#how-to-install)** for your specific system

* _Affected_ by this changement
  * **⚠️ Automatic update won't work in the future ⚠️**
    * [Debian](README.md#debian)
    * [Windows / Chocolatey](README.md#windows-chocolatey)
  * There is not automatic update system at the moment, you already have to manually update at each new version
  	 * [AppImage](README.md#appimage)
* _Not affected_ by this changement
  * Mac OS X / Homebrew
  * Nix / NixOS
  * Cargo

This will be a kind of **⚠️ BREAKING CHANGE ⚠️** : `2.0.0` won't be on BinTray

#### Others

- bump image's version for the CI's container
- bump Kaniko's version to build the CI's container

[1.3.0]: https://gitlab.com/pinage404/git-gamble/-/compare/version/1.2.0...version/1.3.0

## [1.2.0] - 2021-02-20

### Added

- installation for [Nix / NixOS](./README.md#nix-nixos)

### Technical

- remove warning at compile time (while using `cargo test`) ; Contribution by [@bachrc](https://gitlab.com/bachrc) in [MR !1](https://gitlab.com/pinage404/git-gamble/-/merge_requests/1)
- improve the speed of the CI
- improve the way to set up the development environment
- bump Rust to 1.50
- bump dependencies

[1.2.0]: https://gitlab.com/pinage404/git-gamble/-/compare/version/1.1.0...version/1.2.0

## [1.1.0] - 2020-05-25

### Added

- custom logo
- shells completions
  - automatically installed with Debian and Homebrew packages
  - only for Bash, Fish, ZSH

[1.1.0]: https://gitlab.com/pinage404/git-gamble/-/compare/version/1.0.0...version/1.1.0

## [1.0.0] - 2020-04-26

Initial project

With the minimum functionalities required for real life use

Installable on Linux, Mac OS X and Windows

[1.0.0]: https://gitlab.com/pinage404/git-gamble/-/compare/077c3e01064ee7923917a919ccb0cb581653f4c5...version/1.0.0
