# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## v0.1.7 (2021-10-15)

This is a maintenance release without functional changes.

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 12 commits contributed to the release over the course of 3 calendar days.
 - 0 commits where understood as [conventional](https://www.conventionalcommits.org).
 - 2 unique issues were worked on: [#198](https://github.com//Byron/gitoxide/issues/198), [#213](https://github.com//Byron/gitoxide/issues/213)

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **[#198](https://github.com//Byron/gitoxide/issues/198)**
    - Maintenance release note to avoid being fully generated ([`56ef363`](https://github.com//Byron/gitoxide/commit/56ef363f0e7a8b9106765d96d0636e38b2bed550))
    - Changlog for git-config ([`abdfe58`](https://github.com//Byron/gitoxide/commit/abdfe588030b0fbdd4d69a73c5739ef4a83e3616))
    - Use correct title for github release to match name of tag ([`90f39ad`](https://github.com//Byron/gitoxide/commit/90f39ad693e0998bc3307bf553fccdc37c8dc0c8))
 * **[#213](https://github.com//Byron/gitoxide/issues/213)**
    - refactor ([`e906d37`](https://github.com//Byron/gitoxide/commit/e906d37e0b4e088b7973728db386a23ea7645fc9))
    - Remove environment variable after test passed ([`7a3ff29`](https://github.com//Byron/gitoxide/commit/7a3ff293048dd6bebec492bd79b12d7889fee3a1))
 * **Uncategorized**
    - Remove after ([`cb72bef`](https://github.com//Byron/gitoxide/commit/cb72befbe08590f29489bde1b85c1582d729e0c4))
    - Mark tests as serial ([`0456142`](https://github.com//Byron/gitoxide/commit/0456142c2ee79c39fd738b5e0ef5a258e56d524f))
    - Add a test for multiple sections ([`0ad6438`](https://github.com//Byron/gitoxide/commit/0ad6438b0c19ef6cd7db469cb3f45f3f820665fd))
    - Format ([`d743ef8`](https://github.com//Byron/gitoxide/commit/d743ef8a4fb08511100650b7cbd027491ecb54de))
    - Add a test for a single key value pair ([`a64d312`](https://github.com//Byron/gitoxide/commit/a64d312313ae9f268747e400ba78cd6254d91426))
    - Add a test case for GIT_CONFIG_COUNT parse error ([`a864812`](https://github.com//Byron/gitoxide/commit/a86481207c592eef9abf3b382fe658370657d296))
    - Add test case for GIT_CONFIG_COUNT=0 ([`c33b498`](https://github.com//Byron/gitoxide/commit/c33b498cac29f04d260e361622a4ee86c035a9c1))
</details>

## v0.1.6 (2021-09-07)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 6 commits contributed to the release over the course of 7 calendar days.
 - 0 commits where understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' where seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Release git-config v0.1.6 ([`b1b6fe0`](https://github.com//Byron/gitoxide/commit/b1b6fe0af52d0ec133cd9ec9ffd5a173ba14a5d2))
    - [repository #185] rustfmt ([`dfbb015`](https://github.com//Byron/gitoxide/commit/dfbb015a89db47c79015135870013ecc384c4aea))
    - [config #185] refactor ([`509c938`](https://github.com//Byron/gitoxide/commit/509c938dd061060141756ee791cdcb6017934fe2))
    - [config #185] Count lines correctly on windows… ([`57203ce`](https://github.com//Byron/gitoxide/commit/57203ce5d5e3c481b69c3ca173e4b00f11aaf7d7))
    - [config #185] add test for handling windows formatted files… ([`2a2a89f`](https://github.com//Byron/gitoxide/commit/2a2a89f68cc45e27a1cf0d33fc644ebabc762302))
    - [config #185] flyby refactor ([`9b9ffa3`](https://github.com//Byron/gitoxide/commit/9b9ffa3c1d5ccbea22aa38b740daa8a349494395))
</details>

## v0.1.5 (2021-08-29)

- maintenance release

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 7 commits contributed to the release over the course of 10 calendar days.
 - 0 commits where understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' where seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Release git-config v0.1.5 ([`150ed76`](https://github.com//Byron/gitoxide/commit/150ed760c8b357e5c40ec0bd8d0cd849b39c34c0))
    - [various #184] configure docs.rs build features ([`cc50249`](https://github.com//Byron/gitoxide/commit/cc502492c512293e93e95610ca80a71896076ded))
    - [object #177] fix docs ([`2fd23ed`](https://github.com//Byron/gitoxide/commit/2fd23ed9ad556b8e46cf650e23f0c6726e304708))
    - Merge pull request #172 from mellowagain/main ([`61aebbf`](https://github.com//Byron/gitoxide/commit/61aebbfff02eb87e0e8c49438a093a21b1134baf))
    - [actor #173] rename immutable::Signature to SignatureRef! ([`96461ac`](https://github.com//Byron/gitoxide/commit/96461ace776d6b351b313d4f2697f2d95b9e196e))
    - Upgrade to nom-7 ([`f0aa3e1`](https://github.com//Byron/gitoxide/commit/f0aa3e1b5b407b2afd187c9cb622676fcddaf706))
    - [smart-release #162] format everything ([`8ff83e5`](https://github.com//Byron/gitoxide/commit/8ff83e5c511ae29979348789bd6e7a2f72b16f1c))
</details>

## v0.1.4 (2021-08-17)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 12 commits contributed to the release.
 - 0 commits where understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' where seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Release git-config v0.1.4 ([`535ff79`](https://github.com//Byron/gitoxide/commit/535ff79d6d28d3f08572f4353a8db4da2b658473))
    - [config] Allow certain warnings during development, fix docs ([`1a2f408`](https://github.com//Byron/gitoxide/commit/1a2f408d045b48925062646bf014d419bd753086))
    - [git-config] Resolved config construction ([`1ab44c0`](https://github.com//Byron/gitoxide/commit/1ab44c06b30b745711bda3711b5ce92dfae306be))
    - Don't enable resolved module yet ([`0bd05b2`](https://github.com//Byron/gitoxide/commit/0bd05b22c86b366bdd01be747ffd5207434ece0d))
    - disable all git-config lints ([`05687b4`](https://github.com//Byron/gitoxide/commit/05687b471cb1cbaa8785ec09177c949773dac05a))
    - disable lint ([`b4302cd`](https://github.com//Byron/gitoxide/commit/b4302cd257e6c76cd85c3af5f28457a1ed91f098))
    - rustfmt git-config for consistency ([`b559dd0`](https://github.com//Byron/gitoxide/commit/b559dd0eda1b210eb996b3e9518d6264e614035f))
    - Add todos ([`dbcd79a`](https://github.com//Byron/gitoxide/commit/dbcd79a0b9776ad2e9f5ca0ff2ed965d3d52c104))
    - Fix contains_key ([`50f9122`](https://github.com//Byron/gitoxide/commit/50f91225b903c8d45a7f3c4a3754b03bc80ccc45))
    - Add IntoIterator for SectionBody ([`d37b17c`](https://github.com//Byron/gitoxide/commit/d37b17c55d35b76cd831e51f18c3b0942bc53724))
    - Document GitConfigFromEnvError ([`eb44cf6`](https://github.com//Byron/gitoxide/commit/eb44cf675cb49a313220377b05f0eded422f7e09))
    - More git-config docs ([`f05a669`](https://github.com//Byron/gitoxide/commit/f05a66905c12844515860d0d5e5e113e05df54cb))
</details>

## v0.1.3 (2021-08-15)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 3 commits contributed to the release over the course of 6 calendar days.
 - 0 commits where understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' where seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Release git-config v0.1.3 ([`319a4ae`](https://github.com//Byron/gitoxide/commit/319a4ae2b71f4e847757aa46f1d9fcc4b4ee12ca))
    - [config] pacify clippy ([`ad41ba6`](https://github.com//Byron/gitoxide/commit/ad41ba6c96da28d704163a455c3185aec7050db5))
    - Fix bench path ([`70f9403`](https://github.com//Byron/gitoxide/commit/70f94032ca7fcad5eaa9cd0064720d72569f9c17))
</details>

## v0.1.2 (2021-08-06)

### Added

 - Added the following methods to `GitConfig`:
   - `is_empty`
   - `len`
   - `from_env`
   - `open`
- `len`
- `from_env`
- `open`

### Changed

 - `parse_from_path` now accepts a `AsRef<Path>` instead of a `&Path`.
 - `parse_from_path` now returns an `ParserOrIoError<'static>` instead, from
   `ParserFromIoError`

### Fixed

 - _None._

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 16 commits contributed to the release over the course of 86 calendar days.
 - 0 commits where understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' where seen in commit messages

### Thanks Clippy

<csr-read-only-do-not-edit/>

[Clippy](https://github.com/rust-lang/rust-clippy) helped 2 times to make code idiomatic. 

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Fix bench path ([`bf0004e`](https://github.com//Byron/gitoxide/commit/bf0004e05ede404921073755aadd8ab8f75273c9))
    - Bump git-config to 0.1.2 ([`9c275dc`](https://github.com//Byron/gitoxide/commit/9c275dc6f1a07ebd6c4cc8ae0edae382bd13c0cf))
    - Use newtyped Index and Size ([`15ae2d7`](https://github.com//Byron/gitoxide/commit/15ae2d76bb1b4bd64d3ee50021a359a777e95538))
    - Re-export everything in git-config::file::mod ([`392c131`](https://github.com//Byron/gitoxide/commit/392c13175892ecf6e543ee6a1fd47c62a38f09cb))
    - Fix rustdoc links ([`042eaf4`](https://github.com//Byron/gitoxide/commit/042eaf4b4625ed47b417a9012556ef6fc69aa2d6))
    - Use AsRef<Path> when opening from path ([`515d256`](https://github.com//Byron/gitoxide/commit/515d2564e430da77c092ceb9414a3b3e7071c158))
    - Add GitConfig::from_env ([`17e30a1`](https://github.com//Byron/gitoxide/commit/17e30a1ede39326cda6c64989ab37d979c9c4a29))
    - Add GitConfig::from_path ([`27df3d1`](https://github.com//Byron/gitoxide/commit/27df3d1d5de1e7660beaf599e4931c3cf7c1f99a))
    - Add is_empty and len to GitConfig ([`aa86594`](https://github.com//Byron/gitoxide/commit/aa865942559ee48d7998adb211a6a8f4e0760375))
    - split file.rs into module ([`da40593`](https://github.com//Byron/gitoxide/commit/da40593b3e4d35dcdf8003123cefc0e367367734))
    - clippy on tests and thanks clippy ([`a77a71c`](https://github.com//Byron/gitoxide/commit/a77a71cf02d328a2a964388928d6b2a235a0aa85))
    - thanks clippy ([`e1964e4`](https://github.com//Byron/gitoxide/commit/e1964e43979b3e32a5d4bfbe377a842d2c0b10ea))
    - Implement Parser::into_iter without extra allocation ([`aa79924`](https://github.com//Byron/gitoxide/commit/aa79924b36c0d717cc65d7471fedd27eb41e83a5))
    - clippy cleanup; fix CI build ([`3e943f2`](https://github.com//Byron/gitoxide/commit/3e943f2afd5f0cfe7294a21cca8e0344c7dd0216))
    - thanks clippy ([`6200ed9`](https://github.com//Byron/gitoxide/commit/6200ed9ac5609c74de4254ab663c19cfe3591402))
    - [git-config] Annotate more functions with inline ([`2006acb`](https://github.com//Byron/gitoxide/commit/2006acb381a3a9e807575991a8eeab1ea010af60))
</details>

<csr-unknown>
lenfrom_envopen<csr-unknown/>
## v0.1.1 (2021-05-09)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 13 commits contributed to the release over the course of 56 calendar days.
 - 0 commits where understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' where seen in commit messages

### Thanks Clippy

<csr-read-only-do-not-edit/>

[Clippy](https://github.com/rust-lang/rust-clippy) helped 1 time to make code idiomatic. 

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - (cargo-release) version 0.1.1 ([`e583f70`](https://github.com//Byron/gitoxide/commit/e583f70947803b5b6885a4eb22cd515263177b5b))
    - thanks clippy ([`17258cc`](https://github.com//Byron/gitoxide/commit/17258cc58767caa6e71227898decd160ad0cdf13))
    - TODO's about 'Iterator::reduce()' are probably not applicable ([`ac1a433`](https://github.com//Byron/gitoxide/commit/ac1a4333612c7ef238b84d15a194d4bc4685cd3a))
    - Thank cargo-doc ([`ca96be1`](https://github.com//Byron/gitoxide/commit/ca96be1654a175606a4af6032b2ace4875334231))
    - [git-config] Finish cleaning up 1.51 clippy lints ([`aec7240`](https://github.com//Byron/gitoxide/commit/aec7240036750c98796b8ef4075758f6b825d293))
    - [git-config] Fix various 1.51 clippy lints; inline ([`d899df0`](https://github.com//Byron/gitoxide/commit/d899df0d9feec1f38b60be73af80113958dfa7d1))
    - Merge pull request #50 from Byron/edward-shen/odb-zlib-ng ([`acb90d7`](https://github.com//Byron/gitoxide/commit/acb90d755fb02c37f8a5a431778abcbe143fb5e5))
    - [git-config] Fix must_use lints ([`71aff75`](https://github.com//Byron/gitoxide/commit/71aff75d02329caf78c61d3c1dd8ab3c33b8597d))
    - Slim down git-config with cargo-diet ([`1c555e0`](https://github.com//Byron/gitoxide/commit/1c555e04d395eadb6b22639afd41c0892d48fa0d))
    - [git-config] add parse test from git remote ([`63bee9c`](https://github.com//Byron/gitoxide/commit/63bee9c3217689df5fbe36d79857db7cdd349d84))
    - [git-config] Add sections_by_name ([`1f7a533`](https://github.com//Byron/gitoxide/commit/1f7a53357d0f1f2f8164b59e8b276ae61fff552f))
    - [git-config] Add to_owned for parser::Error ([`e316c8c`](https://github.com//Byron/gitoxide/commit/e316c8c7a8864daf2ade0ec8fdf42aa20694805f))
    - [git-config] Add coercion into owned variants ([`6387aea`](https://github.com//Byron/gitoxide/commit/6387aeaefccb2c80f9a276f3a8978be28f23bdfb))
</details>

## v0.1.0 (2021-03-12)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 125 commits contributed to the release over the course of 157 calendar days.
 - 0 commits where understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' where seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - [git-config]: Include benches in crate to allow publishing to work ([`949622e`](https://github.com//Byron/gitoxide/commit/949622e461eb2116393ec6f4633ec0cb2e1695b5))
    - [git-config]: remove clippy-cargo lint until there are no warnings ([`bcacfc9`](https://github.com//Byron/gitoxide/commit/bcacfc9bcf19a0339541b24e84de68d95291c62b))
    - [git-config]: remove redundant lines from git-ignore file ([`41f118d`](https://github.com//Byron/gitoxide/commit/41f118d2aa560188fd3399d2390aa43794b0af75))
    - fix format ([`1655b56`](https://github.com//Byron/gitoxide/commit/1655b56b34618d28f67b1ef08b41c598eaf3530e))
    - remove release-profile ([`3d62449`](https://github.com//Byron/gitoxide/commit/3d62449feed68cef213df31268dfbb9fc54f2d62))
    - rename_section ([`4975fff`](https://github.com//Byron/gitoxide/commit/4975fff3edc67a39bd0046870ac8c572c09d0f78))
    - return key iterator ([`adfa460`](https://github.com//Byron/gitoxide/commit/adfa460f8ae0cdbbe8a3b91e0d0c55e46bb9b9ce))
    - add push_section ([`81271e2`](https://github.com//Byron/gitoxide/commit/81271e24bcf9fc9f7241bbd70d11e0cbbab789a1))
    - more work on sections ([`84e959d`](https://github.com//Byron/gitoxide/commit/84e959da3a19abb451be82d290fa8329ee1df015))
    - remove offset newtype ([`41da7ed`](https://github.com//Byron/gitoxide/commit/41da7edc1b8661e2e3f53b4b061f7e52c9604a06))
    - remove section for owned section type ([`11cf526`](https://github.com//Byron/gitoxide/commit/11cf526769998915e542a93d01023f67b3329fa6))
    - more functionality to mutablesection ([`b0cf849`](https://github.com//Byron/gitoxide/commit/b0cf849f32fb6b0e612efa12f279a6e0bb40d49d))
    - optimize section pushing ([`f409931`](https://github.com//Byron/gitoxide/commit/f4099310dfad85c087bae45a9af2a441569c58fa))
    - section API ([`0aad0f1`](https://github.com//Byron/gitoxide/commit/0aad0f12ed82caa784abde36a9dd4fe2f0cc83bf))
    - section stuct ([`21b4fe1`](https://github.com//Byron/gitoxide/commit/21b4fe11001fa4f09718bc5cacc140a0a97e8ab3))
    - fix example ([`357a761`](https://github.com//Byron/gitoxide/commit/357a76137c8c309b6c16809af32641d1f52a1222))
    - update readme ([`c2fa869`](https://github.com//Byron/gitoxide/commit/c2fa869ffb37180f67c37f2c229b7b26390d6957))
    - fix macro comment gen ([`a19c17f`](https://github.com//Byron/gitoxide/commit/a19c17f6d64bd87ec42ec975a9b4a8e641288816))
    - implement case insensitivity for names ([`c39ff33`](https://github.com//Byron/gitoxide/commit/c39ff332415a7c546af14bf925c9cc5c60b36622))
    - test MutableMultiValue ([`8cfe67d`](https://github.com//Byron/gitoxide/commit/8cfe67df4f322d7ebfee9f5c7de206cacf08f5ed))
    - more tests, fix mutablevalue ([`377532c`](https://github.com//Byron/gitoxide/commit/377532c4b6a3bf2ac8cc3ca7c3c661cfc954a16c))
    - fix lints ([`bb7a544`](https://github.com//Byron/gitoxide/commit/bb7a5445272e8abd825751212762a76e7876e9d1))
    - enable requiring docs ([`68320ca`](https://github.com//Byron/gitoxide/commit/68320ca5ba2d3665bc64580ff9ab12d86b719e56))
    - clippy fix ([`e7bad2e`](https://github.com//Byron/gitoxide/commit/e7bad2eb2633b60f1bf12b7f53dcda1f431172d4))
    - docs ([`a1f833c`](https://github.com//Byron/gitoxide/commit/a1f833ccc7c07b37b5285c109aefaabf9a97f202))
    - add into bytes for gitconfig ([`9b54a5b`](https://github.com//Byron/gitoxide/commit/9b54a5b9df699f2508cf47411293f74252a02473))
    - docs ([`4d7da4e`](https://github.com//Byron/gitoxide/commit/4d7da4e9ef60a90360e51d5425580d9b309db151))
    - mutableevent interface ([`014776f`](https://github.com//Byron/gitoxide/commit/014776f8be482d2d61ef532d1cea84e26a42d893))
    - remove serde code for now ([`fc4ee85`](https://github.com//Byron/gitoxide/commit/fc4ee8585372c023b47c0f28d0c746ff9f8eac5b))
    - disable serde ([`7c01808`](https://github.com//Byron/gitoxide/commit/7c01808c4fdfee35e339c2d939ef6b013b430f38))
    - multablemultivalue ([`faa1b93`](https://github.com//Byron/gitoxide/commit/faa1b9368b8dbcfbef10a3bbb027bdef81a377a0))
    - better test formatting ([`635e5c1`](https://github.com//Byron/gitoxide/commit/635e5c15e39b24767e793e6ab4f230b8913a0760))
    - Add get_multi_value ([`79eeca1`](https://github.com//Byron/gitoxide/commit/79eeca128a3b146e2900cc90f34877cef4fa6e52))
    - check all sections for lookup before failing ([`01b617d`](https://github.com//Byron/gitoxide/commit/01b617d74f10eab8f87e1032aebeeb6f56a2ae10))
    - misc improvements ([`87057c9`](https://github.com//Byron/gitoxide/commit/87057c9f03516d6659cb2cc54f330ba4072d6563))
    - benchmarks ([`b0ff69e`](https://github.com//Byron/gitoxide/commit/b0ff69e9f5260c30ecfd2879b3346437b38cec83))
    - crate level docs ([`a909bcf`](https://github.com//Byron/gitoxide/commit/a909bcf90fa7ad3995fa15f00417257f66ccb6d0))
    - integration tests for value extraction ([`d45af63`](https://github.com//Byron/gitoxide/commit/d45af630ab25cfc3fc9b4b10c5038132f23b5c95))
    - fix drain ([`4f425a7`](https://github.com//Byron/gitoxide/commit/4f425a72cad6b0159e3747ce6a42c4d4343b8e61))
    - use memrchr ([`ccadf89`](https://github.com//Byron/gitoxide/commit/ccadf89aa13051c55debd6aa7c709b138bab6167))
    - use drain instead ([`6e5b67b`](https://github.com//Byron/gitoxide/commit/6e5b67b0d5dec90f22cf05b1597201c8a8b9ab80))
    - use mutablevalue for mut entries ([`13fdda5`](https://github.com//Byron/gitoxide/commit/13fdda5e01cb494f5992be0bb82464392016d4ed))
    - normalize get_raw_value ([`5952cab`](https://github.com//Byron/gitoxide/commit/5952cab59c3aab7f35683f959737a5c8bef29fb1))
    - fix get_raw_value, fix returning refs to cows ([`ba982b9`](https://github.com//Byron/gitoxide/commit/ba982b971aa97eaa17d58d7b00f20923171d89eb))
    - cleanup docs ([`e0a8b8d`](https://github.com//Byron/gitoxide/commit/e0a8b8d808cbed2d7ca902304e6819bfba8f6715))
    - add tests and docs ([`7caf012`](https://github.com//Byron/gitoxide/commit/7caf012b05c6819f5a897918fc50eb61d76517de))
    - rename config mod to file ([`a965ebc`](https://github.com//Byron/gitoxide/commit/a965ebcfc08c71255389c62fe43ff479960e7921))
    - pendantic clippy lints ([`18c9dff`](https://github.com//Byron/gitoxide/commit/18c9dff7c0bde99d4c1d4a7263f86fd4a656d1c0))
    - remove unnecessarily lifetimes ([`7d0e6b4`](https://github.com//Byron/gitoxide/commit/7d0e6b4fe1cb8e3d752cd5b42fa9167b552d6320))
    - use str in most cases ([`9fc8993`](https://github.com//Byron/gitoxide/commit/9fc8993a54950e88aa05b0fe85962ee124a86891))
    - fully comment values ([`8e32d56`](https://github.com//Byron/gitoxide/commit/8e32d5609d81087e17a5dcd15dbe7ed22594aa50))
    - more normalize docs ([`9767b5b`](https://github.com//Byron/gitoxide/commit/9767b5be5a4d45c44e2aba6c2164c800e17ec437))
    - collaspe if block ([`1cf1f3b`](https://github.com//Byron/gitoxide/commit/1cf1f3be284afb1b0ed3d8f06439a5effc553be0))
    - better doc ([`ec63ce6`](https://github.com//Byron/gitoxide/commit/ec63ce633578af6adf6239d76f5802aaa842941c))
    - implement unquoting in normalize ([`7e8ae93`](https://github.com//Byron/gitoxide/commit/7e8ae932f888707fe7466e93ef6c8289749d04d2))
    - add normalize ([`6c245dc`](https://github.com//Byron/gitoxide/commit/6c245dc654bfd7bc6b82226abd900ba2e8a312cd))
    - dedup multivar docs ([`236d37b`](https://github.com//Byron/gitoxide/commit/236d37b608b8a912fc005c956c87d251172fff0f))
    - add todo ([`bc63005`](https://github.com//Byron/gitoxide/commit/bc630057c6f138647f2f8a2d93f8a09e4f4494c3))
    - Implement get_value for GitConfig ([`ca7c1dc`](https://github.com//Byron/gitoxide/commit/ca7c1dca5539bf71e524ba0ee4b40c60bd80f0ad))
    - Use traits instead of from_str ([`ce9b7bf`](https://github.com//Byron/gitoxide/commit/ce9b7bfbb9abe5e74dbef1d3c637876e7d996e52))
    - Use traits instead of shadowing from_str ([`a4ce9b0`](https://github.com//Byron/gitoxide/commit/a4ce9b04012060ab06dabd6658f3e518f994831b))
    - remove falsevariant ([`e10a4a2`](https://github.com//Byron/gitoxide/commit/e10a4a298371b6641e6184fa8d61bebe8c783923))
    - more tests ([`24a2dfd`](https://github.com//Byron/gitoxide/commit/24a2dfd2d7dd0c1b28b62b7dbebeb539e086016e))
    - remove unreachable variants ([`93b85e3`](https://github.com//Byron/gitoxide/commit/93b85e38ff46f0f8fdaabcf2c7210bb9e0421254))
    - use mut vec reference ([`8b68fdb`](https://github.com//Byron/gitoxide/commit/8b68fdb2aeac6dd7211f31333489012647e65f55))
    - Don't use mutex ([`4027daf`](https://github.com//Byron/gitoxide/commit/4027daf93bb931d9b839057b88afcfa849a4ed8c))
    - documented parsererror ([`0c226ad`](https://github.com//Byron/gitoxide/commit/0c226ad112f7ff70dee20669419ba8f7eae3f0c7))
    - clippy fixes ([`8618c22`](https://github.com//Byron/gitoxide/commit/8618c2233abada5fb101258cffc8c046b155134b))
    - don't use stack for error handling ([`819a1d3`](https://github.com//Byron/gitoxide/commit/819a1d3a0bf47c95dc469c7bbf80b3452ef9918d))
    - very rough error handling ([`45d5250`](https://github.com//Byron/gitoxide/commit/45d52502fb91635f3db3d4b09f69f5d7b2a29e09))
    - add error trait impl for ParserError ([`d173b4b`](https://github.com//Byron/gitoxide/commit/d173b4bcc855365640d8931460d0bed748264817))
    - Basic error reporting ([`f293334`](https://github.com//Byron/gitoxide/commit/f293334d984755053b532706134df88a5c57a43f))
    - move fully_sumed to test_util ([`41245eb`](https://github.com//Byron/gitoxide/commit/41245ebd74a0ee40bbc91a2e2f9bca670da02b16))
    - Don't immediately drop fuzzer values ([`568d360`](https://github.com//Byron/gitoxide/commit/568d36084f2c4f94a4757588ca17078ce523a6ac))
    - Add more fields to cargo.toml ([`89791fd`](https://github.com//Byron/gitoxide/commit/89791fd0f3bba9d22418302fe862896a6ccacdc4))
    - Add basic fuzzer ([`cf41bb3`](https://github.com//Byron/gitoxide/commit/cf41bb300fe8213a7b4b02329cd987fd55d2ac9c))
    - add from_bytes variants for parser ([`954f433`](https://github.com//Byron/gitoxide/commit/954f4338e7496208b1e8b13a105eec9f5c07ba76))
    - exclude fuzz folder from cargo ([`afe4ac7`](https://github.com//Byron/gitoxide/commit/afe4ac754f0843d8350504200a2a833bf158c335))
    - add tests for boolean ([`0353033`](https://github.com//Byron/gitoxide/commit/03530334a956e4337d3e92d2bb1a2be5c0278014))
    - Use lto and single codegen unit for release ([`53077bd`](https://github.com//Byron/gitoxide/commit/53077bda06aeed84b3985f941e7f4660b5e0d5e8))
    - select nom features ([`79dc19f`](https://github.com//Byron/gitoxide/commit/79dc19f7a7517f0953a1b14b180e54cfe110bab8))
    - make serde optional, clippy lints ([`5defc4a`](https://github.com//Byron/gitoxide/commit/5defc4a64a9ee37910c2caa9f23253adead1ab6f))
    - Add ColorValue tests ([`5b7cc13`](https://github.com//Byron/gitoxide/commit/5b7cc13e62aff1014369aa7a8d64dc9eaad1f0cd))
    - Add tests for ColorAttribute ([`0cc9cd6`](https://github.com//Byron/gitoxide/commit/0cc9cd6bd1d383bbca97610f6a1a67119a90ab56))
    - Fix docs ([`b0fc08b`](https://github.com//Byron/gitoxide/commit/b0fc08b940dbca8d6b78f29f5d4e391c8b535121))
    - Use BStr instead ([`ec2602c`](https://github.com//Byron/gitoxide/commit/ec2602cfce2867ed341a1bff5e26ca82785a4434))
    - Add key-value delimination event ([`df0da82`](https://github.com//Byron/gitoxide/commit/df0da822d23708cc488027c0830895f0274ad9ce))
    - gitconfig writing to string ([`b59a51a`](https://github.com//Byron/gitoxide/commit/b59a51af3896ba510c30db1044a11472df7d3998))
    - document multivar behavior better ([`e43518e`](https://github.com//Byron/gitoxide/commit/e43518ebdadd739bd4edc90cd4ef279000b4f94e))
    - Use Cow instead of strs ([`ff8ee4a`](https://github.com//Byron/gitoxide/commit/ff8ee4a0352ad7fb8a2c93c0e09f5b3b2c15d3a9))
    - Implement get_mut for gitconfig ([`1d8e58b`](https://github.com//Byron/gitoxide/commit/1d8e58b6008c36141ba38fd37bfbbbdb458b35ef))
    - remove meme comment ([`897450c`](https://github.com//Byron/gitoxide/commit/897450c2e7d89388072d806d4646e1bbac4df422))
    - test get_raw_values ([`0ea6210`](https://github.com//Byron/gitoxide/commit/0ea62105abd84b3b73996f8809772b6856fab6fa))
    - finish raw value queries for gitconfig ([`4b7f218`](https://github.com//Byron/gitoxide/commit/4b7f21875ee12a86c56c2942f2981a79993a3a2a))
    - Handle empty git-config file for parser ([`a516885`](https://github.com//Byron/gitoxide/commit/a5168857071db604f3b2e7191ed749bcdb0354af))
    - fully document parser ([`f66e0be`](https://github.com//Byron/gitoxide/commit/f66e0bedff4c7ba9d455bd7e4d24d299b21fb109))
    - completely refactor config ([`b820d6c`](https://github.com//Byron/gitoxide/commit/b820d6c987263251575844547298e69ddb52d8c4))
    - Booleans now retain original value ([`8ea467e`](https://github.com//Byron/gitoxide/commit/8ea467e01e7e231827041ada0c531f7a3e66715f))
    - parser is now perfect ([`3f708ec`](https://github.com//Byron/gitoxide/commit/3f708ecadee910aebc007fdba1aae004e3344104))
    - more work on parser ([`2691756`](https://github.com//Byron/gitoxide/commit/26917564cf007949ee7f71ee48e10be1efb6f6a0))
    - more work ([`eb07890`](https://github.com//Byron/gitoxide/commit/eb07890347fda7c24721ea91fca5a2eaa519d5b3))
    - Complete initial parser ([`d721625`](https://github.com//Byron/gitoxide/commit/d72162555cc677c4ff143d01f338fc4508a7b11e))
    - Deny rust-2018-idioms ([`a4d2a4b`](https://github.com//Byron/gitoxide/commit/a4d2a4b248f0f22ffd6c8c567d780a152831347a))
    - Add remaining docs for all types in 'git-config' crate ([`b7790b4`](https://github.com//Byron/gitoxide/commit/b7790b4ce3884daaff198890f4a8fb36c38f2230))
    - more planning for config parser implementation ([`9676db9`](https://github.com//Byron/gitoxide/commit/9676db9f58b5776986cfd7185a0ade93f89cb080))
    - Add missing '.' at end of doc comments ([`7136854`](https://github.com//Byron/gitoxide/commit/71368544f97369a4d371d43513607c4805bd0fd0))
    - Signal the compiler that configuration edits must be used ([`14b17e4`](https://github.com//Byron/gitoxide/commit/14b17e4d202fae2eeabfe46552a1c0b17e30ac9c))
    - better docs for git-config; name method for Entry ([`5ab4bdb`](https://github.com//Byron/gitoxide/commit/5ab4bdbc3f1760bcb667d9a1b26eb069084581eb))
    - refactor; more comments ([`8d933cb`](https://github.com//Byron/gitoxide/commit/8d933cbd08977ad0dc70ed18b37e7e06ab24c4fb))
    - time-constrained write-down of some high-level concepts of git-config structures ([`157fa2a`](https://github.com//Byron/gitoxide/commit/157fa2a31e0382ee2c8524ff7862873787f5f648))
    - cargo clippy Rust 1.48 ([`475a68c`](https://github.com//Byron/gitoxide/commit/475a68ce33b895de911939c51afa159df534f7b8))
    - a path towards making config Files editable ([`bc008c3`](https://github.com//Byron/gitoxide/commit/bc008c32a16849a212eced783aa14727765004c3))
    - additional setters for more fluid edits ([`5a54dae`](https://github.com//Byron/gitoxide/commit/5a54dae6470c5dcf48bf96c16c5bbe2a8951be6a))
    - sketch out editing lossless of Files ([`8f00063`](https://github.com//Byron/gitoxide/commit/8f00063bc9b6a63ffe44e58945be55acca40a714))
    - Skip comments as well ([`32cc684`](https://github.com//Byron/gitoxide/commit/32cc6849444c16a3d2917c6de62e47597c9979da))
    - Stop entry iteration when next section is encountered ([`83a1b83`](https://github.com//Byron/gitoxide/commit/83a1b83a1f7a0ff22850efc7b5b460f0c1ed8230))
    - sketch of iteration over sections and entries ([`acb8947`](https://github.com//Byron/gitoxide/commit/acb894762b38f77d21e6d70936727cf0daeaff6f))
    - sketch out section and entries access ([`06679d9`](https://github.com//Byron/gitoxide/commit/06679d9b69575183231ddb22edd89ab29357632d))
    - refactor ([`b5fa727`](https://github.com//Byron/gitoxide/commit/b5fa727403a78e5f9238dd36d8b071eec425d731))
    - Turn off 'unused' warnings for experimental git-config crate ([`0b52eb0`](https://github.com//Byron/gitoxide/commit/0b52eb0e75a268c5c7b6475677fd20acace3435b))
    - Revert "remove git-config from workspace while it's so fresh…" ([`99214f4`](https://github.com//Byron/gitoxide/commit/99214f4c1097fa8da8f14f1279caf00db78fa822))
    - remove git-config from workspace while it's so fresh… ([`84e0d19`](https://github.com//Byron/gitoxide/commit/84e0d19ab2285916cb6a6b941ec2206aef485d56))
    - Plan how to deal with whitespace and comments to be lossless ([`eb5a534`](https://github.com//Byron/gitoxide/commit/eb5a534340396429d7c2c95e71b0a23457d954f4))
    - refactor ([`3846bab`](https://github.com//Byron/gitoxide/commit/3846bab8c7ae53e5528388522bf4571260ec4ae6))
    - very first sketch of types for read-only git config ([`e2a39c9`](https://github.com//Byron/gitoxide/commit/e2a39c96a96b3ec9de519c685fe9caddeb89342c))
</details>

## v0.0.0 (2020-10-05)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 1 commit contributed to the release.
 - 0 commits where understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' where seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - stub for git-config crate ([`3539531`](https://github.com//Byron/gitoxide/commit/3539531adb06e8f59609f0a83e8ed94d0864c0a1))
</details>

