use gfaR::Gfa;
use std::collections::{HashMap, HashSet};

pub fn meanNodeSize(graph: &Gfa) -> f32 {
    let mut numb: u32 = 0;
    let mut tsize: u32 = 0;
    for x in &graph.nodes{
        numb += 1;
        tsize += x.1.len as u32;

    }
    let mean: f32 = (tsize as f32)/(numb as f32);
    mean
}

pub fn graphSize(graph: &Gfa) -> u32 {
    let mut tsize: u32= 0;
    for x in &graph.nodes{
        tsize += x.1.len as u32;
    }
    tsize
}

pub fn inputGenomes(graph: &Gfa) -> u32 {
    let mut tsze: u32 = 0;

    for x in &graph.paths{
        for y in &x.nodes{
            tsze += graph.nodes[y].len as u32;
        }
    }
    tsze
}

pub fn nodeDegree(graph: &Gfa) -> (f32, f32, f32){
    let mut h: HashMap<&u32, u32> = HashMap::new();
    for x in graph.edges.iter(){
        if h.contains_key(&x.from){
            h.insert(&x.from, h[&x.from]  +1 );

        } else {
            h.insert(&x.from, 1);
        }
    }

    let mut h2: HashMap<&u32, u32> = HashMap::new();
    for x in graph.edges.iter(){
        if h2.contains_key(&x.to){
            h2.insert(&x.to, h[&x.to]  +1 );

        } else {
            h2.insert(&x.to, 1);
        }
    }

    let hs1 = hashmap2(&h2);
    let hs2 = hashmap2(&h);

    (hs1, hs2, hs2)
}


pub fn hashmap2(hs: &HashMap<&u32, u32>) -> f32{
    let mut umax: u32 =0;
    let mut ucout: u32= 0;
    for (x, y) in hs.iter(){
        ucout += 1;
        umax += y;
    }
    let ff = umax as f32/ucout as f32;
    ff
}

pub fn invEdges(graph: &Gfa) -> u32{
    let mut tt =0;
    for x in graph.edges.iter(){
        if !x.from_dir{
            tt += 1;
        }
        if !x.to_dir{
            tt += 1;
        }

    }
    tt
}