use crate::Galois;

pub(crate) const PRIMITIVE_POLYNOMIAL: usize = 0b100011101;
pub(crate) const FIELD_SIZE: usize = 1 << 8;

pub(crate) const LOG_TABLE: [u8; 256] = [
    0, 0, 1, 25, 2, 50, 26, 198, 3, 223, 51, 238, 27, 104, 199, 75, 4, 100, 224, 14, 52, 141, 239,
    129, 28, 193, 105, 248, 200, 8, 76, 113, 5, 138, 101, 47, 225, 36, 15, 33, 53, 147, 142, 218,
    240, 18, 130, 69, 29, 181, 194, 125, 106, 39, 249, 185, 201, 154, 9, 120, 77, 228, 114, 166, 6,
    191, 139, 98, 102, 221, 48, 253, 226, 152, 37, 179, 16, 145, 34, 136, 54, 208, 148, 206, 143,
    150, 219, 189, 241, 210, 19, 92, 131, 56, 70, 64, 30, 66, 182, 163, 195, 72, 126, 110, 107, 58,
    40, 84, 250, 133, 186, 61, 202, 94, 155, 159, 10, 21, 121, 43, 78, 212, 229, 172, 115, 243,
    167, 87, 7, 112, 192, 247, 140, 128, 99, 13, 103, 74, 222, 237, 49, 197, 254, 24, 227, 165,
    153, 119, 38, 184, 180, 124, 17, 68, 146, 217, 35, 32, 137, 46, 55, 63, 209, 91, 149, 188, 207,
    205, 144, 135, 151, 178, 220, 252, 190, 97, 242, 86, 211, 171, 20, 42, 93, 158, 132, 60, 57,
    83, 71, 109, 65, 162, 31, 45, 67, 216, 183, 123, 164, 118, 196, 23, 73, 236, 127, 12, 111, 246,
    108, 161, 59, 82, 41, 157, 85, 170, 251, 96, 134, 177, 187, 204, 62, 90, 203, 89, 95, 176, 156,
    169, 160, 81, 11, 245, 22, 235, 122, 117, 44, 215, 79, 174, 213, 233, 230, 231, 173, 232, 116,
    214, 244, 234, 168, 80, 88, 175,
];

pub(crate) const EXP_TABLE: [Galois; 256] = [
    Galois(1),
    Galois(2),
    Galois(4),
    Galois(8),
    Galois(16),
    Galois(32),
    Galois(64),
    Galois(128),
    Galois(29),
    Galois(58),
    Galois(116),
    Galois(232),
    Galois(205),
    Galois(135),
    Galois(19),
    Galois(38),
    Galois(76),
    Galois(152),
    Galois(45),
    Galois(90),
    Galois(180),
    Galois(117),
    Galois(234),
    Galois(201),
    Galois(143),
    Galois(3),
    Galois(6),
    Galois(12),
    Galois(24),
    Galois(48),
    Galois(96),
    Galois(192),
    Galois(157),
    Galois(39),
    Galois(78),
    Galois(156),
    Galois(37),
    Galois(74),
    Galois(148),
    Galois(53),
    Galois(106),
    Galois(212),
    Galois(181),
    Galois(119),
    Galois(238),
    Galois(193),
    Galois(159),
    Galois(35),
    Galois(70),
    Galois(140),
    Galois(5),
    Galois(10),
    Galois(20),
    Galois(40),
    Galois(80),
    Galois(160),
    Galois(93),
    Galois(186),
    Galois(105),
    Galois(210),
    Galois(185),
    Galois(111),
    Galois(222),
    Galois(161),
    Galois(95),
    Galois(190),
    Galois(97),
    Galois(194),
    Galois(153),
    Galois(47),
    Galois(94),
    Galois(188),
    Galois(101),
    Galois(202),
    Galois(137),
    Galois(15),
    Galois(30),
    Galois(60),
    Galois(120),
    Galois(240),
    Galois(253),
    Galois(231),
    Galois(211),
    Galois(187),
    Galois(107),
    Galois(214),
    Galois(177),
    Galois(127),
    Galois(254),
    Galois(225),
    Galois(223),
    Galois(163),
    Galois(91),
    Galois(182),
    Galois(113),
    Galois(226),
    Galois(217),
    Galois(175),
    Galois(67),
    Galois(134),
    Galois(17),
    Galois(34),
    Galois(68),
    Galois(136),
    Galois(13),
    Galois(26),
    Galois(52),
    Galois(104),
    Galois(208),
    Galois(189),
    Galois(103),
    Galois(206),
    Galois(129),
    Galois(31),
    Galois(62),
    Galois(124),
    Galois(248),
    Galois(237),
    Galois(199),
    Galois(147),
    Galois(59),
    Galois(118),
    Galois(236),
    Galois(197),
    Galois(151),
    Galois(51),
    Galois(102),
    Galois(204),
    Galois(133),
    Galois(23),
    Galois(46),
    Galois(92),
    Galois(184),
    Galois(109),
    Galois(218),
    Galois(169),
    Galois(79),
    Galois(158),
    Galois(33),
    Galois(66),
    Galois(132),
    Galois(21),
    Galois(42),
    Galois(84),
    Galois(168),
    Galois(77),
    Galois(154),
    Galois(41),
    Galois(82),
    Galois(164),
    Galois(85),
    Galois(170),
    Galois(73),
    Galois(146),
    Galois(57),
    Galois(114),
    Galois(228),
    Galois(213),
    Galois(183),
    Galois(115),
    Galois(230),
    Galois(209),
    Galois(191),
    Galois(99),
    Galois(198),
    Galois(145),
    Galois(63),
    Galois(126),
    Galois(252),
    Galois(229),
    Galois(215),
    Galois(179),
    Galois(123),
    Galois(246),
    Galois(241),
    Galois(255),
    Galois(227),
    Galois(219),
    Galois(171),
    Galois(75),
    Galois(150),
    Galois(49),
    Galois(98),
    Galois(196),
    Galois(149),
    Galois(55),
    Galois(110),
    Galois(220),
    Galois(165),
    Galois(87),
    Galois(174),
    Galois(65),
    Galois(130),
    Galois(25),
    Galois(50),
    Galois(100),
    Galois(200),
    Galois(141),
    Galois(7),
    Galois(14),
    Galois(28),
    Galois(56),
    Galois(112),
    Galois(224),
    Galois(221),
    Galois(167),
    Galois(83),
    Galois(166),
    Galois(81),
    Galois(162),
    Galois(89),
    Galois(178),
    Galois(121),
    Galois(242),
    Galois(249),
    Galois(239),
    Galois(195),
    Galois(155),
    Galois(43),
    Galois(86),
    Galois(172),
    Galois(69),
    Galois(138),
    Galois(9),
    Galois(18),
    Galois(36),
    Galois(72),
    Galois(144),
    Galois(61),
    Galois(122),
    Galois(244),
    Galois(245),
    Galois(247),
    Galois(243),
    Galois(251),
    Galois(235),
    Galois(203),
    Galois(139),
    Galois(11),
    Galois(22),
    Galois(44),
    Galois(88),
    Galois(176),
    Galois(125),
    Galois(250),
    Galois(233),
    Galois(207),
    Galois(131),
    Galois(27),
    Galois(54),
    Galois(108),
    Galois(216),
    Galois(173),
    Galois(71),
    Galois(142),
    Galois(0),
];
