use std::collections::HashMap;

pub fn get_types<'a>() -> HashMap<&'a str, u64> {
    return [
        ("aerialway.cable_car", 0),
        ("aerialway.canopy", 1),
        ("aerialway.chair_lift", 2),
        ("aerialway.drag_lift", 3),
        ("aerialway.gondola", 4),
        ("aerialway.goods", 5),
        ("aerialway.j-bar", 6),
        ("aerialway.magic_carpet", 7),
        ("aerialway.mixed_lift", 8),
        ("aerialway.other", 9),
        ("aerialway.platter", 10),
        ("aerialway.pylon", 11),
        ("aerialway.rope_tow", 12),
        ("aerialway.station", 13),
        ("aerialway.t-bar", 14),
        ("aerialway.zip_line", 15),
        ("aeroway.aerodrome", 16),
        ("aeroway.apron", 17),
        ("aeroway.gate", 18),
        ("aeroway.hangar", 19),
        ("aeroway.helipad", 20),
        ("aeroway.heliport", 21),
        ("aeroway.navigationaid", 22),
        ("aeroway.runway", 23),
        ("aeroway.spaceport", 24),
        ("aeroway.taxiway", 25),
        ("aeroway.terminal", 26),
        ("aeroway.windsock", 27),
        ("amenity.animal_boarding", 28),
        ("amenity.animal_shelter", 29),
        ("amenity.arts_centre", 30),
        ("amenity.atm", 31),
        ("amenity.baby_hatch", 32),
        ("amenity.baking_oven", 33),
        ("amenity.bank", 34),
        ("amenity.bar", 35),
        ("amenity.bbq", 36),
        ("amenity.bench", 37),
        ("amenity.bicycle_parking", 38),
        ("amenity.bicycle_rental", 39),
        ("amenity.bicycle_repair_station", 40),
        ("amenity.biergarten", 41),
        ("amenity.boat_rental", 42),
        ("amenity.boat_sharing", 43),
        ("amenity.brothel", 44),
        ("amenity.bureau_de_change", 45),
        ("amenity.bus_station", 46),
        ("amenity.cafe", 47),
        ("amenity.car_rental", 48),
        ("amenity.car_sharing", 49),
        ("amenity.car_wash", 50),
        ("amenity.casino", 51),
        ("amenity.charging_station", 52),
        ("amenity.childcare", 53),
        ("amenity.cinema", 54),
        ("amenity.clinic", 55),
        ("amenity.clock", 56),
        ("amenity.college", 57),
        ("amenity.community_centre", 58),
        ("amenity.conference_centre", 59),
        ("amenity.courthouse", 60),
        ("amenity.coworking_space", 61),
        ("amenity.crematorium", 62),
        ("amenity.crypt", 63),
        ("amenity.dentist", 64),
        ("amenity.dive_centre", 65),
        ("amenity.doctors", 66),
        ("amenity.dojo", 67),
        ("amenity.drinking_water", 68),
        ("amenity.driving_school", 69),
        ("amenity.embassy", 70),
        ("amenity.fast food", 71),
        ("amenity.ferry_terminal", 72),
        ("amenity.fire_station", 73),
        ("amenity.firepit", 74),
        ("amenity.food_court", 75),
        ("amenity.fountain", 76),
        ("amenity.fuel", 77),
        ("amenity.gambling", 78),
        ("amenity.game_feeding", 79),
        ("amenity.give_box", 80),
        ("amenity.grave_yard", 81),
        ("amenity.grit_bin", 82),
        ("amenity.gym", 83),
        ("amenity.hospital", 84),
        ("amenity.hunting_stand", 85),
        ("amenity.ice_cream", 86),
        ("amenity.internet_cafe", 87),
        ("amenity.kindergarten", 88),
        ("amenity.kitchen", 89),
        ("amenity.kneipp_water_cure", 90),
        ("amenity.language_school", 91),
        ("amenity.library", 92),
        ("amenity.marketplace", 93),
        ("amenity.monastery", 94),
        ("amenity.motorcycle_parking", 95),
        ("amenity.music_school", 96),
        ("amenity.nightclub", 97),
        ("amenity.nursing_home", 98),
        ("amenity.other", 99),
        ("amenity.parking", 100),
        ("amenity.parking_entrance", 101),
        ("amenity.parking_space", 102),
        ("amenity.pharmacy", 103),
        ("amenity.photo_booth", 104),
        ("amenity.place_of_worship", 105),
        ("amenity.planetarium", 106),
        ("amenity.police", 107),
        ("amenity.post_box", 108),
        ("amenity.post_office", 109),
        ("amenity.prison", 110),
        ("amenity.pub", 111),
        ("amenity.public_bookcase", 112),
        ("amenity.public_building", 113),
        ("amenity.ranger_station", 114),
        ("amenity.recycling", 115),
        ("amenity.refugee_site", 116),
        ("amenity.rescue_station", 117),
        ("amenity.restaurant", 118),
        ("amenity.sanitary_dump_station", 119),
        ("amenity.sauna", 120),
        ("amenity.school", 121),
        ("amenity.shelter", 122),
        ("amenity.shower", 123),
        ("amenity.social_centre", 124),
        ("amenity.social_facility", 125),
        ("amenity.stripclub", 126),
        ("amenity.stripclub| amenity=stripclub", 127),
        ("amenity.studio", 128),
        ("amenity.swingerclub", 129),
        ("amenity.table", 130),
        ("amenity.taxi", 131),
        ("amenity.telephone", 132),
        ("amenity.theatre", 133),
        ("amenity.toilets", 134),
        ("amenity.townhall", 135),
        ("amenity.toy_library", 136),
        ("amenity.university", 137),
        ("amenity.vehicle_inspection", 138),
        ("amenity.vending_machine", 139),
        ("amenity.veterinary", 140),
        ("amenity.waste_basket", 141),
        ("amenity.waste_disposal", 142),
        ("amenity.waste_transfer_station", 143),
        ("amenity.water_point", 144),
        ("amenity.watering_place", 145),
        ("barrier.block", 146),
        ("barrier.bollard", 147),
        ("barrier.border_control", 148),
        ("barrier.bump_gate", 149),
        ("barrier.bus_trap", 150),
        ("barrier.cable_barrier", 151),
        ("barrier.cattle_grid", 152),
        ("barrier.chain", 153),
        ("barrier.city_wall", 154),
        ("barrier.cycle_barrier", 155),
        ("barrier.debris", 156),
        ("barrier.ditch", 157),
        ("barrier.entrance", 158),
        ("barrier.fence", 159),
        ("barrier.full-height_turnstile", 160),
        ("barrier.gate", 161),
        ("barrier.guard_rail", 162),
        ("barrier.hampshire_gate", 163),
        ("barrier.handrail", 164),
        ("barrier.hedge", 165),
        ("barrier.height_restrictor", 166),
        ("barrier.horse_stile", 167),
        ("barrier.jersey_barrier", 168),
        ("barrier.kent_carriage_gap", 169),
        ("barrier.kerb", 170),
        ("barrier.kissing_gate", 171),
        ("barrier.lift_gate", 172),
        ("barrier.log", 173),
        ("barrier.motorcycle_barrier", 174),
        ("barrier.other", 175),
        ("barrier.retaining_wall", 176),
        ("barrier.rope", 177),
        ("barrier.sally_port", 178),
        ("barrier.spikes", 179),
        ("barrier.stile", 180),
        ("barrier.sump_buster", 181),
        ("barrier.swing_gate", 182),
        ("barrier.tank_trap", 183),
        ("barrier.toll_booth", 184),
        ("barrier.turnstile", 185),
        ("barrier.wall", 186),
        ("barrier.yes", 187),
        ("border_type.baseline", 188),
        ("border_type.contiguous", 189),
        ("border_type.eez", 190),
        ("border_type.territorial", 191),
        ("boundary.aboriginal_lands", 192),
        ("boundary.administrative", 193),
        ("boundary.historic", 194),
        ("boundary.maritime", 195),
        ("boundary.marker", 196),
        ("boundary.national_park", 197),
        ("boundary.other", 198),
        ("boundary.political", 199),
        ("boundary.postal_code", 200),
        ("boundary.protected_area", 201),
        ("boundary.religious_administration", 202),
        ("building.apartments", 203),
        ("building.bakehouse", 204),
        ("building.barn", 205),
        ("building.bridge", 206),
        ("building.bungalow", 207),
        ("building.bunker", 208),
        ("building.cabin", 209),
        ("building.carport", 210),
        ("building.cathedral", 211),
        ("building.chapel", 212),
        ("building.church", 213),
        ("building.civic", 214),
        ("building.commercial", 215),
        ("building.conservatory", 216),
        ("building.construction", 217),
        ("building.cowshed", 218),
        ("building.detached", 219),
        ("building.digester", 220),
        ("building.dormitory", 221),
        ("building.farm", 222),
        ("building.farm_auxiliary", 223),
        ("building.fire_station", 224),
        ("building.garage", 225),
        ("building.garages", 226),
        ("building.ger", 227),
        ("building.government", 228),
        ("building.grandstand", 229),
        ("building.greenhouse", 230),
        ("building.hangar", 231),
        ("building.hospital", 232),
        ("building.hotel", 233),
        ("building.house", 234),
        ("building.houseboat", 235),
        ("building.hut", 236),
        ("building.industrial", 237),
        ("building.kindergarten", 238),
        ("building.kiosk", 239),
        ("building.mosque", 240),
        ("building.office", 241),
        ("building.other", 242),
        ("building.parking", 243),
        ("building.pavilion", 244),
        ("building.public", 245),
        ("building.religious", 246),
        ("building.residential", 247),
        ("building.retail", 248),
        ("building.riding_hall", 249),
        ("building.roof", 250),
        ("building.ruins", 251),
        ("building.school", 252),
        ("building.semidetached_house", 253),
        ("building.service", 254),
        ("building.shed", 255),
        ("building.shrine", 256),
        ("building.sports_hall", 257),
        ("building.stable", 258),
        ("building.stadium", 259),
        ("building.static_caravan", 260),
        ("building.sty", 261),
        ("building.supermarket", 262),
        ("building.synagogue", 263),
        ("building.temple", 264),
        ("building.terrace", 265),
        ("building.toilets", 266),
        ("building.train_station", 267),
        ("building.transformer_tower", 268),
        ("building.transportation", 269),
        ("building.tree_house", 270),
        ("building.university", 271),
        ("building.warehouse", 272),
        ("building.water_tower", 273),
        ("building.yes", 274),
        ("busway.lane", 275),
        ("communication.line", 276),
        ("craft.agricultural_engines", 277),
        ("craft.atelier", 278),
        ("craft.bakery", 279),
        ("craft.basket_maker", 280),
        ("craft.beekeeper", 281),
        ("craft.blacksmith", 282),
        ("craft.boatbuilder", 283),
        ("craft.bookbinder", 284),
        ("craft.brewery", 285),
        ("craft.builder", 286),
        ("craft.cabinet_maker", 287),
        ("craft.car_painter", 288),
        ("craft.carpenter", 289),
        ("craft.carpet_layer", 290),
        ("craft.caterer", 291),
        ("craft.chimney_sweeper", 292),
        ("craft.clockmaker", 293),
        ("craft.confectionary", 294),
        ("craft.cooper", 295),
        ("craft.dental_technician", 296),
        ("craft.distillery", 297),
        ("craft.door_construction", 298),
        ("craft.dressmaker", 299),
        ("craft.electrician", 300),
        ("craft.electronics_repair", 301),
        ("craft.embroiderer", 302),
        ("craft.engraver", 303),
        ("craft.floorer", 304),
        ("craft.gardener", 305),
        ("craft.glaziery", 306),
        ("craft.grinding_mill", 307),
        ("craft.handicraft", 308),
        ("craft.hvac", 309),
        ("craft.insulation", 310),
        ("craft.jeweller", 311),
        ("craft.joiner", 312),
        ("craft.key_cutter", 313),
        ("craft.locksmith", 314),
        ("craft.metal_construction", 315),
        ("craft.mint", 316),
        ("craft.musical_instrument", 317),
        ("craft.oil_mill", 318),
        ("craft.optician", 319),
        ("craft.organ_builder", 320),
        ("craft.other", 321),
        ("craft.painter", 322),
        ("craft.parquet_layer", 323),
        ("craft.photographer", 324),
        ("craft.photographic_laboratory", 325),
        ("craft.piano_tuner", 326),
        ("craft.plasterer", 327),
        ("craft.plumber", 328),
        ("craft.pottery", 329),
        ("craft.printer", 330),
        ("craft.printmaker", 331),
        ("craft.rigger", 332),
        ("craft.roofer", 333),
        ("craft.saddler", 334),
        ("craft.sailmaker", 335),
        ("craft.sawmill", 336),
        ("craft.scaffolder", 337),
        ("craft.sculptor", 338),
        ("craft.shoemaker", 339),
        ("craft.signmaker", 340),
        ("craft.stand_builder", 341),
        ("craft.stonemason", 342),
        ("craft.sun_protection", 343),
        ("craft.tailor", 344),
        ("craft.tiler", 345),
        ("craft.tinsmith", 346),
        ("craft.toolmaker", 347),
        ("craft.turner", 348),
        ("craft.upholsterer", 349),
        ("craft.watchmaker", 350),
        ("craft.water_well_drilling", 351),
        ("craft.window_construction", 352),
        ("craft.winery", 353),
        ("cycleway.lane", 354),
        ("cycleway.opposite", 355),
        ("cycleway.opposite_lane", 356),
        ("cycleway.opposite_share_busway", 357),
        ("cycleway.opposite_track", 358),
        ("cycleway.share_busway", 359),
        ("cycleway.shared_lane", 360),
        ("cycleway.track", 361),
        ("emergecy.dry_riser_inlet", 362),
        ("emergency.ambulance_station", 363),
        ("emergency.assembly_point", 364),
        ("emergency.defibrillator", 365),
        ("emergency.drinking_water", 366),
        ("emergency.emergency_ward_entrance", 367),
        ("emergency.fire_alarm_box", 368),
        ("emergency.fire_extinguisher", 369),
        ("emergency.fire_hydrant", 370),
        ("emergency.firehose", 371),
        ("emergency.landing_site", 372),
        ("emergency.life_ring", 373),
        ("emergency.lifeguard", 374),
        ("emergency.lifeguard_base", 375),
        ("emergency.lifeguard_platform", 376),
        ("emergency.lifeguard_tower", 377),
        ("emergency.other", 378),
        ("emergency.phone", 379),
        ("emergency.siren", 380),
        ("emergency.suction_point", 381),
        ("emergency.water_tank", 382),
        ("geological.moraine", 383),
        ("geological.other", 384),
        ("geological.outcrop", 385),
        ("geological.palaeontological_site", 386),
        ("highway.bridleway", 387),
        ("highway.bus_guideway", 388),
        ("highway.bus_stop", 389),
        ("highway.construction", 390),
        ("highway.corridor", 391),
        ("highway.crossing", 392),
        ("highway.cycleway", 393),
        ("highway.elevator", 394),
        ("highway.emergency_access_point", 395),
        ("highway.escape", 396),
        ("highway.footway", 397),
        ("highway.give_way", 398),
        ("highway.living_street", 399),
        ("highway.mini_roundabout", 400),
        ("highway.motorway", 401),
        ("highway.motorway_junction", 402),
        ("highway.motorway_link", 403),
        ("highway.other", 404),
        ("highway.passing_place", 405),
        ("highway.path", 406),
        ("highway.pedestrian", 407),
        ("highway.primary", 408),
        ("highway.primary_link", 409),
        ("highway.proposed", 410),
        ("highway.raceway", 411),
        ("highway.residential", 412),
        ("highway.rest_area", 413),
        ("highway.road", 414),
        ("highway.secondary", 415),
        ("highway.secondary_link", 416),
        ("highway.service", 417),
        ("highway.services", 418),
        ("highway.speed_camera", 419),
        ("highway.steps", 420),
        ("highway.stop", 421),
        ("highway.street_lamp", 422),
        ("highway.tertiary", 423),
        ("highway.tertiary_link", 424),
        ("highway.toll_gantry", 425),
        ("highway.track", 426),
        ("highway.traffic_mirror", 427),
        ("highway.traffic_signals", 428),
        ("highway.trailhead", 429),
        ("highway.trunk", 430),
        ("highway.trunk_link", 431),
        ("highway.turning_circle", 432),
        ("highway.turning_loop", 433),
        ("highway.unclassified", 434),
        ("historic.aircraft", 435),
        ("historic.aqueduct", 436),
        ("historic.archaeological_site", 437),
        ("historic.battlefield", 438),
        ("historic.boundary_stone", 439),
        ("historic.building", 440),
        ("historic.cannon", 441),
        ("historic.castle", 442),
        ("historic.castle_wall", 443),
        ("historic.church", 444),
        ("historic.city_gate", 445),
        ("historic.citywalls", 446),
        ("historic.farm", 447),
        ("historic.fort", 448),
        ("historic.gallows", 449),
        ("historic.highwater_mark", 450),
        ("historic.locomotive", 451),
        ("historic.manor", 452),
        ("historic.memorial", 453),
        ("historic.milestone", 454),
        ("historic.monastery", 455),
        ("historic.monument", 456),
        ("historic.optical_telegraph", 457),
        ("historic.other", 458),
        ("historic.pillory", 459),
        ("historic.railway_car", 460),
        ("historic.ruins", 461),
        ("historic.rune_stone", 462),
        ("historic.ship", 463),
        ("historic.tank", 464),
        ("historic.tomb", 465),
        ("historic.tower", 466),
        ("historic.tree_shrine", 467),
        ("historic.wayside_cross", 468),
        ("historic.wayside_shrine", 469),
        ("historic.wreck", 470),
        ("historic.yes", 471),
        ("landuse.allotments", 472),
        ("landuse.basin", 473),
        ("landuse.brownfield", 474),
        ("landuse.cemetery", 475),
        ("landuse.commercial", 476),
        ("landuse.conservation", 477),
        ("landuse.construction", 478),
        ("landuse.depot", 479),
        ("landuse.farmland", 480),
        ("landuse.farmyard", 481),
        ("landuse.forest", 482),
        ("landuse.garages", 483),
        ("landuse.grass", 484),
        ("landuse.greenfield", 485),
        ("landuse.greenhouse_horticulture", 486),
        ("landuse.industrial", 487),
        ("landuse.landfill", 488),
        ("landuse.meadow", 489),
        ("landuse.military", 490),
        ("landuse.orchard", 491),
        ("landuse.other", 492),
        ("landuse.pasture", 493),
        ("landuse.peat_cutting", 494),
        ("landuse.plant_nursery", 495),
        ("landuse.port", 496),
        ("landuse.quarry", 497),
        ("landuse.railway", 498),
        ("landuse.recreation_ground", 499),
        ("landuse.religious", 500),
        ("landuse.reservoir", 501),
        ("landuse.residential", 502),
        ("landuse.retail", 503),
        ("landuse.salt_pond", 504),
        ("landuse.village_green", 505),
        ("landuse.vineyard", 506),
        ("leisure.adult_gaming_centre", 507),
        ("leisure.amusement_arcade", 508),
        ("leisure.bandstand", 509),
        ("leisure.bird_hide", 510),
        ("leisure.common", 511),
        ("leisure.dance", 512),
        ("leisure.disc_golf_course", 513),
        ("leisure.dog_park", 514),
        ("leisure.escape_game", 515),
        ("leisure.firepit", 516),
        ("leisure.fishing", 517),
        ("leisure.fitness_centre", 518),
        ("leisure.garden", 519),
        ("leisure.hackerspace", 520),
        ("leisure.horse_riding", 521),
        ("leisure.ice_rink", 522),
        ("leisure.marina", 523),
        ("leisure.miniature_golf", 524),
        ("leisure.nature_reserve", 525),
        ("leisure.other", 526),
        ("leisure.park", 527),
        ("leisure.picnic_table", 528),
        ("leisure.pitch", 529),
        ("leisure.playground", 530),
        ("leisure.slipway", 531),
        ("leisure.sports_centre", 532),
        ("leisure.stadium", 533),
        ("leisure.summer_camp", 534),
        ("leisure.swimming_area", 535),
        ("leisure.swimming_pool", 536),
        ("leisure.track", 537),
        ("leisure.water_park", 538),
        ("lesure.beach_resort", 539),
        ("line.bay", 540),
        ("line.busbar", 541),
        ("man_made.adit", 542),
        ("man_made.beacon", 543),
        ("man_made.breakwater", 544),
        ("man_made.bridge", 545),
        ("man_made.bunker_silo", 546),
        ("man_made.carpet_hanger", 547),
        ("man_made.chimney", 548),
        ("man_made.clearcut", 549),
        ("man_made.communications_tower", 550),
        ("man_made.crane", 551),
        ("man_made.cross", 552),
        ("man_made.cutline", 553),
        ("man_made.dovecote", 554),
        ("man_made.dyke", 555),
        ("man_made.embankment", 556),
        ("man_made.flagpole", 557),
        ("man_made.gasometer", 558),
        ("man_made.goods_conveyor", 559),
        ("man_made.groyne", 560),
        ("man_made.kiln", 561),
        ("man_made.lighthouse", 562),
        ("man_made.mast", 563),
        ("man_made.mineshaft", 564),
        ("man_made.monitoring_station", 565),
        ("man_made.obelisk", 566),
        ("man_made.observatory", 567),
        ("man_made.offshore_platform", 568),
        ("man_made.other", 569),
        ("man_made.petroleum_well", 570),
        ("man_made.pier", 571),
        ("man_made.pipeline", 572),
        ("man_made.pumping_station", 573),
        ("man_made.reservoir_covered", 574),
        ("man_made.silo", 575),
        ("man_made.snow_fence", 576),
        ("man_made.snow_net", 577),
        ("man_made.storage_tank", 578),
        ("man_made.street_cabinet", 579),
        ("man_made.surveillance", 580),
        ("man_made.survey_point", 581),
        ("man_made.telescope", 582),
        ("man_made.tower", 583),
        ("man_made.wastewater_plant", 584),
        ("man_made.water_tap", 585),
        ("man_made.water_tower", 586),
        ("man_made.water_well", 587),
        ("man_made.water_works", 588),
        ("man_made.watermill", 589),
        ("man_made.wildlife_crossing", 590),
        ("man_made.windmill", 591),
        ("man_made.works", 592),
        ("military.airfield", 593),
        ("military.barracks", 594),
        ("military.bunker", 595),
        ("military.checkpoint", 596),
        ("military.danger_area", 597),
        ("military.naval_base", 598),
        ("military.nuclear_explosion_site", 599),
        ("military.obstacle_course", 600),
        ("military.office", 601),
        ("military.other", 602),
        ("military.range", 603),
        ("military.training_area", 604),
        ("military.trench", 605),
        ("natural.arete", 606),
        ("natural.bare_rock", 607),
        ("natural.bay", 608),
        ("natural.beach", 609),
        ("natural.blowhole", 610),
        ("natural.cape", 611),
        ("natural.cave_entrance", 612),
        ("natural.cliff", 613),
        ("natural.coastline", 614),
        ("natural.dune", 615),
        ("natural.fell", 616),
        ("natural.geyser", 617),
        ("natural.glacier", 618),
        ("natural.grassland", 619),
        ("natural.heath", 620),
        ("natural.hot_spring", 621),
        ("natural.isthmus", 622),
        ("natural.moor", 623),
        ("natural.mud", 624),
        ("natural.other", 625),
        ("natural.peak", 626),
        ("natural.peninsula", 627),
        ("natural.reef", 628),
        ("natural.ridge", 629),
        ("natural.rock", 630),
        ("natural.saddle", 631),
        ("natural.sand", 632),
        ("natural.scree", 633),
        ("natural.scrub", 634),
        ("natural.shingle", 635),
        ("natural.sinkhole", 636),
        ("natural.spring", 637),
        ("natural.stone", 638),
        ("natural.strait", 639),
        ("natural.tree", 640),
        ("natural.tree_row", 641),
        ("natural.valley", 642),
        ("natural.volcano", 643),
        ("natural.water", 644),
        ("natural.wetland", 645),
        ("natural.wood", 646),
        ("office.accountant", 647),
        ("office.adoption_agency", 648),
        ("office.advertising_agency", 649),
        ("office.architect", 650),
        ("office.association", 651),
        ("office.bail_bond_agent", 652),
        ("office.charity", 653),
        ("office.company", 654),
        ("office.consulting", 655),
        ("office.coworking", 656),
        ("office.diplomatic", 657),
        ("office.educational_institution", 658),
        ("office.employment_agency", 659),
        ("office.energy_supplier", 660),
        ("office.engineer", 661),
        ("office.estate_agent", 662),
        ("office.financial", 663),
        ("office.forestry", 664),
        ("office.foundation", 665),
        ("office.gedesist", 666),
        ("office.government", 667),
        ("office.graphic_design", 668),
        ("office.guide", 669),
        ("office.harbour_master", 670),
        ("office.insurance", 671),
        ("office.it", 672),
        ("office.lawyer", 673),
        ("office.logistics", 674),
        ("office.moving_company", 675),
        ("office.newspaper", 676),
        ("office.ngo", 677),
        ("office.notary", 678),
        ("office.other", 679),
        ("office.political_party", 680),
        ("office.private_investigator", 681),
        ("office.property_management", 682),
        ("office.quango", 683),
        ("office.religion", 684),
        ("office.research", 685),
        ("office.security", 686),
        ("office.surveyor", 687),
        ("office.tax", 688),
        ("office.tax_advisor", 689),
        ("office.telecommunication", 690),
        ("office.union", 691),
        ("office.visa", 692),
        ("office.water_utility", 693),
        ("place.allotments", 694),
        ("place.archipelago", 695),
        ("place.borough", 696),
        ("place.city", 697),
        ("place.city_block", 698),
        ("place.continent", 699),
        ("place.country", 700),
        ("place.county", 701),
        ("place.district", 702),
        ("place.farm", 703),
        ("place.hamlet", 704),
        ("place.island", 705),
        ("place.islet", 706),
        ("place.isolated_dwelling", 707),
        ("place.locality", 708),
        ("place.municipality", 709),
        ("place.neighbourhood", 710),
        ("place.ocean", 711),
        ("place.other", 712),
        ("place.plot", 713),
        ("place.province", 714),
        ("place.quarter", 715),
        ("place.region", 716),
        ("place.sea", 717),
        ("place.square", 718),
        ("place.state", 719),
        ("place.suburb", 720),
        ("place.town", 721),
        ("place.village", 722),
        ("power.cable", 723),
        ("power.catenary_mast", 724),
        ("power.compensator", 725),
        ("power.converter", 726),
        ("power.generator", 727),
        ("power.heliostat", 728),
        ("power.insulator", 729),
        ("power.line", 730),
        ("power.minor_line", 731),
        ("power.other", 732),
        ("power.plant", 733),
        ("power.pole", 734),
        ("power.portal", 735),
        ("power.substation", 736),
        ("power.switchgear", 737),
        ("power.terminal", 738),
        ("power.tower", 739),
        ("power.transformer", 740),
        ("public_transport.other", 741),
        ("public_transport.platform", 742),
        ("public_transport.station", 743),
        ("public_transport.stop_area", 744),
        ("public_transport.stop_position", 745),
        ("railway.abandoned", 746),
        ("railway.buffer_stop", 747),
        ("railway.construction", 748),
        ("railway.crossing", 749),
        ("railway.derail", 750),
        ("railway.disused", 751),
        ("railway.funicular", 752),
        ("railway.halt", 753),
        ("railway.level_crossing", 754),
        ("railway.light_rail", 755),
        ("railway.miniature", 756),
        ("railway.monorail", 757),
        ("railway.narrow_gauge", 758),
        ("railway.other", 759),
        ("railway.platform", 760),
        ("railway.preserved", 761),
        ("railway.rail", 762),
        ("railway.railway_crossing", 763),
        ("railway.roundhouse", 764),
        ("railway.signal", 765),
        ("railway.station", 766),
        ("railway.subway", 767),
        ("railway.subway_entrance", 768),
        ("railway.switch", 769),
        ("railway.tram", 770),
        ("railway.tram_stop", 771),
        ("railway.traverser", 772),
        ("railway.turntable", 773),
        ("railway.wash", 774),
        ("route.bicycle", 775),
        ("route.bus", 776),
        ("route.canoe", 777),
        ("route.detour", 778),
        ("route.ferry", 779),
        ("route.foot", 780),
        ("route.hiking", 781),
        ("route.horse", 782),
        ("route.inline_skates", 783),
        ("route.light_rail", 784),
        ("route.mtb", 785),
        ("route.other", 786),
        ("route.piste", 787),
        ("route.power", 788),
        ("route.railway", 789),
        ("route.road", 790),
        ("route.running", 791),
        ("route.ski", 792),
        ("route.subway", 793),
        ("route.tracks", 794),
        ("route.train", 795),
        ("route.tram", 796),
        ("route.trolleybus", 797),
        ("seamark:type.anchor_berth", 798),
        ("seamark:type.anchorage", 799),
        ("seamark:type.beacon_cardinal", 800),
        ("seamark:type.beacon_isolated_danger", 801),
        ("seamark:type.beacon_lateral", 802),
        ("seamark:type.beacon_safe_water", 803),
        ("seamark:type.beacon_special_purpose", 804),
        ("seamark:type.berth", 805),
        ("seamark:type.bridge", 806),
        ("seamark:type.building", 807),
        ("seamark:type.bunker_station", 808),
        ("seamark:type.buoy_cardinal", 809),
        ("seamark:type.buoy_installation", 810),
        ("seamark:type.buoy_isolated_danger", 811),
        ("seamark:type.buoy_lateral", 812),
        ("seamark:type.buoy_safe_water", 813),
        ("seamark:type.buoy_special_purpose", 814),
        ("seamark:type.cable_area", 815),
        ("seamark:type.cable_overhead", 816),
        ("seamark:type.cable_submarine", 817),
        ("seamark:type.calling-in_point", 818),
        ("seamark:type.causeway", 819),
        ("seamark:type.checkpoint", 820),
        ("seamark:type.coastguard_station", 821),
        ("seamark:type.communication_area", 822),
        ("seamark:type.control_point", 823),
        ("seamark:type.daymark", 824),
        ("seamark:type.distance_mark", 825),
        ("seamark:type.dredged_area", 826),
        ("seamark:type.dumping_ground", 827),
        ("seamark:type.exceptional_structure", 828),
        ("seamark:type.fairway", 829),
        ("seamark:type.ferry_route", 830),
        ("seamark:type.fishing_facility", 831),
        ("seamark:type.fog_signal", 832),
        ("seamark:type.fortified_structure", 833),
        ("seamark:type.gate", 834),
        ("seamark:type.gridirom", 835),
        ("seamark:type.harbour", 836),
        ("seamark:type.harbour_basin", 837),
        ("seamark:type.hulk", 838),
        ("seamark:type.inshore_traffic_zone", 839),
        ("seamark:type.landmark", 840),
        ("seamark:type.light", 841),
        ("seamark:type.light_float", 842),
        ("seamark:type.light_major", 843),
        ("seamark:type.light_minor", 844),
        ("seamark:type.light_vessel", 845),
        ("seamark:type.lock_basin", 846),
        ("seamark:type.marine_farm", 847),
        ("seamark:type.military_area", 848),
        ("seamark:type.mooring", 849),
        ("seamark:type.navigation_line", 850),
        ("seamark:type.notice", 851),
        ("seamark:type.obstruction", 852),
        ("seamark:type.oil_barrier", 853),
        ("seamark:type.pile", 854),
        ("seamark:type.pilot_boarding", 855),
        ("seamark:type.pipeline_area", 856),
        ("seamark:type.pipeline_overhead", 857),
        ("seamark:type.pipeline_submarine", 858),
        ("seamark:type.platform", 859),
        ("seamark:type.pontoon", 860),
        ("seamark:type.precautionary_area", 861),
        ("seamark:type.production_area", 862),
        ("seamark:type.protected_area", 863),
        ("seamark:type.pylon", 864),
        ("seamark:type.radar_line", 865),
        ("seamark:type.radar_range", 866),
        ("seamark:type.radar_reflector", 867),
        ("seamark:type.radar_station", 868),
        ("seamark:type.radar_transponder", 869),
        ("seamark:type.radio_station", 870),
        ("seamark:type.recommended_route_centreline", 871),
        ("seamark:type.recommended_track", 872),
        ("seamark:type.recommended_traffic_lane", 873),
        ("seamark:type.rescue_station", 874),
        ("seamark:type.restricted_area", 875),
        ("seamark:type.retro_reflector", 876),
        ("seamark:type.rock", 877),
        ("seamark:type.sand_waves", 878),
        ("seamark:type.sea_area", 879),
        ("seamark:type.seabed_area", 880),
        ("seamark:type.seaplane_landing_area", 881),
        ("seamark:type.separation_boundary", 882),
        ("seamark:type.separation_crossing", 883),
        ("seamark:type.separation_lane", 884),
        ("seamark:type.separation_line", 885),
        ("seamark:type.separation_roundabout", 886),
        ("seamark:type.separation_zone", 887),
        ("seamark:type.shoreline_construction", 888),
        ("seamark:type.signal_station_traffic", 889),
        ("seamark:type.signal_station_warning", 890),
        ("seamark:type.small_craft_facility", 891),
        ("seamark:type.spring", 892),
        ("seamark:type.submarine_transit_lane", 893),
        ("seamark:type.tank", 894),
        ("seamark:type.topmark", 895),
        ("seamark:type.turning_basin", 896),
        ("seamark:type.two-way_route", 897),
        ("seamark:type.vegetation", 898),
        ("seamark:type.vehicle_transfer", 899),
        ("seamark:type.virtual_aton", 900),
        ("seamark:type.wall", 901),
        ("seamark:type.water_turbulence", 902),
        ("seamark:type.waterway_gauge", 903),
        ("seamark:type.weed", 904),
        ("seamark:type.wreck", 905),
        ("shop.agrarian", 906),
        ("shop.alcohol", 907),
        ("shop.anime", 908),
        ("shop.antiques", 909),
        ("shop.appliance", 910),
        ("shop.art", 911),
        ("shop.atv", 912),
        ("shop.baby_goods", 913),
        ("shop.bag", 914),
        ("shop.bakery", 915),
        ("shop.bathroom_furnishing", 916),
        ("shop.beauty", 917),
        ("shop.bed", 918),
        ("shop.beverages", 919),
        ("shop.bicycle", 920),
        ("shop.boat", 921),
        ("shop.bookmaker", 922),
        ("shop.books", 923),
        ("shop.boutique", 924),
        ("shop.brewing_supplies", 925),
        ("shop.butcher", 926),
        ("shop.camera", 927),
        ("shop.candles", 928),
        ("shop.cannabis", 929),
        ("shop.car", 930),
        ("shop.car_parts", 931),
        ("shop.car_repair", 932),
        ("shop.caravan", 933),
        ("shop.carpet", 934),
        ("shop.charity", 935),
        ("shop.cheese", 936),
        ("shop.chemist", 937),
        ("shop.chocolate", 938),
        ("shop.clothes", 939),
        ("shop.coffee", 940),
        ("shop.collector", 941),
        ("shop.computer", 942),
        ("shop.confectionery", 943),
        ("shop.convenience", 944),
        ("shop.copyshop", 945),
        ("shop.cosmetics", 946),
        ("shop.craft", 947),
        ("shop.curtain", 948),
        ("shop.dairy", 949),
        ("shop.deli", 950),
        ("shop.department_store", 951),
        ("shop.doityourself", 952),
        ("shop.doors", 953),
        ("shop.dry_cleaning", 954),
        ("shop.e-cigarette", 955),
        ("shop.electrical", 956),
        ("shop.electronics", 957),
        ("shop.energy", 958),
        ("shop.erotic", 959),
        ("shop.fabric", 960),
        ("shop.farm", 961),
        ("shop.fashion", 962),
        ("shop.fashion_accessories", 963),
        ("shop.fireplace", 964),
        ("shop.fishing", 965),
        ("shop.flooring", 966),
        ("shop.florist", 967),
        ("shop.frame", 968),
        ("shop.free_flying", 969),
        ("shop.frozen_food", 970),
        ("shop.fuel", 971),
        ("shop.funeral_directors", 972),
        ("shop.furniture", 973),
        ("shop.games", 974),
        ("shop.garden_centre", 975),
        ("shop.garden_furniture", 976),
        ("shop.gas", 977),
        ("shop.general", 978),
        ("shop.gift", 979),
        ("shop.glaziery", 980),
        ("shop.golf", 981),
        ("shop.greengrocer", 982),
        ("shop.hairdresser", 983),
        ("shop.hairdresser_supply", 984),
        ("shop.hardware", 985),
        ("shop.health_food", 986),
        ("shop.hearing_aids", 987),
        ("shop.herbalist", 988),
        ("shop.hifi", 989),
        ("shop.household_linen", 990),
        ("shop.houseware", 991),
        ("shop.hunting", 992),
        ("shop.ice_cream", 993),
        ("shop.interior_decoration", 994),
        ("shop.jetski", 995),
        ("shop.jewelry", 996),
        ("shop.kiosk", 997),
        ("shop.kitchen", 998),
        ("shop.lamps", 999),
        ("shop.laundry", 1000),
        ("shop.leather", 1001),
        ("shop.lighting", 1002),
        ("shop.locksmith", 1003),
        ("shop.lottery", 1004),
        ("shop.mall", 1005),
        ("shop.massage", 1006),
        ("shop.medical_supply", 1007),
        ("shop.military_surplus", 1008),
        ("shop.mobile_phone", 1009),
        ("shop.model", 1010),
        ("shop.money_lender", 1011),
        ("shop.motorcycle", 1012),
        ("shop.music", 1013),
        ("shop.musical_instrument", 1014),
        ("shop.newsagent", 1015),
        ("shop.nutrition_supplements", 1016),
        ("shop.optician", 1017),
        ("shop.organic", 1018),
        ("shop.other", 1019),
        ("shop.outdoor", 1020),
        ("shop.outpost", 1021),
        ("shop.paint", 1022),
        ("shop.party", 1023),
        ("shop.pasta", 1024),
        ("shop.pastry", 1025),
        ("shop.pawnbroker", 1026),
        ("shop.perfumery", 1027),
        ("shop.pest_control", 1028),
        ("shop.pet", 1029),
        ("shop.pet_grooming", 1030),
        ("shop.photo", 1031),
        ("shop.pyrotechnics", 1032),
        ("shop.radiotechnics", 1033),
        ("shop.religion", 1034),
        ("shop.robot", 1035),
        ("shop.scuba_diving", 1036),
        ("shop.seafood", 1037),
        ("shop.second_hand", 1038),
        ("shop.security", 1039),
        ("shop.sewing", 1040),
        ("shop.shoes", 1041),
        ("shop.ski", 1042),
        ("shop.snowmobile", 1043),
        ("shop.spices", 1044),
        ("shop.sports", 1045),
        ("shop.stationery", 1046),
        ("shop.storage_rental", 1047),
        ("shop.supermarket", 1048),
        ("shop.swimming_pool", 1049),
        ("shop.tailor", 1050),
        ("shop.tattoo", 1051),
        ("shop.tea", 1052),
        ("shop.ticket", 1053),
        ("shop.tiles", 1054),
        ("shop.tobacco", 1055),
        ("shop.toys", 1056),
        ("shop.trade", 1057),
        ("shop.trailer", 1058),
        ("shop.travel_agency", 1059),
        ("shop.trophy", 1060),
        ("shop.tyres", 1061),
        ("shop.vacant", 1062),
        ("shop.vacuum_cleaner", 1063),
        ("shop.variety_store", 1064),
        ("shop.video", 1065),
        ("shop.video_games", 1066),
        ("shop.watches", 1067),
        ("shop.water", 1068),
        ("shop.weapons", 1069),
        ("shop.wholesale", 1070),
        ("shop.window_blind", 1071),
        ("shop.wine", 1072),
        ("shop.wool", 1073),
        ("sport.10pin", 1074),
        ("sport.9pin", 1075),
        ("sport.aikido", 1076),
        ("sport.american_football", 1077),
        ("sport.archery", 1078),
        ("sport.athletics", 1079),
        ("sport.australian_football", 1080),
        ("sport.badminton", 1081),
        ("sport.bandy", 1082),
        ("sport.baseball", 1083),
        ("sport.basketball", 1084),
        ("sport.beachvolleyball", 1085),
        ("sport.biathlon", 1086),
        ("sport.billiards", 1087),
        ("sport.bmx", 1088),
        ("sport.bobsleigh", 1089),
        ("sport.boules", 1090),
        ("sport.bowls", 1091),
        ("sport.boxing", 1092),
        ("sport.bullfighting", 1093),
        ("sport.canadian_football", 1094),
        ("sport.canoe", 1095),
        ("sport.chess", 1096),
        ("sport.cliff_diving", 1097),
        ("sport.climbing", 1098),
        ("sport.climbing_adventure", 1099),
        ("sport.cockfighting", 1100),
        ("sport.cricket", 1101),
        ("sport.croquet", 1102),
        ("sport.crossfit", 1103),
        ("sport.curling", 1104),
        ("sport.cycling", 1105),
        ("sport.darts", 1106),
        ("sport.diving", 1107),
        ("sport.dog_agility", 1108),
        ("sport.dog_racing", 1109),
        ("sport.equestrian", 1110),
        ("sport.fencing", 1111),
        ("sport.field_hockey", 1112),
        ("sport.fitness", 1113),
        ("sport.floorball", 1114),
        ("sport.football", 1115),
        ("sport.free_flying", 1116),
        ("sport.futsal", 1117),
        ("sport.gaelic_games", 1118),
        ("sport.golf", 1119),
        ("sport.gymnastics", 1120),
        ("sport.handball", 1121),
        ("sport.hapkido", 1122),
        ("sport.hockey", 1123),
        ("sport.horse_racing", 1124),
        ("sport.horseshoes", 1125),
        ("sport.ice_hockey", 1126),
        ("sport.ice_skating", 1127),
        ("sport.ice_stock", 1128),
        ("sport.judo", 1129),
        ("sport.karate", 1130),
        ("sport.karting", 1131),
        ("sport.kickboxing", 1132),
        ("sport.kitesurfing", 1133),
        ("sport.korfball", 1134),
        ("sport.krachtbal", 1135),
        ("sport.lacrosse", 1136),
        ("sport.martial_arts", 1137),
        ("sport.miniature_golf", 1138),
        ("sport.model_aerodrome", 1139),
        ("sport.motocross", 1140),
        ("sport.motor", 1141),
        ("sport.multi", 1142),
        ("sport.netball", 1143),
        ("sport.obstacle_course", 1144),
        ("sport.orienteering", 1145),
        ("sport.other", 1146),
        ("sport.paddle_tennis", 1147),
        ("sport.padel", 1148),
        ("sport.parachuting", 1149),
        ("sport.paragliding", 1150),
        ("sport.parkour", 1151),
        ("sport.pelota", 1152),
        ("sport.pesäpallo", 1153),
        ("sport.pickleball", 1154),
        ("sport.pilates", 1155),
        ("sport.racquet", 1156),
        ("sport.rc_car", 1157),
        ("sport.roller_skating", 1158),
        ("sport.rowing", 1159),
        ("sport.rugby_league", 1160),
        ("sport.rugby_union", 1161),
        ("sport.running", 1162),
        ("sport.safety_training", 1163),
        ("sport.sailing", 1164),
        ("sport.scuba_diving", 1165),
        ("sport.shooting", 1166),
        ("sport.shot-put", 1167),
        ("sport.skateboard", 1168),
        ("sport.skating", 1169),
        ("sport.ski_jumping", 1170),
        ("sport.skiing", 1171),
        ("sport.snooker", 1172),
        ("sport.soccer", 1173),
        ("sport.speedway", 1174),
        ("sport.squash", 1175),
        ("sport.sumo", 1176),
        ("sport.surfing", 1177),
        ("sport.swimming", 1178),
        ("sport.table_soccer", 1179),
        ("sport.table_tennis", 1180),
        ("sport.taekwondo", 1181),
        ("sport.tennis", 1182),
        ("sport.toboggan", 1183),
        ("sport.ultimate", 1184),
        ("sport.volleyball", 1185),
        ("sport.wakeboarding", 1186),
        ("sport.water_polo", 1187),
        ("sport.water_ski", 1188),
        ("sport.weightlifting", 1189),
        ("sport.wrestling", 1190),
        ("sport.yoga", 1191),
        ("telecom.connection_point", 1192),
        ("telecom.data_center", 1193),
        ("telecom.distribution_point", 1194),
        ("telecom.exchange", 1195),
        ("telecom.other", 1196),
        ("telecom.service_device", 1197),
        ("tourism.alpine_hut", 1198),
        ("tourism.apartment", 1199),
        ("tourism.aquarium", 1200),
        ("tourism.artwork", 1201),
        ("tourism.attraction", 1202),
        ("tourism.camp_pitch", 1203),
        ("tourism.camp_site", 1204),
        ("tourism.caravan_site", 1205),
        ("tourism.chalet", 1206),
        ("tourism.gallery", 1207),
        ("tourism.guest_house", 1208),
        ("tourism.hostel", 1209),
        ("tourism.hotel", 1210),
        ("tourism.information", 1211),
        ("tourism.motel", 1212),
        ("tourism.museum", 1213),
        ("tourism.other", 1214),
        ("tourism.picnic_site", 1215),
        ("tourism.theme_park", 1216),
        ("tourism.viewpoint", 1217),
        ("tourism.wilderness_hut", 1218),
        ("tourism.zoo", 1219),
        ("waterway.boatyard", 1220),
        ("waterway.canal", 1221),
        ("waterway.dam", 1222),
        ("waterway.ditch", 1223),
        ("waterway.dock", 1224),
        ("waterway.drain", 1225),
        ("waterway.drystream", 1226),
        ("waterway.fairway", 1227),
        ("waterway.fuel", 1228),
        ("waterway.lock_gate", 1229),
        ("waterway.other", 1230),
        ("waterway.pressurised", 1231),
        ("waterway.river", 1232),
        ("waterway.riverbank", 1233),
        ("waterway.stream", 1234),
        ("waterway.tidal_channel", 1235),
        ("waterway.turning_point", 1236),
        ("waterway.wadi", 1237),
        ("waterway.water_point", 1238),
        ("waterway.waterfall", 1239),
        ("waterway.weir", 1240),
    ]
    .iter()
    .map(|tup| (tup.0, tup.1 as u64))
    .collect();
}
