use f32 as dp; // dimension
use crate::cprelude;

use auto_ops::*;
pub struct Point {
    pub x: dp,
    pub y: dp
}
fn square_dp(n: dp) -> dp {
    n.powf(2.0)
}
impl Point {
    pub fn distance_to(&self, other: &Self) -> dp {
        let delta_x = other.x-self.x;
        let delta_y = other.y-self.y;

        (square_dp(delta_x)+square_dp(delta_y))
            .sqrt()
    }
}
impl cprelude::CloseEnough for Point {
    fn is_close_enough_to(&self, other: &Self, tolerance: dp) -> bool {
        self.distance_to(other) <= tolerance
    }
}
impl_op_ex!(+ |a: &Point, b: &Point| -> Point {
    Point {x: a.x+b.x, y: a.y+b.y}
});
impl_op_ex!(- |a: &Point, b: &Point| -> Point {
    a + Point {x: -b.x, y: -b.y}
});