use f32 as dp; // dimension
use crate::cprelude;
use fast_inv_sqrt::InvSqrt32;

pub struct Point {
    x: dp,
    y: dp
}
fn square_dp(n: dp) -> dp {
    n.powf(2.0)
}
impl Point {
    pub fn distance_to(&self, other: &Self) -> dp {
        let delta_x = other.x - self.x;
        let delta_y = other.y - self.y;

        (square_dp(delta_x) + square_dp(delta_y))
            .inv_sqrt32()
    }
}
impl cprelude::CloseEnough for Point {
    fn is_close_enough_to(&self, other: &Self, tolerance: dp) -> bool {
        self.distance_to(other) <= tolerance
    }
}