// This file was generated by gir (https://github.com/gtk-rs/gir)
// from sys/gir
// from sys/girs (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::AccuracyLevel;
use crate::ClientProxy;
use crate::LocationProxy;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GClueSimple")]
    pub struct Simple(Object<ffi::GClueSimple, ffi::GClueSimpleClass>);

    match fn {
        type_ => || ffi::gclue_simple_get_type(),
    }
}

impl Simple {
    //#[doc(alias = "gclue_simple_new_sync")]
    //pub fn new_sync<P: IsA<gio::Cancellable>>(desktop_id: &str, accuracy_level: AccuracyLevel, cancellable: Option<&P>, error: /*Ignored*/Option<glib::Error>) -> Simple {
    //    unsafe { TODO: call ffi:gclue_simple_new_sync() }
    //}

            // rustdoc-stripper-ignore-next
            /// Creates a new builder-pattern struct instance to construct [`Simple`] objects.
            ///
            /// This method returns an instance of [`SimpleBuilder`] which can be used to create [`Simple`] objects.
            pub fn builder() -> SimpleBuilder {
                SimpleBuilder::default()
            }
        

    //#[doc(alias = "gclue_simple_new")]
    //pub fn new<P: IsA<gio::Cancellable>, Q: FnOnce(Result<Simple, /*Ignored*/glib::Error>) + Send + 'static>(desktop_id: &str, accuracy_level: AccuracyLevel, cancellable: Option<&P>, callback: Q) {
    //    unsafe { TODO: call ffi:gclue_simple_new() }
    //}

    //
    //pub fn new_future(desktop_id: &str, accuracy_level: AccuracyLevel) -> Pin<Box_<dyn std::future::Future<Output = Result<Simple, /*Ignored*/glib::Error>> + 'static>> {

        //skip_assert_initialized!();
        //let desktop_id = String::from(desktop_id);
        //Box_::pin(gio::GioFuture::new(&(), move |_obj, cancellable, send| {
        //    Self::new(
        //        &desktop_id,
        //        accuracy_level,
        //        Some(cancellable),
        //        move |res| {
        //            send.resolve(res);
        //        },
        //    );
        //}))
    //}
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
        /// A [builder-pattern] type to construct [`Simple`] objects.
        ///
        /// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct SimpleBuilder {
    accuracy_level: Option<AccuracyLevel>,
    desktop_id: Option<String>,
}

impl SimpleBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`SimpleBuilder`].
    pub fn new() -> Self {
        Self::default()
    }


    // rustdoc-stripper-ignore-next
    /// Build the [`Simple`].
    pub fn build(self) -> Simple {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
if let Some(ref accuracy_level) = self.accuracy_level {
                properties.push(("accuracy-level", accuracy_level));
            }
if let Some(ref desktop_id) = self.desktop_id {
                properties.push(("desktop-id", desktop_id));
            }
        glib::Object::new::<Simple>(&properties)
                .expect("Failed to create an instance of Simple")

    }

    pub fn accuracy_level(mut self, accuracy_level: AccuracyLevel) -> Self {
        self.accuracy_level = Some(accuracy_level);
        self
    }

    pub fn desktop_id(mut self, desktop_id: &str) -> Self {
        self.desktop_id = Some(desktop_id.to_string());
        self
    }
}

pub const NONE_SIMPLE: Option<&Simple> = None;

/// Trait containing all [`struct@Simple`] methods.
///
/// # Implementors
///
/// [`Simple`][struct@crate::Simple]
pub trait SimpleExt: 'static {
    /// Gets the client proxy.
    ///
    /// # Returns
    ///
    /// The client object.
    #[doc(alias = "gclue_simple_get_client")]
    #[doc(alias = "get_client")]
    fn client(&self) -> ClientProxy;

    /// Gets the current location.
    ///
    /// # Returns
    ///
    /// The last known location
    /// as [`Location`][crate::Location].
    #[doc(alias = "gclue_simple_get_location")]
    #[doc(alias = "get_location")]
    fn location(&self) -> LocationProxy;

    #[doc(alias = "client")]
    fn connect_client_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "location")]
    fn connect_location_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Simple>> SimpleExt for O {
    fn client(&self) -> ClientProxy {
        unsafe {
            from_glib_none(ffi::gclue_simple_get_client(self.as_ref().to_glib_none().0))
        }
    }

    fn location(&self) -> LocationProxy {
        unsafe {
            from_glib_none(ffi::gclue_simple_get_location(self.as_ref().to_glib_none().0))
        }
    }

    fn connect_client_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_client_trampoline<P: IsA<Simple>, F: Fn(&P) + 'static>(this: *mut ffi::GClueSimple, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Simple::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::client\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_client_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_location_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_location_trampoline<P: IsA<Simple>, F: Fn(&P) + 'static>(this: *mut ffi::GClueSimple, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Simple::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::location\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_location_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }
}

impl fmt::Display for Simple {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Simple")
    }
}
