// This file was generated by gir (https://github.com/gtk-rs/gir)
// from sys/gir
// from sys/girs (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::Manager;
use glib::object::Cast;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::fmt;

glib::wrapper! {
    #[doc(alias = "GClueManagerSkeleton")]
    pub struct ManagerSkeleton(Object<ffi::GClueManagerSkeleton, ffi::GClueManagerSkeletonClass>) @implements Manager;

    match fn {
        type_ => || ffi::gclue_manager_skeleton_get_type(),
    }
}

impl ManagerSkeleton {
    /// Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager`</link>`.
    ///
    /// # Returns
    ///
    /// The skeleton object.
    #[doc(alias = "gclue_manager_skeleton_new")]
    pub fn new() -> ManagerSkeleton {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gclue_manager_skeleton_new())
        }
    }

            // rustdoc-stripper-ignore-next
            /// Creates a new builder-pattern struct instance to construct [`ManagerSkeleton`] objects.
            ///
            /// This method returns an instance of [`ManagerSkeletonBuilder`] which can be used to create [`ManagerSkeleton`] objects.
            pub fn builder() -> ManagerSkeletonBuilder {
                ManagerSkeletonBuilder::default()
            }
        
}

impl Default for ManagerSkeleton {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
        /// A [builder-pattern] type to construct [`ManagerSkeleton`] objects.
        ///
        /// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct ManagerSkeletonBuilder {
    available_accuracy_level: Option<u32>,
    in_use: Option<bool>,
}

impl ManagerSkeletonBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`ManagerSkeletonBuilder`].
    pub fn new() -> Self {
        Self::default()
    }


    // rustdoc-stripper-ignore-next
    /// Build the [`ManagerSkeleton`].
    pub fn build(self) -> ManagerSkeleton {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
if let Some(ref available_accuracy_level) = self.available_accuracy_level {
                properties.push(("available-accuracy-level", available_accuracy_level));
            }
if let Some(ref in_use) = self.in_use {
                properties.push(("in-use", in_use));
            }
        glib::Object::new::<ManagerSkeleton>(&properties)
                .expect("Failed to create an instance of ManagerSkeleton")

    }

    pub fn available_accuracy_level(mut self, available_accuracy_level: u32) -> Self {
        self.available_accuracy_level = Some(available_accuracy_level);
        self
    }

    pub fn in_use(mut self, in_use: bool) -> Self {
        self.in_use = Some(in_use);
        self
    }
}

pub const NONE_MANAGER_SKELETON: Option<&ManagerSkeleton> = None;

impl fmt::Display for ManagerSkeleton {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("ManagerSkeleton")
    }
}
