// This file was generated by gir (https://github.com/gtk-rs/gir)
// from sys/gir
// from sys/girs (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::Location;
use glib::object::Cast;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::fmt;

glib::wrapper! {
    #[doc(alias = "GClueLocationSkeleton")]
    pub struct LocationSkeleton(Object<ffi::GClueLocationSkeleton, ffi::GClueLocationSkeletonClass>) @implements Location;

    match fn {
        type_ => || ffi::gclue_location_skeleton_get_type(),
    }
}

impl LocationSkeleton {
    /// Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Location.top_of_page">org.freedesktop.GeoClue2.Location`</link>`.
    ///
    /// # Returns
    ///
    /// The skeleton object.
    #[doc(alias = "gclue_location_skeleton_new")]
    pub fn new() -> LocationSkeleton {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gclue_location_skeleton_new())
        }
    }

            // rustdoc-stripper-ignore-next
            /// Creates a new builder-pattern struct instance to construct [`LocationSkeleton`] objects.
            ///
            /// This method returns an instance of [`LocationSkeletonBuilder`] which can be used to create [`LocationSkeleton`] objects.
            pub fn builder() -> LocationSkeletonBuilder {
                LocationSkeletonBuilder::default()
            }
        
}

impl Default for LocationSkeleton {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
        /// A [builder-pattern] type to construct [`LocationSkeleton`] objects.
        ///
        /// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct LocationSkeletonBuilder {
    accuracy: Option<f64>,
    altitude: Option<f64>,
    description: Option<String>,
    heading: Option<f64>,
    latitude: Option<f64>,
    longitude: Option<f64>,
    speed: Option<f64>,
    timestamp: Option<glib::Variant>,
}

impl LocationSkeletonBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`LocationSkeletonBuilder`].
    pub fn new() -> Self {
        Self::default()
    }


    // rustdoc-stripper-ignore-next
    /// Build the [`LocationSkeleton`].
    pub fn build(self) -> LocationSkeleton {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
if let Some(ref accuracy) = self.accuracy {
                properties.push(("accuracy", accuracy));
            }
if let Some(ref altitude) = self.altitude {
                properties.push(("altitude", altitude));
            }
if let Some(ref description) = self.description {
                properties.push(("description", description));
            }
if let Some(ref heading) = self.heading {
                properties.push(("heading", heading));
            }
if let Some(ref latitude) = self.latitude {
                properties.push(("latitude", latitude));
            }
if let Some(ref longitude) = self.longitude {
                properties.push(("longitude", longitude));
            }
if let Some(ref speed) = self.speed {
                properties.push(("speed", speed));
            }
if let Some(ref timestamp) = self.timestamp {
                properties.push(("timestamp", timestamp));
            }
        glib::Object::new::<LocationSkeleton>(&properties)
                .expect("Failed to create an instance of LocationSkeleton")

    }

    pub fn accuracy(mut self, accuracy: f64) -> Self {
        self.accuracy = Some(accuracy);
        self
    }

    pub fn altitude(mut self, altitude: f64) -> Self {
        self.altitude = Some(altitude);
        self
    }

    pub fn description(mut self, description: &str) -> Self {
        self.description = Some(description.to_string());
        self
    }

    pub fn heading(mut self, heading: f64) -> Self {
        self.heading = Some(heading);
        self
    }

    pub fn latitude(mut self, latitude: f64) -> Self {
        self.latitude = Some(latitude);
        self
    }

    pub fn longitude(mut self, longitude: f64) -> Self {
        self.longitude = Some(longitude);
        self
    }

    pub fn speed(mut self, speed: f64) -> Self {
        self.speed = Some(speed);
        self
    }

    pub fn timestamp(mut self, timestamp: &glib::Variant) -> Self {
        self.timestamp = Some(timestamp.clone());
        self
    }
}

pub const NONE_LOCATION_SKELETON: Option<&LocationSkeleton> = None;

impl fmt::Display for LocationSkeleton {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("LocationSkeleton")
    }
}
