<!-- file * -->
<!-- enum AccuracyLevel -->
<!-- struct Client -->
Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Client.top_of_page">org.freedesktop.GeoClue2.Client`</link>`.

# Implements

[`ClientExt`][trait@crate::prelude::ClientExt]
<!-- trait ClientExt -->
Trait containing all [`struct@Client`] methods.

# Implementors

[`ClientProxy`][struct@crate::ClientProxy], [`Client`][struct@crate::Client]
<!-- impl Client::fn interface_info -->
Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Client.top_of_page">org.freedesktop.GeoClue2.Client`</link>` D-Bus interface.

# Returns

A `GDBusInterfaceInfo`. Do not free.
<!-- impl Client::fn override_properties -->
Overrides all `GObject` properties in the [`Client`][crate::Client] interface for a concrete class.
The properties are overridden in the order they are defined.
## `klass`
The class structure for a `GObject` derived class.
## `property_id_begin`
The property id to assign to the first overridden property.

# Returns

The last property id.
<!-- trait ClientExt::fn call_start -->
Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Start">Start()`</link>` D-Bus method on `self`.
When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `g_main_context_push_thread_default()`).
You can then call `gclue_client_call_start_finish()` to get the result of the operation.

See `gclue_client_call_start_sync()` for the synchronous, blocking version of this method.
## `cancellable`
A `GCancellable` or [`None`].
## `callback`
A `GAsyncReadyCallback` to call when the request is satisfied or [`None`].
<!-- trait ClientExt::fn call_start_finish -->
Finishes an operation started with `gclue_client_call_start()`.
## `res`
The `GAsyncResult` obtained from the `GAsyncReadyCallback` passed to `gclue_client_call_start()`.

# Returns

[`true`] if the call succeeded, [`false`] if `error` is set.
<!-- trait ClientExt::fn call_start_sync -->
Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Start">Start()`</link>` D-Bus method on `self`. The calling thread is blocked until a reply is received.

See `gclue_client_call_start()` for the asynchronous version of this method.
## `cancellable`
A `GCancellable` or [`None`].

# Returns

[`true`] if the call succeeded, [`false`] if `error` is set.
<!-- trait ClientExt::fn call_stop -->
Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Stop">Stop()`</link>` D-Bus method on `self`.
When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `g_main_context_push_thread_default()`).
You can then call `gclue_client_call_stop_finish()` to get the result of the operation.

See `gclue_client_call_stop_sync()` for the synchronous, blocking version of this method.
## `cancellable`
A `GCancellable` or [`None`].
## `callback`
A `GAsyncReadyCallback` to call when the request is satisfied or [`None`].
<!-- trait ClientExt::fn call_stop_finish -->
Finishes an operation started with `gclue_client_call_stop()`.
## `res`
The `GAsyncResult` obtained from the `GAsyncReadyCallback` passed to `gclue_client_call_stop()`.

# Returns

[`true`] if the call succeeded, [`false`] if `error` is set.
<!-- trait ClientExt::fn call_stop_sync -->
Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Stop">Stop()`</link>` D-Bus method on `self`. The calling thread is blocked until a reply is received.

See `gclue_client_call_stop()` for the asynchronous version of this method.
## `cancellable`
A `GCancellable` or [`None`].

# Returns

[`true`] if the call succeeded, [`false`] if `error` is set.
<!-- trait ClientExt::fn complete_start -->
Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Start">Start()`</link>` D-Bus method. If you instead want to finish handling an invocation by returning an error, use `g_dbus_method_invocation_return_error()` or similar.

This method will free `invocation`, you cannot use it afterwards.
## `invocation`
A `GDBusMethodInvocation`.
<!-- trait ClientExt::fn complete_stop -->
Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Stop">Stop()`</link>` D-Bus method. If you instead want to finish handling an invocation by returning an error, use `g_dbus_method_invocation_return_error()` or similar.

This method will free `invocation`, you cannot use it afterwards.
## `invocation`
A `GDBusMethodInvocation`.
<!-- trait ClientExt::fn dup_desktop_id -->
Gets a copy of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.DesktopId">"DesktopId"`</link>` D-Bus property.

Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.

# Returns

The property value or [`None`] if the property is not set. The returned value should be freed with `g_free()`.
<!-- trait ClientExt::fn dup_location -->
Gets a copy of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Location">"Location"`</link>` D-Bus property.

Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.

# Returns

The property value or [`None`] if the property is not set. The returned value should be freed with `g_free()`.
<!-- trait ClientExt::fn emit_location_updated -->
Emits the <link linkend="gdbus-signal-org-freedesktop-GeoClue2-Client.LocationUpdated">"LocationUpdated"`</link>` D-Bus signal.
## `arg_old`
Argument to pass with the signal.
## `arg_new`
Argument to pass with the signal.
<!-- trait ClientExt::fn is_active -->
Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Active">"Active"`</link>` D-Bus property.

Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.

# Returns

The property value.
<!-- trait ClientExt::fn desktop_id -->
Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.DesktopId">"DesktopId"`</link>` D-Bus property.

Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.

The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where `self` was constructed. Use [`dup_desktop_id()`][Self::dup_desktop_id()] if on another thread.

# Returns

The property value or [`None`] if the property is not set. Do not free the returned value, it belongs to `self`.
<!-- trait ClientExt::fn distance_threshold -->
Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.DistanceThreshold">"DistanceThreshold"`</link>` D-Bus property.

Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.

# Returns

The property value.
<!-- trait ClientExt::fn location -->
Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Location">"Location"`</link>` D-Bus property.

Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.

The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where `self` was constructed. Use [`dup_location()`][Self::dup_location()] if on another thread.

# Returns

The property value or [`None`] if the property is not set. Do not free the returned value, it belongs to `self`.
<!-- trait ClientExt::fn requested_accuracy_level -->
Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.RequestedAccuracyLevel">"RequestedAccuracyLevel"`</link>` D-Bus property.

Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.

# Returns

The property value.
<!-- trait ClientExt::fn time_threshold -->
Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.TimeThreshold">"TimeThreshold"`</link>` D-Bus property.

Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.

# Returns

The property value.
<!-- trait ClientExt::fn set_active -->
Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Active">"Active"`</link>` D-Bus property to `value`.

Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
## `value`
The value to set.
<!-- trait ClientExt::fn set_desktop_id -->
Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.DesktopId">"DesktopId"`</link>` D-Bus property to `value`.

Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
## `value`
The value to set.
<!-- trait ClientExt::fn set_distance_threshold -->
Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.DistanceThreshold">"DistanceThreshold"`</link>` D-Bus property to `value`.

Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
## `value`
The value to set.
<!-- trait ClientExt::fn set_location -->
Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Location">"Location"`</link>` D-Bus property to `value`.

Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
## `value`
The value to set.
<!-- trait ClientExt::fn set_requested_accuracy_level -->
Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.RequestedAccuracyLevel">"RequestedAccuracyLevel"`</link>` D-Bus property to `value`.

Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
## `value`
The value to set.
<!-- trait ClientExt::fn set_time_threshold -->
Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.TimeThreshold">"TimeThreshold"`</link>` D-Bus property to `value`.

Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
## `value`
The value to set.
<!-- trait ClientExt::fn connect_handle_start -->
Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Start">Start()`</link>` D-Bus method.

If a signal handler returns [`true`], it means the signal handler will handle the invocation (e.g. take a reference to `invocation` and eventually call `gclue_client_complete_start()` or e.g. `g_dbus_method_invocation_return_error()` on it) and no order signal handlers will run. If no signal handler handles the invocation, the `G_DBUS_ERROR_UNKNOWN_METHOD` error is returned.
## `invocation`
A `GDBusMethodInvocation`.

# Returns

`G_DBUS_METHOD_INVOCATION_HANDLED` or [`true`] if the invocation was handled, `G_DBUS_METHOD_INVOCATION_UNHANDLED` or [`false`] to let other signal handlers run.
<!-- trait ClientExt::fn connect_handle_stop -->
Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Stop">Stop()`</link>` D-Bus method.

If a signal handler returns [`true`], it means the signal handler will handle the invocation (e.g. take a reference to `invocation` and eventually call `gclue_client_complete_stop()` or e.g. `g_dbus_method_invocation_return_error()` on it) and no order signal handlers will run. If no signal handler handles the invocation, the `G_DBUS_ERROR_UNKNOWN_METHOD` error is returned.
## `invocation`
A `GDBusMethodInvocation`.

# Returns

`G_DBUS_METHOD_INVOCATION_HANDLED` or [`true`] if the invocation was handled, `G_DBUS_METHOD_INVOCATION_UNHANDLED` or [`false`] to let other signal handlers run.
<!-- trait ClientExt::fn connect_location_updated -->
On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-GeoClue2-Client.LocationUpdated">"LocationUpdated"`</link>` is received.

On the service-side, this signal can be used with e.g. `g_signal_emit_by_name()` to make the object emit the D-Bus signal.
## `arg_old`
Argument.
## `arg_new`
Argument.
<!-- trait ClientExt::fn active -->
Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Active">"Active"`</link>`.

Since the D-Bus property for this `GObject` property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
<!-- struct ClientProxy -->
The [`ClientProxy`][crate::ClientProxy] structure contains only private data and should only be accessed using the provided API.

# Implements

[`ClientExt`][trait@crate::prelude::ClientExt]
<!-- impl ClientProxy::fn new_finish -->
Finishes an operation started with `gclue_client_proxy_new()`.
## `res`
The `GAsyncResult` obtained from the `GAsyncReadyCallback` passed to `gclue_client_proxy_new()`.

# Returns

The constructed proxy object or [`None`] if `error` is set.
<!-- impl ClientProxy::fn for_bus_finish -->
Finishes an operation started with `gclue_client_proxy_new_for_bus()`.
## `res`
The `GAsyncResult` obtained from the `GAsyncReadyCallback` passed to `gclue_client_proxy_new_for_bus()`.

# Returns

The constructed proxy object or [`None`] if `error` is set.
<!-- impl ClientProxy::fn for_bus_sync -->
Like `gclue_client_proxy_new_sync()` but takes a `GBusType` instead of a `GDBusConnection`.

The calling thread is blocked until a reply is received.

See `gclue_client_proxy_new_for_bus()` for the asynchronous version of this constructor.
## `bus_type`
A `GBusType`.
## `flags`
Flags from the `GDBusProxyFlags` enumeration.
## `name`
A bus name (well-known or unique).
## `object_path`
An object path.
## `cancellable`
A `GCancellable` or [`None`].

# Returns

The constructed proxy object or [`None`] if `error` is set.
<!-- impl ClientProxy::fn new_sync -->
Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Client.top_of_page">org.freedesktop.GeoClue2.Client`</link>`. See `g_dbus_proxy_new_sync()` for more details.

The calling thread is blocked until a reply is received.

See `gclue_client_proxy_new()` for the asynchronous version of this constructor.
## `connection`
A `GDBusConnection`.
## `flags`
Flags from the `GDBusProxyFlags` enumeration.
## `name`
A bus name (well-known or unique) or [`None`] if `connection` is not a message bus connection.
## `object_path`
An object path.
## `cancellable`
A `GCancellable` or [`None`].

# Returns

The constructed proxy object or [`None`] if `error` is set.
<!-- impl ClientProxy::fn create -->
A utility function to create a [`ClientProxy`][crate::ClientProxy] without having to deal with
a [`Manager`][crate::Manager]. See also `gclue_client_proxy_create_full()` which improves
resource management.

This is identitcal to calling `gclue_client_proxy_create_full()` without any
flags set.

See `gclue_client_proxy_create_sync()` for the synchronous, blocking version
of this function.
## `desktop_id`
The desktop file id (the basename of the desktop file).
## `accuracy_level`
The requested accuracy level as [`AccuracyLevel`][crate::AccuracyLevel].
## `cancellable`
A `GCancellable` or [`None`].
## `callback`
A `GAsyncReadyCallback` to call when the results are ready.
<!-- impl ClientProxy::fn create_finish -->
Finishes an operation started with `gclue_client_proxy_create()`.
## `result`
The `GAsyncResult` obtained from the `GAsyncReadyCallback` passed to
 `gclue_client_proxy_create()`.

# Returns

The constructed proxy
object or [`None`] if `error` is set.
<!-- impl ClientProxy::fn create_full -->
A utility function to create a [`ClientProxy`][crate::ClientProxy] without having to deal with
a [`Manager`][crate::Manager].

By setting the [`ClientProxyCreateFlags::AUTO_DELETE`][crate::ClientProxyCreateFlags::AUTO_DELETE] flag you can ensure
that the client will be deleted again from the geoclue service when
it is destroyed. This flag should be used unless you are doing explicit
resource management.

See `gclue_client_proxy_create_full_sync()` for the synchronous, blocking
version of this function.
## `desktop_id`
The desktop file id (the basename of the desktop file).
## `accuracy_level`
The requested accuracy level as [`AccuracyLevel`][crate::AccuracyLevel].
## `flags`
[`ClientProxyCreateFlags`][crate::ClientProxyCreateFlags] to modify the creation.
## `cancellable`
A `GCancellable` or [`None`].
## `callback`
A `GAsyncReadyCallback` to call when the results are ready.
<!-- impl ClientProxy::fn create_full_finish -->
Finishes an operation started with `gclue_client_proxy_create_full()`.
## `result`
The `GAsyncResult` obtained from the `GAsyncReadyCallback` passed to
 `gclue_client_proxy_create()`.

# Returns

The constructed proxy
object or [`None`] if `error` is set.
<!-- impl ClientProxy::fn create_full_sync -->
The synchronous and blocking version of `gclue_client_proxy_create_full()`.

By setting the [`ClientProxyCreateFlags::AUTO_DELETE`][crate::ClientProxyCreateFlags::AUTO_DELETE] flag you can ensure
that the client will be deleted again from the geoclue service when
it is destroyed. This flag should be used unless you are doing explicit
resource management.
## `desktop_id`
The desktop file id (the basename of the desktop file).
## `accuracy_level`
The requested accuracy level as [`AccuracyLevel`][crate::AccuracyLevel].
## `flags`
[`ClientProxyCreateFlags`][crate::ClientProxyCreateFlags] to modify the creation.
## `cancellable`
A `GCancellable` or [`None`].

# Returns

The constructed proxy
object or [`None`] if `error` is set.
<!-- impl ClientProxy::fn create_sync -->
The synchronous and blocking version of `gclue_client_proxy_create()`.
See also `gclue_client_proxy_create_full_sync()` which improves resource
management.

This function is identical to calling `gclue_client_proxy_create_full_sync()`
without any flags set.
## `desktop_id`
The desktop file id (the basename of the desktop file).
## `accuracy_level`
The requested accuracy level as [`AccuracyLevel`][crate::AccuracyLevel].
## `cancellable`
A `GCancellable` or [`None`].

# Returns

The constructed proxy
object or [`None`] if `error` is set.
<!-- impl ClientProxy::fn new -->
Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Client.top_of_page">org.freedesktop.GeoClue2.Client`</link>`. See `g_dbus_proxy_new()` for more details.

When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `g_main_context_push_thread_default()`).
You can then call `gclue_client_proxy_new_finish()` to get the result of the operation.

See `gclue_client_proxy_new_sync()` for the synchronous, blocking version of this constructor.
## `connection`
A `GDBusConnection`.
## `flags`
Flags from the `GDBusProxyFlags` enumeration.
## `name`
A bus name (well-known or unique) or [`None`] if `connection` is not a message bus connection.
## `object_path`
An object path.
## `cancellable`
A `GCancellable` or [`None`].
## `callback`
A `GAsyncReadyCallback` to call when the request is satisfied.
<!-- impl ClientProxy::fn new_for_bus -->
Like `gclue_client_proxy_new()` but takes a `GBusType` instead of a `GDBusConnection`.

When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `g_main_context_push_thread_default()`).
You can then call `gclue_client_proxy_new_for_bus_finish()` to get the result of the operation.

See `gclue_client_proxy_new_for_bus_sync()` for the synchronous, blocking version of this constructor.
## `bus_type`
A `GBusType`.
## `flags`
Flags from the `GDBusProxyFlags` enumeration.
## `name`
A bus name (well-known or unique).
## `object_path`
An object path.
## `cancellable`
A `GCancellable` or [`None`].
## `callback`
A `GAsyncReadyCallback` to call when the request is satisfied.
<!-- struct ClientProxyCreateFlags -->
<!-- struct Location -->
Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Location.top_of_page">org.freedesktop.GeoClue2.Location`</link>`.

# Implements

[`LocationExt`][trait@crate::prelude::LocationExt]
<!-- trait LocationExt -->
Trait containing all [`struct@Location`] methods.

# Implementors

[`LocationProxy`][struct@crate::LocationProxy], [`LocationSkeleton`][struct@crate::LocationSkeleton], [`Location`][struct@crate::Location]
<!-- impl Location::fn interface_info -->
Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Location.top_of_page">org.freedesktop.GeoClue2.Location`</link>` D-Bus interface.

# Returns

A `GDBusInterfaceInfo`. Do not free.
<!-- impl Location::fn override_properties -->
Overrides all `GObject` properties in the [`Location`][crate::Location] interface for a concrete class.
The properties are overridden in the order they are defined.
## `klass`
The class structure for a `GObject` derived class.
## `property_id_begin`
The property id to assign to the first overridden property.

# Returns

The last property id.
<!-- trait LocationExt::fn dup_description -->
Gets a copy of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Description">"Description"`</link>` D-Bus property.

Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.

# Returns

The property value or [`None`] if the property is not set. The returned value should be freed with `g_free()`.
<!-- trait LocationExt::fn dup_timestamp -->
Gets a copy of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Timestamp">"Timestamp"`</link>` D-Bus property.

Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.

# Returns

The property value or [`None`] if the property is not set. The returned value should be freed with `g_variant_unref()`.
<!-- trait LocationExt::fn accuracy -->
Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Accuracy">"Accuracy"`</link>` D-Bus property.

Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.

# Returns

The property value.
<!-- trait LocationExt::fn altitude -->
Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Altitude">"Altitude"`</link>` D-Bus property.

Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.

# Returns

The property value.
<!-- trait LocationExt::fn description -->
Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Description">"Description"`</link>` D-Bus property.

Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.

The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where `self` was constructed. Use [`dup_description()`][Self::dup_description()] if on another thread.

# Returns

The property value or [`None`] if the property is not set. Do not free the returned value, it belongs to `self`.
<!-- trait LocationExt::fn heading -->
Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Heading">"Heading"`</link>` D-Bus property.

Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.

# Returns

The property value.
<!-- trait LocationExt::fn latitude -->
Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Latitude">"Latitude"`</link>` D-Bus property.

Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.

# Returns

The property value.
<!-- trait LocationExt::fn longitude -->
Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Longitude">"Longitude"`</link>` D-Bus property.

Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.

# Returns

The property value.
<!-- trait LocationExt::fn speed -->
Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Speed">"Speed"`</link>` D-Bus property.

Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.

# Returns

The property value.
<!-- trait LocationExt::fn timestamp -->
Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Timestamp">"Timestamp"`</link>` D-Bus property.

Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.

The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where `self` was constructed. Use `gclue_location_dup_timestamp()` if on another thread.

# Returns

The property value or [`None`] if the property is not set. Do not free the returned value, it belongs to `self`.
<!-- trait LocationExt::fn set_accuracy -->
Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Accuracy">"Accuracy"`</link>` D-Bus property to `value`.

Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
## `value`
The value to set.
<!-- trait LocationExt::fn set_altitude -->
Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Altitude">"Altitude"`</link>` D-Bus property to `value`.

Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
## `value`
The value to set.
<!-- trait LocationExt::fn set_description -->
Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Description">"Description"`</link>` D-Bus property to `value`.

Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
## `value`
The value to set.
<!-- trait LocationExt::fn set_heading -->
Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Heading">"Heading"`</link>` D-Bus property to `value`.

Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
## `value`
The value to set.
<!-- trait LocationExt::fn set_latitude -->
Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Latitude">"Latitude"`</link>` D-Bus property to `value`.

Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
## `value`
The value to set.
<!-- trait LocationExt::fn set_longitude -->
Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Longitude">"Longitude"`</link>` D-Bus property to `value`.

Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
## `value`
The value to set.
<!-- trait LocationExt::fn set_speed -->
Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Speed">"Speed"`</link>` D-Bus property to `value`.

Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
## `value`
The value to set.
<!-- trait LocationExt::fn set_timestamp -->
Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Timestamp">"Timestamp"`</link>` D-Bus property to `value`.

Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
## `value`
The value to set.
<!-- struct LocationProxy -->
The [`LocationProxy`][crate::LocationProxy] structure contains only private data and should only be accessed using the provided API.

# Implements

[`LocationExt`][trait@crate::prelude::LocationExt]
<!-- impl LocationProxy::fn new_finish -->
Finishes an operation started with `gclue_location_proxy_new()`.
## `res`
The `GAsyncResult` obtained from the `GAsyncReadyCallback` passed to `gclue_location_proxy_new()`.

# Returns

The constructed proxy object or [`None`] if `error` is set.
<!-- impl LocationProxy::fn for_bus_finish -->
Finishes an operation started with `gclue_location_proxy_new_for_bus()`.
## `res`
The `GAsyncResult` obtained from the `GAsyncReadyCallback` passed to `gclue_location_proxy_new_for_bus()`.

# Returns

The constructed proxy object or [`None`] if `error` is set.
<!-- impl LocationProxy::fn for_bus_sync -->
Like `gclue_location_proxy_new_sync()` but takes a `GBusType` instead of a `GDBusConnection`.

The calling thread is blocked until a reply is received.

See `gclue_location_proxy_new_for_bus()` for the asynchronous version of this constructor.
## `bus_type`
A `GBusType`.
## `flags`
Flags from the `GDBusProxyFlags` enumeration.
## `name`
A bus name (well-known or unique).
## `object_path`
An object path.
## `cancellable`
A `GCancellable` or [`None`].

# Returns

The constructed proxy object or [`None`] if `error` is set.
<!-- impl LocationProxy::fn new_sync -->
Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Location.top_of_page">org.freedesktop.GeoClue2.Location`</link>`. See `g_dbus_proxy_new_sync()` for more details.

The calling thread is blocked until a reply is received.

See `gclue_location_proxy_new()` for the asynchronous version of this constructor.
## `connection`
A `GDBusConnection`.
## `flags`
Flags from the `GDBusProxyFlags` enumeration.
## `name`
A bus name (well-known or unique) or [`None`] if `connection` is not a message bus connection.
## `object_path`
An object path.
## `cancellable`
A `GCancellable` or [`None`].

# Returns

The constructed proxy object or [`None`] if `error` is set.
<!-- impl LocationProxy::fn new -->
Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Location.top_of_page">org.freedesktop.GeoClue2.Location`</link>`. See `g_dbus_proxy_new()` for more details.

When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `g_main_context_push_thread_default()`).
You can then call `gclue_location_proxy_new_finish()` to get the result of the operation.

See `gclue_location_proxy_new_sync()` for the synchronous, blocking version of this constructor.
## `connection`
A `GDBusConnection`.
## `flags`
Flags from the `GDBusProxyFlags` enumeration.
## `name`
A bus name (well-known or unique) or [`None`] if `connection` is not a message bus connection.
## `object_path`
An object path.
## `cancellable`
A `GCancellable` or [`None`].
## `callback`
A `GAsyncReadyCallback` to call when the request is satisfied.
<!-- impl LocationProxy::fn new_for_bus -->
Like `gclue_location_proxy_new()` but takes a `GBusType` instead of a `GDBusConnection`.

When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `g_main_context_push_thread_default()`).
You can then call `gclue_location_proxy_new_for_bus_finish()` to get the result of the operation.

See `gclue_location_proxy_new_for_bus_sync()` for the synchronous, blocking version of this constructor.
## `bus_type`
A `GBusType`.
## `flags`
Flags from the `GDBusProxyFlags` enumeration.
## `name`
A bus name (well-known or unique).
## `object_path`
An object path.
## `cancellable`
A `GCancellable` or [`None`].
## `callback`
A `GAsyncReadyCallback` to call when the request is satisfied.
<!-- struct LocationSkeleton -->
The [`LocationSkeleton`][crate::LocationSkeleton] structure contains only private data and should only be accessed using the provided API.

# Implements

[`LocationExt`][trait@crate::prelude::LocationExt]
<!-- impl LocationSkeleton::fn new -->
Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Location.top_of_page">org.freedesktop.GeoClue2.Location`</link>`.

# Returns

The skeleton object.
<!-- struct Manager -->
Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager`</link>`.

# Implements

[`ManagerExt`][trait@crate::prelude::ManagerExt]
<!-- trait ManagerExt -->
Trait containing all [`struct@Manager`] methods.

# Implementors

[`ManagerProxy`][struct@crate::ManagerProxy], [`ManagerSkeleton`][struct@crate::ManagerSkeleton], [`Manager`][struct@crate::Manager]
<!-- impl Manager::fn interface_info -->
Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager`</link>` D-Bus interface.

# Returns

A `GDBusInterfaceInfo`. Do not free.
<!-- impl Manager::fn override_properties -->
Overrides all `GObject` properties in the [`Manager`][crate::Manager] interface for a concrete class.
The properties are overridden in the order they are defined.
## `klass`
The class structure for a `GObject` derived class.
## `property_id_begin`
The property id to assign to the first overridden property.

# Returns

The last property id.
<!-- trait ManagerExt::fn call_add_agent -->
Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.AddAgent">AddAgent()`</link>` D-Bus method on `self`.
When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `g_main_context_push_thread_default()`).
You can then call `gclue_manager_call_add_agent_finish()` to get the result of the operation.

See `gclue_manager_call_add_agent_sync()` for the synchronous, blocking version of this method.
## `arg_id`
Argument to pass with the method invocation.
## `cancellable`
A `GCancellable` or [`None`].
## `callback`
A `GAsyncReadyCallback` to call when the request is satisfied or [`None`].
<!-- trait ManagerExt::fn call_add_agent_finish -->
Finishes an operation started with `gclue_manager_call_add_agent()`.
## `res`
The `GAsyncResult` obtained from the `GAsyncReadyCallback` passed to `gclue_manager_call_add_agent()`.

# Returns

[`true`] if the call succeeded, [`false`] if `error` is set.
<!-- trait ManagerExt::fn call_add_agent_sync -->
Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.AddAgent">AddAgent()`</link>` D-Bus method on `self`. The calling thread is blocked until a reply is received.

See `gclue_manager_call_add_agent()` for the asynchronous version of this method.
## `arg_id`
Argument to pass with the method invocation.
## `cancellable`
A `GCancellable` or [`None`].

# Returns

[`true`] if the call succeeded, [`false`] if `error` is set.
<!-- trait ManagerExt::fn call_create_client -->
Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.CreateClient">CreateClient()`</link>` D-Bus method on `self`.
When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `g_main_context_push_thread_default()`).
You can then call `gclue_manager_call_create_client_finish()` to get the result of the operation.

See `gclue_manager_call_create_client_sync()` for the synchronous, blocking version of this method.
## `cancellable`
A `GCancellable` or [`None`].
## `callback`
A `GAsyncReadyCallback` to call when the request is satisfied or [`None`].
<!-- trait ManagerExt::fn call_create_client_finish -->
Finishes an operation started with `gclue_manager_call_create_client()`.
## `res`
The `GAsyncResult` obtained from the `GAsyncReadyCallback` passed to `gclue_manager_call_create_client()`.

# Returns

[`true`] if the call succeeded, [`false`] if `error` is set.

## `out_client`
Return location for return parameter or [`None`] to ignore.
<!-- trait ManagerExt::fn call_create_client_sync -->
Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.CreateClient">CreateClient()`</link>` D-Bus method on `self`. The calling thread is blocked until a reply is received.

See `gclue_manager_call_create_client()` for the asynchronous version of this method.
## `cancellable`
A `GCancellable` or [`None`].

# Returns

[`true`] if the call succeeded, [`false`] if `error` is set.

## `out_client`
Return location for return parameter or [`None`] to ignore.
<!-- trait ManagerExt::fn call_delete_client -->
Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.DeleteClient">DeleteClient()`</link>` D-Bus method on `self`.
When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `g_main_context_push_thread_default()`).
You can then call `gclue_manager_call_delete_client_finish()` to get the result of the operation.

See `gclue_manager_call_delete_client_sync()` for the synchronous, blocking version of this method.
## `arg_client`
Argument to pass with the method invocation.
## `cancellable`
A `GCancellable` or [`None`].
## `callback`
A `GAsyncReadyCallback` to call when the request is satisfied or [`None`].
<!-- trait ManagerExt::fn call_delete_client_finish -->
Finishes an operation started with `gclue_manager_call_delete_client()`.
## `res`
The `GAsyncResult` obtained from the `GAsyncReadyCallback` passed to `gclue_manager_call_delete_client()`.

# Returns

[`true`] if the call succeeded, [`false`] if `error` is set.
<!-- trait ManagerExt::fn call_delete_client_sync -->
Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.DeleteClient">DeleteClient()`</link>` D-Bus method on `self`. The calling thread is blocked until a reply is received.

See `gclue_manager_call_delete_client()` for the asynchronous version of this method.
## `arg_client`
Argument to pass with the method invocation.
## `cancellable`
A `GCancellable` or [`None`].

# Returns

[`true`] if the call succeeded, [`false`] if `error` is set.
<!-- trait ManagerExt::fn call_get_client -->
Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.GetClient">GetClient()`</link>` D-Bus method on `self`.
When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `g_main_context_push_thread_default()`).
You can then call `gclue_manager_call_get_client_finish()` to get the result of the operation.

See `gclue_manager_call_get_client_sync()` for the synchronous, blocking version of this method.
## `cancellable`
A `GCancellable` or [`None`].
## `callback`
A `GAsyncReadyCallback` to call when the request is satisfied or [`None`].
<!-- trait ManagerExt::fn call_get_client_finish -->
Finishes an operation started with `gclue_manager_call_get_client()`.
## `res`
The `GAsyncResult` obtained from the `GAsyncReadyCallback` passed to `gclue_manager_call_get_client()`.

# Returns

[`true`] if the call succeeded, [`false`] if `error` is set.

## `out_client`
Return location for return parameter or [`None`] to ignore.
<!-- trait ManagerExt::fn call_get_client_sync -->
Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.GetClient">GetClient()`</link>` D-Bus method on `self`. The calling thread is blocked until a reply is received.

See `gclue_manager_call_get_client()` for the asynchronous version of this method.
## `cancellable`
A `GCancellable` or [`None`].

# Returns

[`true`] if the call succeeded, [`false`] if `error` is set.

## `out_client`
Return location for return parameter or [`None`] to ignore.
<!-- trait ManagerExt::fn complete_add_agent -->
Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.AddAgent">AddAgent()`</link>` D-Bus method. If you instead want to finish handling an invocation by returning an error, use `g_dbus_method_invocation_return_error()` or similar.

This method will free `invocation`, you cannot use it afterwards.
## `invocation`
A `GDBusMethodInvocation`.
<!-- trait ManagerExt::fn complete_create_client -->
Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.CreateClient">CreateClient()`</link>` D-Bus method. If you instead want to finish handling an invocation by returning an error, use `g_dbus_method_invocation_return_error()` or similar.

This method will free `invocation`, you cannot use it afterwards.
## `invocation`
A `GDBusMethodInvocation`.
## `client`
Parameter to return.
<!-- trait ManagerExt::fn complete_delete_client -->
Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.DeleteClient">DeleteClient()`</link>` D-Bus method. If you instead want to finish handling an invocation by returning an error, use `g_dbus_method_invocation_return_error()` or similar.

This method will free `invocation`, you cannot use it afterwards.
## `invocation`
A `GDBusMethodInvocation`.
<!-- trait ManagerExt::fn complete_get_client -->
Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.GetClient">GetClient()`</link>` D-Bus method. If you instead want to finish handling an invocation by returning an error, use `g_dbus_method_invocation_return_error()` or similar.

This method will free `invocation`, you cannot use it afterwards.
## `invocation`
A `GDBusMethodInvocation`.
## `client`
Parameter to return.
<!-- trait ManagerExt::fn available_accuracy_level -->
Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Manager.AvailableAccuracyLevel">"AvailableAccuracyLevel"`</link>` D-Bus property.

Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.

# Returns

The property value.
<!-- trait ManagerExt::fn is_in_use -->
Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Manager.InUse">"InUse"`</link>` D-Bus property.

Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.

# Returns

The property value.
<!-- trait ManagerExt::fn set_available_accuracy_level -->
Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Manager.AvailableAccuracyLevel">"AvailableAccuracyLevel"`</link>` D-Bus property to `value`.

Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
## `value`
The value to set.
<!-- trait ManagerExt::fn set_in_use -->
Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Manager.InUse">"InUse"`</link>` D-Bus property to `value`.

Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
## `value`
The value to set.
<!-- trait ManagerExt::fn connect_handle_add_agent -->
Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.AddAgent">AddAgent()`</link>` D-Bus method.

If a signal handler returns [`true`], it means the signal handler will handle the invocation (e.g. take a reference to `invocation` and eventually call `gclue_manager_complete_add_agent()` or e.g. `g_dbus_method_invocation_return_error()` on it) and no order signal handlers will run. If no signal handler handles the invocation, the `G_DBUS_ERROR_UNKNOWN_METHOD` error is returned.
## `invocation`
A `GDBusMethodInvocation`.
## `arg_id`
Argument passed by remote caller.

# Returns

`G_DBUS_METHOD_INVOCATION_HANDLED` or [`true`] if the invocation was handled, `G_DBUS_METHOD_INVOCATION_UNHANDLED` or [`false`] to let other signal handlers run.
<!-- trait ManagerExt::fn connect_handle_create_client -->
Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.CreateClient">CreateClient()`</link>` D-Bus method.

If a signal handler returns [`true`], it means the signal handler will handle the invocation (e.g. take a reference to `invocation` and eventually call `gclue_manager_complete_create_client()` or e.g. `g_dbus_method_invocation_return_error()` on it) and no order signal handlers will run. If no signal handler handles the invocation, the `G_DBUS_ERROR_UNKNOWN_METHOD` error is returned.
## `invocation`
A `GDBusMethodInvocation`.

# Returns

`G_DBUS_METHOD_INVOCATION_HANDLED` or [`true`] if the invocation was handled, `G_DBUS_METHOD_INVOCATION_UNHANDLED` or [`false`] to let other signal handlers run.
<!-- trait ManagerExt::fn connect_handle_delete_client -->
Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.DeleteClient">DeleteClient()`</link>` D-Bus method.

If a signal handler returns [`true`], it means the signal handler will handle the invocation (e.g. take a reference to `invocation` and eventually call `gclue_manager_complete_delete_client()` or e.g. `g_dbus_method_invocation_return_error()` on it) and no order signal handlers will run. If no signal handler handles the invocation, the `G_DBUS_ERROR_UNKNOWN_METHOD` error is returned.
## `invocation`
A `GDBusMethodInvocation`.
## `arg_client`
Argument passed by remote caller.

# Returns

`G_DBUS_METHOD_INVOCATION_HANDLED` or [`true`] if the invocation was handled, `G_DBUS_METHOD_INVOCATION_UNHANDLED` or [`false`] to let other signal handlers run.
<!-- trait ManagerExt::fn connect_handle_get_client -->
Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.GetClient">GetClient()`</link>` D-Bus method.

If a signal handler returns [`true`], it means the signal handler will handle the invocation (e.g. take a reference to `invocation` and eventually call `gclue_manager_complete_get_client()` or e.g. `g_dbus_method_invocation_return_error()` on it) and no order signal handlers will run. If no signal handler handles the invocation, the `G_DBUS_ERROR_UNKNOWN_METHOD` error is returned.
## `invocation`
A `GDBusMethodInvocation`.

# Returns

`G_DBUS_METHOD_INVOCATION_HANDLED` or [`true`] if the invocation was handled, `G_DBUS_METHOD_INVOCATION_UNHANDLED` or [`false`] to let other signal handlers run.
<!-- trait ManagerExt::fn in_use -->
Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Manager.InUse">"InUse"`</link>`.

Since the D-Bus property for this `GObject` property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
<!-- struct ManagerProxy -->
The [`ManagerProxy`][crate::ManagerProxy] structure contains only private data and should only be accessed using the provided API.

# Implements

[`ManagerExt`][trait@crate::prelude::ManagerExt]
<!-- impl ManagerProxy::fn new_finish -->
Finishes an operation started with `gclue_manager_proxy_new()`.
## `res`
The `GAsyncResult` obtained from the `GAsyncReadyCallback` passed to `gclue_manager_proxy_new()`.

# Returns

The constructed proxy object or [`None`] if `error` is set.
<!-- impl ManagerProxy::fn for_bus_finish -->
Finishes an operation started with `gclue_manager_proxy_new_for_bus()`.
## `res`
The `GAsyncResult` obtained from the `GAsyncReadyCallback` passed to `gclue_manager_proxy_new_for_bus()`.

# Returns

The constructed proxy object or [`None`] if `error` is set.
<!-- impl ManagerProxy::fn for_bus_sync -->
Like `gclue_manager_proxy_new_sync()` but takes a `GBusType` instead of a `GDBusConnection`.

The calling thread is blocked until a reply is received.

See `gclue_manager_proxy_new_for_bus()` for the asynchronous version of this constructor.
## `bus_type`
A `GBusType`.
## `flags`
Flags from the `GDBusProxyFlags` enumeration.
## `name`
A bus name (well-known or unique).
## `object_path`
An object path.
## `cancellable`
A `GCancellable` or [`None`].

# Returns

The constructed proxy object or [`None`] if `error` is set.
<!-- impl ManagerProxy::fn new_sync -->
Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager`</link>`. See `g_dbus_proxy_new_sync()` for more details.

The calling thread is blocked until a reply is received.

See `gclue_manager_proxy_new()` for the asynchronous version of this constructor.
## `connection`
A `GDBusConnection`.
## `flags`
Flags from the `GDBusProxyFlags` enumeration.
## `name`
A bus name (well-known or unique) or [`None`] if `connection` is not a message bus connection.
## `object_path`
An object path.
## `cancellable`
A `GCancellable` or [`None`].

# Returns

The constructed proxy object or [`None`] if `error` is set.
<!-- impl ManagerProxy::fn new -->
Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager`</link>`. See `g_dbus_proxy_new()` for more details.

When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `g_main_context_push_thread_default()`).
You can then call `gclue_manager_proxy_new_finish()` to get the result of the operation.

See `gclue_manager_proxy_new_sync()` for the synchronous, blocking version of this constructor.
## `connection`
A `GDBusConnection`.
## `flags`
Flags from the `GDBusProxyFlags` enumeration.
## `name`
A bus name (well-known or unique) or [`None`] if `connection` is not a message bus connection.
## `object_path`
An object path.
## `cancellable`
A `GCancellable` or [`None`].
## `callback`
A `GAsyncReadyCallback` to call when the request is satisfied.
<!-- impl ManagerProxy::fn new_for_bus -->
Like `gclue_manager_proxy_new()` but takes a `GBusType` instead of a `GDBusConnection`.

When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `g_main_context_push_thread_default()`).
You can then call `gclue_manager_proxy_new_for_bus_finish()` to get the result of the operation.

See `gclue_manager_proxy_new_for_bus_sync()` for the synchronous, blocking version of this constructor.
## `bus_type`
A `GBusType`.
## `flags`
Flags from the `GDBusProxyFlags` enumeration.
## `name`
A bus name (well-known or unique).
## `object_path`
An object path.
## `cancellable`
A `GCancellable` or [`None`].
## `callback`
A `GAsyncReadyCallback` to call when the request is satisfied.
<!-- struct ManagerSkeleton -->
The [`ManagerSkeleton`][crate::ManagerSkeleton] structure contains only private data and should only be accessed using the provided API.

# Implements

[`ManagerExt`][trait@crate::prelude::ManagerExt]
<!-- impl ManagerSkeleton::fn new -->
Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager`</link>`.

# Returns

The skeleton object.
<!-- struct Simple -->


# Implements

[`SimpleExt`][trait@crate::prelude::SimpleExt]
<!-- trait SimpleExt -->
Trait containing all [`struct@Simple`] methods.

# Implementors

[`Simple`][struct@crate::Simple]
<!-- impl Simple::fn new_finish -->
Finishes an operation started with `gclue_simple_new()`.
## `result`
The `GAsyncResult` obtained from the `GAsyncReadyCallback` passed to
 `gclue_simple_new()`.

# Returns

The constructed proxy
object or [`None`] if `error` is set.
<!-- impl Simple::fn new_sync -->
The synchronous and blocking version of `gclue_simple_new()`.
## `desktop_id`
The desktop file id (the basename of the desktop file).
## `accuracy_level`
The requested accuracy level as [`AccuracyLevel`][crate::AccuracyLevel].
## `cancellable`
A `GCancellable` or [`None`].

# Returns

The new [`Simple`][crate::Simple] object or
[`None`] if `error` is set.
<!-- impl Simple::fn new -->
Asynchronously creates a [`Simple`][crate::Simple] instance. Use
`gclue_simple_new_finish()` to get the created [`Simple`][crate::Simple] instance.

See `gclue_simple_new_sync()` for the synchronous, blocking version
of this function.
## `desktop_id`
The desktop file id (the basename of the desktop file).
## `accuracy_level`
The requested accuracy level as [`AccuracyLevel`][crate::AccuracyLevel].
## `cancellable`
A `GCancellable` or [`None`].
## `callback`
A `GAsyncReadyCallback` to call when the results are ready.
<!-- trait SimpleExt::fn client -->
Gets the client proxy.

# Returns

The client object.
<!-- trait SimpleExt::fn location -->
Gets the current location.

# Returns

The last known location
as [`Location`][crate::Location].
<!-- trait SimpleExt::fn set_accuracy_level -->
The requested maximum accuracy level.
<!-- trait SimpleExt::fn set_desktop_id -->
The Desktop ID of the application.
