pub struct Matrix<T: Clone + Copy> {
    matrix: Vec<Vec<Option<T>>>,
}

impl<T: Clone + Copy> Matrix<T> {
    pub fn new(size: (usize, usize)) -> Matrix<T> {
        let (m, n) = size;
        let mut matrix: Vec<Vec<Option<T>>> = Vec::new();

        let row = vec![None; n];

        for _ in 0..m {
            matrix.push(row.clone());
        }

        return Matrix::<T> { matrix };
    }

    pub fn get(&self, pos: (usize, usize)) -> Option<T> {
        let (m, n) = pos;

        return self.matrix[m][n];
    }

    pub fn get_ref(&self, pos: (usize, usize)) -> Option<&T> {
        let (m, n) = pos;

        return self.matrix[m][n].as_ref();
    }

    pub fn get_mut(&mut self, pos: (usize, usize)) -> Option<&mut T> {
        let (m, n) = pos;

        return self.matrix[m][n].as_mut();
    }

    pub fn set(&mut self, item: T, pos: (usize, usize)) {
        let (m, n) = pos;
        self.matrix[m][n] = Some(item);
    }
}

impl<T: Clone + Copy> From<Vec<Vec<T>>> for Matrix<T> {
    fn from(items: Vec<Vec<T>>) -> Self {
        let m = items.len();
        let n = items.first().unwrap().len();
        let mut matrix = Matrix::new((m, n));

        for i in 0..m {
            for j in 0..n {
                matrix.set(items[i][j], (i, j));
            }
        }

        return matrix;
    }
}
