use std::pin::Pin;

use crate::{Generator, GeneratorState};

struct Iter<G> {
    generator: Pin<Box<G>>,
}

pub fn iterate<G>(generator: G) -> impl Iterator<Item = G::Yield>
where
    G: Generator,
{
    Iter {
        generator: Box::pin(generator),
    }
}

impl<G> Iterator for Iter<G>
where
    G: Generator,
{
    type Item = G::Yield;

    fn next(&mut self) -> Option<Self::Item> {
        match self.generator.as_mut().resume(()) {
            GeneratorState::Yielded(val) => Some(val),
            GeneratorState::Complete(_) => None,
        }
    }
}
