//! Provides hundreds of useful functions for manipulating strings, files,
//! numbers, value conversion, etc.
//! 
//! # Examples
//! 
//! ## Example 1 (Module [`conversions`])
//! 
//! Cargo.toml File:
//! ```
//! [package]
//! name = "project_name"
//! version = "0.0.1"
//! edition = "2021"
//! 
//! [dependencies]
//! general_tools = "latest version"
//! ```
//! __src\main.rs__ File:
//! ```
//! use general_tools::conversions::temperature::Temperature;
//! 
//! fn main() {
//! 	let celsius: Temperature = Temperature{
//! 		temperature_type: String::from("Celsius"),
//! 		value: 10.0
//! 	};
//! 
//! 	// or:
//! 	/*
//! 		let mut celsius: Temperature = Temperature::new();
//! 		
//! 		celsius.temperature_type = String::from("Celsius");
//! 		celsius.value = 10.0;
//!		*/
//! 
//! 	let fahrenheit: f64 = celsius.to_fahrenheit();
//! 
//! 	println!("{} °C = {} °F", celsius.value, fahrenheit);
//! }
//! ```
//! 
//! Output: 
//! 
//! ```
//! 10.0 °C = 50.0 °F
//! ```
//! ## Example 2 (Module ```file```):
//! 
//! Cargo.toml File:
//! 
//! ```
//! [package]
//! name = "project_name"
//! version = "0.0.1"
//! edition = "2021"
//! 
//! [dependencies]
//! general_tools = "latest version"
//! ```
//! __src\main.rs__ File:
//! 
//! ```
//! use general_tools::file::File;
//! 
//! fn main() {
//! 	let mut file: File = File::new();
//! 	
//! 
//! }
//! ```
//! 
//! Output:
//! ```
//! 
//! ```
//! 
//! ## Example 3 (Module ```math```):
//! 
//! Cargo.toml File:
//! 
//! ```
//! [package]
//! name = "project_name"
//! version = "0.0.1"
//! edition = "2021"
//! 
//! [dependencies]
//! general_tools = "latest version"
//! ```
//! 
//! __src\main.rs__ File:
//! 
//! ```
//! 
//! ```
//! 
//! Output: 
//! 
//! ```
//! 
//! ```
//! 
//! ## Example 4 (Module ```string```):
//! 
//! ```
//! [package]
//! name = "project_name"
//! version = "0.0.1"
//! edition = "2021"
//! 
//! [dependencies]
//! general_tools = "latest version"
//! ```
//! 
//! __src\main.rs__ File:
//! 
//! ```
//! 
//! ```
//! 
//! Output: 
//! 
//! ```
//! 
//! ```
//! 
//! ## Example 5 (Module ```time```):
//! 
//! ```
//! [package]
//! name = "project_name"
//! version = "0.0.1"
//! edition = "2021"
//! 
//! [dependencies]
//! general_tools = "latest version"
//! ```
//! 
//! __src\main.rs__ File:
//! 
//! ```
//! 
//! ```
//! 
//! Output: 
//! 
//! ```
//! 
//! ```

/// Adds possibilities to make use of complex mathematical operations
/// complex mathematical operations, such as: roots, powers, fractions, equations, etc. Besides adding the possibility
/// to mess with the main fields (areas) of Mathematics: Geometry, Algebra
/// Analysis and Arithmetic.

pub mod math;
/// Adiciona novas funções para manipulação de strings. Tais como: Encontrar determinado
/// padrão em uma string, substituir determinado padrão por outro, etc.
pub mod string;
/// Inclui muitos tipos de conversões, tais como: Conversão de Temperaturas, Conversão
/// de Área, Conversão de Comprimento, Conversão de Distâncias, etc.
pub mod conversions;
/// Facilita a manipulação de tempo, como: Conversão de Tempo, Conversão de Horários,
/// Conversão de Data, Calcular o tempo decorrido entre duas datas, etc.
pub mod time;